# -*- coding: utf-8 -*-
import yenv


_HISTORYDB_API_URLS = {
    'other': {
        'development': 'https://kvs-loader-test-m1.passport.yandex.net/',
        'testing': 'https://kvs-loader-test-m1.passport.yandex.net/',
        'rc': 'https://historydb-api.passport.yandex.net/',
        'production': 'https://historydb-api.passport.yandex.net/',
    },
}

_HISTORYDB_API_URLS['localhost'] = _HISTORYDB_API_URLS['other']

HISTORYDB_API_USE_TVM = False
if yenv.name == 'localhost':
    HISTORYDB_API_URL = _HISTORYDB_API_URLS[yenv.name][yenv.type]
    HISTORYDB_API_USE_TVM = True
elif yenv.name == 'stress':
    HISTORYDB_API_URL = 'http://passport-fake-services.passport-load.passport.yandex.net'
else:
    HISTORYDB_API_URL = ''

# максимальное время ожидания ответа HistoryDBApi
HISTORYDB_API_TIMEOUT = 3
# используется в сценарии восстановления доступа
HISTORYDB_API_TIMEOUT_FOR_RESTORE = 4

# используется при выгрузке пользовательских данных
HISTORYDB_API_TIMEOUT_FOR_TAKEOUT = 6
HISTORYDB_API_RETRIES_FOR_TAKEOUT = 1

# число попыток получить ответ от HistoryDBApi
HISTORYDB_API_RETRIES = 2


LASTAUTH_DEFAULT_LIMIT = 10000
LASTAUTH_DEFAULT_HOURS_LIMIT = 24 * 90  # 3 месяца


ACCOUNT_HISTORY_MAX_LIMIT = 1000
ACCOUNT_HISTORY_DEFAULT_LIMIT = 50

ACCOUNT_EVENTS_MAX_LIMIT = 1000
ACCOUNT_EVENTS_DEFAULT_LIMIT = 50
