# -*- coding: utf-8 -*-
from collections import namedtuple
import socket

import yenv


_host = namedtuple('host', 'name id dc')

# список хостов с полным доменным именем, идентификатором и датацентром
# отсортирован по id!
__OTHER_HOSTS = tuple(_host(name=name, id=id, dc=dc) for name, id, dc in [
    ('passport.ya-test.ru', 0x0, 'fol'),
    # Дев / ноуты
    ('eugene311-laptop', 0xF0, 'i'),

    # Контейнере на деве (подменный домен docker для автотестов)
    ('autotests.dev.passport.yandex.net', 0x7F, 'i'),
    # Дефолт (фоллбек хост для yenv.type == 'development')
    ('localhost', 0x7F, 'i'),

    ('webadmin-s1.passport.yandex.net', 0x3B, 's'),
    ('webadmin-m1.passport.yandex.net', 0x42, 'm'),

    ('python-dev1.passport.yandex.net', 0x7F, 'myt'),
    ('python-dev2.passport.yandex.net', 0x7F, 'iva'),
    ('xenial-dev.passport.yandex.net', 0x7F, 'man'),
])


__DBSCRIPTS_HOSTS = tuple(_host(name=name, id=id, dc=dc) for name, id, dc in [
    ('passport-scripts-i1.passport.yandex.net', 0xE4, 'i'),
    ('passport-scripts-v1.passport.yandex.net', 0xE5, 'v'),
])


__DBSCRIPTS_TEST_HOSTS = tuple(_host(name=name, id=id, dc=dc) for name, id, dc in [
    ('passport-scripts-test-s1.passport.yandex.net', 0xE8, 's'),  # testing
])


__DBSCRIPTS_YATEAM_HOSTS = tuple(_host(name=name, id=id, dc=dc) for name, id, dc in [
    ('passport-scripts-yateam-m1.passport.yandex.net', 0xE6, 'm'),
    ('passport-scripts-yateam-v1.passport.yandex.net', 0xE7, 'v'),
])


__DBSCRIPTS_YATEAM_TEST_HOSTS = tuple(_host(name=name, id=id, dc=dc) for name, id, dc in [
    ('passport-scripts-yateam-test-s1.passport.yandex.net', 0xE9, 's'),  # yateam testing
])


__PASSPORT_HOSTS = tuple(_host(name=name, id=id, dc=dc) for name, id, dc in [
    ('passport-v1.passport.yandex.net',                     0x1,  'v'),
    ('v1.redis.passport.yandex.net',                        0x1,  'v'),
    ('passport-i7.passport.yandex.net',                     0x2,  'i'),
    ('i7.redis.passport.yandex.net',                        0x2,  'i'),
    ('passport-v2.passport.yandex.net',                     0x3,  'v'),
    ('v2.redis.passport.yandex.net',                        0x3,  'v'),
    ('passport-v3.passport.yandex.net',                     0x4,  'v'),
    ('v3.redis.passport.yandex.net',                        0x4,  'v'),
    ('passport-v4.passport.yandex.net',                     0x5,  'v'),
    ('v4.redis.passport.yandex.net',                        0x5,  'v'),
    ('passport-i8.passport.yandex.net',                     0x6,  'i'),
    ('i8.redis.passport.yandex.net',                        0x6,  'i'),
    ('passport-i9.passport.yandex.net',                     0x7,  'i'),
    ('i9.redis.passport.yandex.net',                        0x7,  'i'),
    ('i10.redis.passport.yandex.net',                       0x8,  'i'),
    ('passport-i10.passport.yandex.net',                    0x8,  'i'),
    ('passport-v5.passport.yandex.net',                     0xA,  'v'),
    ('v5.redis.passport.yandex.net',                        0xA,  'v'),
    ('passport-v6.passport.yandex.net',                     0xB,  'v'),
    ('v6.redis.passport.yandex.net',                        0xB,  'v'),
    ('passport-v7.passport.yandex.net',                     0xC,  'v'),
    ('v7.redis.passport.yandex.net',                        0xC,  'v'),
    ('passport-v8.passport.yandex.net',                     0xE,  'v'),
    ('v8.redis.passport.yandex.net',                        0xE,  'v'),
    ('passport-s7.passport.yandex.net',                     0xF,  's'),
    ('s7.redis.passport.yandex.net',                        0xF,  's'),
    ('passport-i1.passport.yandex.net',                     0x10, 'i'),
    ('i1.redis.passport.yandex.net',                        0x10, 'i'),
    ('passport-v9.passport.yandex.net',                     0x11, 'v'),
    ('v9.redis.passport.yandex.net',                        0x11, 'v'),
    ('passport-i2.passport.yandex.net',                     0x12, 'i'),
    ('i2.redis.passport.yandex.net',                        0x12, 'i'),
    ('passport-v10.passport.yandex.net',                    0x13, 'v'),
    ('v10.redis.passport.yandex.net',                       0x13, 'v'),
    ('passport-i3.passport.yandex.net',                     0x14, 'i'),
    ('i3.redis.passport.yandex.net',                        0x14, 'i'),
    ('passport-v11.passport.yandex.net',                    0x15, 'v'),
    ('v11.redis.passport.yandex.net',                       0x15, 'v'),
    ('passport-i4.passport.yandex.net',                     0x16, 'i'),
    ('i4.redis.passport.yandex.net',                        0x16, 'i'),
    ('passport-v12.passport.yandex.net',                    0x17, 'v'),
    ('v12.redis.passport.yandex.net',                       0x17, 'v'),
    ('passport-s8.passport.yandex.net',                     0x1A, 's'),
    ('s8.redis.passport.yandex.net',                        0x1A, 's'),
    ('passport-s9.passport.yandex.net',                     0x1B, 's'),
    ('s9.redis.passport.yandex.net',                        0x1B, 's'),
    ('passport-s10.passport.yandex.net',                    0x1C, 's'),
    ('s10.redis.passport.yandex.net',                       0x1C, 's'),
    ('passport-i5.passport.yandex.net',                     0x1D, 'i'),
    ('i5.redis.passport.yandex.net',                        0x1D, 'i'),
    ('passport-i6.passport.yandex.net',                     0x1E, 'i'),
    ('i6.redis.passport.yandex.net',                        0x1E, 'i'),
    ('passport-m1.passport.yandex.net',                     0x20, 'm'),
    ('m1.redis.passport.yandex.net',                        0x20, 'm'),  # redis tls
    ('passport-v13.passport.yandex.net',                    0x21, 'v'),
    ('v13.redis.passport.yandex.net',                       0x21, 'v'),
    ('passport-m2.passport.yandex.net',                     0x22, 'm'),
    ('m2.redis.passport.yandex.net',                        0x22, 'm'),  # redis tls
    ('passport-v14.passport.yandex.net',                    0x23, 'v'),
    ('v14.redis.passport.yandex.net',                       0x23, 'v'),
    ('passport-s16.passport.yandex.net',                    0x24, 's'),
    ('s16.redis.passport.yandex.net',                       0x24, 's'),
    ('passport-s17.passport.yandex.net',                    0x25, 's'),
    ('s17.redis.passport.yandex.net',                       0x25, 's'),
    ('passport-m11.passport.yandex.net',                    0x26, 'm'),
    ('m11.redis.passport.yandex.net',                       0x26, 'm'),  # redis tls
    ('passport-s18.passport.yandex.net',                    0x27, 's'),
    ('s18.redis.passport.yandex.net',                       0x27, 's'),
    ('passport-s19.passport.yandex.net',                    0x28, 's'),
    ('s19.redis.passport.yandex.net',                       0x28, 's'),
    ('passport-s20.passport.yandex.net',                    0x29, 's'),
    ('s20.redis.passport.yandex.net',                       0x29, 's'),
    ('passport-s21.passport.yandex.net',                    0x2A, 's'),
    ('s21.redis.passport.yandex.net',                       0x2A, 's'),
    ('passport-s22.passport.yandex.net',                    0x2B, 's'),
    ('s22.redis.passport.yandex.net',                       0x2B, 's'),
    ('passport-s23.passport.yandex.net',                    0x2C, 's'),
    ('s23.redis.passport.yandex.net',                       0x2C, 's'),
    ('passport-s24.passport.yandex.net',                    0x2D, 's'),
    ('s24.redis.passport.yandex.net',                       0x2D, 's'),
    ('passport-s25.passport.yandex.net',                    0x2E, 's'),
    ('s25.redis.passport.yandex.net',                       0x2E, 's'),
    ('passport-v15.passport.yandex.net',                    0x2F, 'v'),
    ('v15.redis.passport.yandex.net',                       0x2F, 'v'),
    ('passport-v16.passport.yandex.net',                    0x3E, 'v'),
    ('v16.redis.passport.yandex.net',                       0x3E, 'v'),
    ('passport-s30.passport.yandex.net',                    0x40, 's'),
    ('s30.redis.passport.yandex.net',                       0x40, 's'),
    ('passport-s11.passport.yandex.net',                    0x41, 's'),
    ('s11.redis.passport.yandex.net',                       0x41, 's'),
    ('passport-s12.passport.yandex.net',                    0x43, 's'),
    ('s12.redis.passport.yandex.net',                       0x43, 's'),
    ('passport-v17.passport.yandex.net',                    0x44, 'v'),
    ('v17.redis.passport.yandex.net',                       0x44, 'v'),
    ('passport-s13.passport.yandex.net',                    0x45, 's'),
    ('s13.redis.passport.yandex.net',                       0x45, 's'),
    ('passport-s14.passport.yandex.net',                    0x48, 's'),
    ('s14.redis.passport.yandex.net',                       0x48, 's'),
    ('passport-s26.passport.yandex.net',                    0x49, 's'),
    ('s26.redis.passport.yandex.net',                       0x49, 's'),
    ('passport-s1.passport.yandex.net',                     0x4A, 's'),
    ('s1.redis.passport.yandex.net',                        0x4A, 's'),
    ('passport-s2.passport.yandex.net',                     0x4B, 's'),
    ('s2.redis.passport.yandex.net',                        0x4B, 's'),
    ('passport-s3.passport.yandex.net',                     0x4C, 's'),
    ('s3.redis.passport.yandex.net',                        0x4C, 's'),
    ('passport-s4.passport.yandex.net',                     0x4D, 's'),
    ('s4.redis.passport.yandex.net',                        0x4D, 's'),
    ('passport-m12.passport.yandex.net',                    0x4F, 'm'),
    ('m12.redis.passport.yandex.net',                       0x4F, 'm'),  # redis tls
    ('passport-m7.passport.yandex.net',                     0x50, 'm'),
    ('m7.redis.passport.yandex.net',                        0x50, 'm'),  # redis tls
    ('passport-m8.passport.yandex.net',                     0x51, 'm'),
    ('m8.redis.passport.yandex.net',                        0x51, 'm'),  # redis tls
    ('passport-m9.passport.yandex.net',                     0x52, 'm'),
    ('m9.redis.passport.yandex.net',                        0x52, 'm'),  # redis tls
    ('m10.redis.passport.yandex.net',                       0x53, 'm'),  # redis tls
    ('passport-m10.passport.yandex.net',                    0x53, 'm'),
    ('passport-s5.passport.yandex.net',                     0x56, 's'),
    ('s5.redis.passport.yandex.net',                        0x56, 's'),
    ('passport-s27.passport.yandex.net',                    0x59, 's'),
    ('s27.redis.passport.yandex.net',                       0x59, 's'),
    ('passport-s28.passport.yandex.net',                    0x5C, 's'),
    ('s28.redis.passport.yandex.net',                       0x5C, 's'),
    ('passport-s29.passport.yandex.net',                    0x5E, 's'),
    ('s29.redis.passport.yandex.net',                       0x5E, 's'),
    ('passport-load.passport.yandex.net',                   0x5F, 'iva'),
    ('passport-m3.passport.yandex.net',                     0x7A, 'm'),
    ('m3.redis.passport.yandex.net',                        0x7A, 'm'),  # redis tls
    ('passport-s31.passport.yandex.net',                    0x7B, 's'),
    ('s31.redis.passport.yandex.net',                       0x7B, 's'),
    ('passport-s15.passport.yandex.net',                    0x7E, 's'),
    ('s15.redis.passport.yandex.net',                       0x7E, 's'),
    ('passport-s6.passport.yandex.net',                     0x82, 's'),
    ('s6.redis.passport.yandex.net',                        0x82, 's'),
    ('passport-i11.passport.yandex.net',                    0x83, 'i'),
    ('i11.redis.passport.yandex.net',                       0x83, 'i'),
    ('passport-i12.passport.yandex.net',                    0x84, 'i'),
    ('i12.redis.passport.yandex.net',                       0x84, 'i'),
    ('passport-m4.passport.yandex.net',                     0x85, 'm'),
    ('m4.redis.passport.yandex.net',                        0x85, 'm'),  # redis tls
    ('m5.redis.passport.yandex.net',                        0x86, 'm'),  # redis tls
    ('passport-m5.passport.yandex.net',                     0x86, 'm'),
    ('passport-m6.passport.yandex.net',                     0x87, 'm'),
    ('m6.redis.passport.yandex.net',                        0x87, 'm'),  # redis tls
])


__PASSPORT_TEST_HOSTS = tuple(_host(name=name, id=id, dc=dc) for name, id, dc in [
    ('passport-test-s1.passport.yandex.net', 0x9, 's1'),  # testing
    ('s1.redis-test.passport.yandex.net', 0x9, 's1'),  # testing
    ('passport-test-v1.passport.yandex.net', 0x8C, 'v1'),  # testing
    ('v1.redis-test.passport.yandex.net', 0x8C, 'v1'),  # testing
])


__PASSPORT_RC_HOSTS = tuple(_host(name=name, id=id, dc=dc) for name, id, dc in [
    ('passport-rc-s1.passport.yandex.net', 0xE2, 's1rc'),  # rc
    ('s1.redis-rc.passport.yandex.net', 0xE2, 's1rc'),  # rc tls
    ('passport-rc-v1.passport.yandex.net', 0xE3, 'v1rc'),  # rc
    ('v1.redis-rc.passport.yandex.net', 0xE3, 'v1rc'),  # rc tls
])


__PASSPORT_YATEAM_HOSTS = tuple(_host(name=name, id=id, dc=dc) for name, id, dc in [
    ('passport-yateam-v1.passport.yandex.net', 0x38, 'v'),
    ('v1.redis-yateam.passport.yandex.net', 0x38, 'v'),
    ('passport-yateam-i1.passport.yandex.net', 0x39, 'i'),
    ('i1.redis-yateam.passport.yandex.net', 0x39, 'i'),
    ('passport-yateam-m1.passport.yandex.net', 0x4E, 'm'),
    ('m1.redis-yateam.passport.yandex.net', 0x4E, 'm'),  # redis tls
    ('passport-yateam-s1.passport.yandex.net', 0x88, 's'),
    ('s1.redis-yateam.passport.yandex.net', 0x88, 's'),
])

__PASSPORT_YATEAM_RC_HOSTS = tuple(_host(name=name, id=id, dc=dc) for name, id, dc in [
    ('passport-yateam-rc-s1.passport.yandex.net', 0x3C, 's1rc'),
    ('s1.redis-yateam-rc.passport.yandex.net', 0x3C, 's1rc'),  # yateam rc redis-tls
    ('passport-yateam-rc-v1.passport.yandex.net', 0x3D, 'v1rc'),
    ('v1.redis-yateam-rc.passport.yandex.net', 0x3D, 'v1rc'),  # yateam rc redis-tls
])

__PASSPORT_YATEAM_TEST_HOSTS = tuple(_host(name=name, id=id, dc=dc) for name, id, dc in [
    ('passport-yateam-test-s1.passport.yandex.net', 0x54, 's1'),  # yateam testing
    ('s1.redis-yateam-test.passport.yandex.net', 0x54, 's1'),  # yateam testing redis-tls
    ('passport-yateam-test-v1.passport.yandex.net', 0x55, 'v1'),  # yateam testing
    ('v1.redis-yateam-test.passport.yandex.net', 0x55, 'v1'),  # yateam testing redis-tls
])


HOSTS = []
for hosts in [
    __OTHER_HOSTS,
    __DBSCRIPTS_HOSTS,
    __DBSCRIPTS_TEST_HOSTS,
    __DBSCRIPTS_YATEAM_HOSTS,
    __DBSCRIPTS_YATEAM_TEST_HOSTS,
    __PASSPORT_HOSTS,
    __PASSPORT_TEST_HOSTS,
    __PASSPORT_RC_HOSTS,
    __PASSPORT_YATEAM_HOSTS,
    __PASSPORT_YATEAM_TEST_HOSTS,
    __PASSPORT_YATEAM_RC_HOSTS,
]:
    HOSTS += list(hosts)


HOSTS = tuple(HOSTS)


def get_host_by_hostname(hostname):
    hosts_conf = {host.name: host for host in HOSTS}
    if yenv.type == 'development':
        default_host = hosts_conf.get('localhost')
    else:
        default_host = None
    return hosts_conf.get(hostname, default_host)


def get_host_id_by_hostname(hostname):
    host = get_host_by_hostname(hostname)
    if host is None:
        raise RuntimeError('Host %s not found in settings.HOSTS %s' % (hostname, HOSTS))
    return host.id


def get_current_dc():
    host = get_host_by_hostname(hostname=socket.getfqdn())
    if host is None:
        return
    return host.dc


def is_plus_instance():
    host = get_host_by_hostname(hostname=socket.getfqdn())
    if host is None:
        return False
    return host.name.startswith('passport-api-')
