# -*- coding: utf-8 -*-


def _get_all_supported_languages():
    languages = set()
    for domain_languages in DETECT_LANGUAGES.values():
        languages.update(domain_languages['all'])
    return {'all': list(languages), 'default': 'ru'}


def _get_mapping_for_mobile_language_suggest():
    mapping = {}
    for lang in MOBILE_RU_FALLBACK_LANGUAGES:
        mapping[lang] = lang if lang in DISPLAY_LANGUAGES else 'ru'
    return mapping

PORTAL_LANGUAGES = (
    'az',
    'be',
    'en',
    'es',
    'et',
    'fi',
    'fr',
    'he',
    'hy',
    'id',
    'ka',
    'kk',
    'lt',
    'lv',
    'pl',
    'pt',
    'ro',
    'ru',
    'tr',
    'tt',
    'uk',
    'uz',
)

# Используется в саджесте языка на регистрации, для записи в аккаунт
DETECT_LANGUAGES = {
    'yandex.ru': {'all': ['ru', 'uk', 'en'], 'default': 'ru'},
    'yandex.com': {'all': ['en', 'id', 'fr', 'fi'], 'default': 'en'},
    'yandex.ua': {'all': ['ru', 'uk'], 'default': 'ru'},
    'yandex.kz': {'all': ['kk', 'ru'], 'default': 'ru'},
    'yandex.by': {'all': ['ru'], 'default': 'ru'},
    'yandex.com.tr': {'all': ['tr', 'en'], 'default': 'tr'},
    'yandex.az': {'all': ['az', 'ru', 'en'], 'default': 'ru'},
    'yandex.com.am': {'all': ['ru', 'en'], 'default': 'ru'},
    'yandex.com.ge': {'all': ['ru', 'en'], 'default': 'ru'},
    'yandex.co.il': {'all': ['ru', 'en'], 'default': 'en'},
    'yandex.kg': {'all': ['ru', 'en'], 'default': 'ru'},
    'yandex.lt': {'all': ['lt', 'ru', 'en'], 'default': 'en'},
    'yandex.lv': {'all': ['lv', 'ru', 'en'], 'default': 'en'},
    'yandex.md': {'all': ['ru', 'en'], 'default': 'ru'},
    'yandex.tj': {'all': ['ru', 'en'], 'default': 'ru'},
    'yandex.tm': {'all': ['ru', 'en'], 'default': 'ru'},
    'yandex.uz': {'all': ['ru', 'uz', 'en'], 'default': 'ru'},
    'yandex.fi': {'all': ['fi', 'en', 'ru'], 'default': 'fi'},
    'yandex.fr': {'all': ['en', 'fr'], 'default': 'fr'},
    'yandex.ee': {'all': ['ru', 'en', 'et'], 'default': 'ru'},
    'yandex.eu': {'all': ['ru', 'en'], 'default': 'en'},
    'yandex.pl': {'all': ['pl', 'en', 'ru'], 'default': 'pl'},
    'yandex-team.ru': {'all': ['ru', 'uk', 'en'], 'default': 'ru'},
    'ya-test.ru': {'all': ['ru'], 'default': 'ru'},
}

LANGUAGE_TO_TLD_MAPPING = {
    'az': 'az',
    'be': 'by',
    'en': 'com',
    'et': 'ee',
    'fi': 'fi',
    'fr': 'fr',
    'he': 'co.il',
    'hy': 'com.am',
    'id': 'com',
    'ka': 'com.ge',
    'kk': 'kz',
    'lt': 'lt',
    'lv': 'lv',
    'pl': 'pl',
    'ru': 'ru',
    'tr': 'com.tr',
    'uk': 'ua',
    'uz': 'uz',
}

DISPLAY_LANGUAGES = (
    'az',  # Азербайджанский
    'en',
    'es',  # Испанский
    'et',  # Эстонский
    'fi',
    'fr',
    'he',
    'hy',  # Армянский
    'id',
    'ka',  # Грузинский
    'kk',  # Казахский
    'lt',
    'lv',
    'pl',
    'pt',  # Португальский
    'ru',
    'tr',
    'uk',
    'uz',  # Узбекский
)

ALL_SUPPORTED_LANGUAGES = _get_all_supported_languages()

MOBILE_RU_FALLBACK_LANGUAGES = [
    'az',  # Азербайджанский
    'hy',  # Армянский
    'be',  # Белорусский
    'kk',  # Казахский
    'ky',  # Киргизский
    'ru',
    'tg',  # Таджикский
    'tk',  # Туркменский
    'uz',  # Узбекский
    'uk',
    'ka',  # Грузинский
    'et',  # Эстонский
]

MOBILE_FALLBACKS = _get_mapping_for_mobile_language_suggest()
