
# -*- coding: utf-8 -*-
from passport.backend.api.settings.constants.common import (
    DATA_STATUS_NOT_USED,
    DATA_STATUS_OPTIONAL,
    DATA_STATUS_REQUIRED,
    DATA_TYPE_NAME,
    DATA_TYPE_PASSWORD,
    DATA_TYPE_PHONE_NUMBER,
)


LITE_ACCOUNTS_ENFORCED_COMPLETION_DENOMINATOR = 0

ALLOW_LITE_REGISTRATION = True

# Максимальный уровень домена почтового ящика, пригодный для регистрации лайта
LITE_LOGIN_MAX_DOMAIN_LEVEL = 3
# Список доменов, с ящиками на которых нельзя регистрировать лайтов
LITE_LOGIN_BLACKLISTED_DOMAINS = {
    'yandex-team.com',
    'yandex-team.com.tr',
    'yandex-team.com.ua',
    'yandex-team.net.ua',
    'yandex-team.ru',
    'forbidden-lite-registration.ru',
    'vmani.com',
    'mailsac.com',
}

# В вебном домике с указанными origin не предлагать лайт-регистрацию
DONT_PROMOTE_LITE_REGISTRATION_IN_WEB_FOR_ORIGINS = (
    'disk_app',
)

# Настройки, определяющие, какие данные будут требоваться для регистрации лайтом на мобильных
MOBILE_LITE_DATA_STATUS_DEFAULT = {
    DATA_TYPE_NAME: DATA_STATUS_OPTIONAL,
    DATA_TYPE_PHONE_NUMBER: DATA_STATUS_OPTIONAL,
    DATA_TYPE_PASSWORD: DATA_STATUS_OPTIONAL,
}

MOBILE_LITE_DATA_STATUS_BY_APP_ID_PREFIX = {
    'ru.yandex.passport.test.not_used': {
        DATA_TYPE_NAME: DATA_STATUS_NOT_USED,
        DATA_TYPE_PHONE_NUMBER: DATA_STATUS_NOT_USED,
        DATA_TYPE_PASSWORD: DATA_STATUS_NOT_USED,
    },
    'ru.yandex.passport.test.optional': {
        DATA_TYPE_NAME: DATA_STATUS_OPTIONAL,
        DATA_TYPE_PHONE_NUMBER: DATA_STATUS_OPTIONAL,
        DATA_TYPE_PASSWORD: DATA_STATUS_OPTIONAL,
    },
    'ru.yandex.passport.test.required': {
        DATA_TYPE_NAME: DATA_STATUS_REQUIRED,
        DATA_TYPE_PHONE_NUMBER: DATA_STATUS_REQUIRED,
        DATA_TYPE_PASSWORD: DATA_STATUS_REQUIRED,
    },
}
