# -*- coding: utf-8 -* #
from frozendict import frozendict
from passport.backend.utils.dc import get_current_dc
import yenv


LOGBROKER_TVM_CREDENTIALS_CONFIG = {
    'credentials_type': 'tvm',
    'tvm_alias': 'logbroker_api',
}


_LOGBROKER_WRITER_LOGBROKER_TEST = {
    'localhost': {
        'development': {
            'host': 'logbroker.yandex.net',
            'port': 2135,
            'topic': 'passport/logbroker-test-development',
            'message_class': 'passport.backend.core.protobuf.logbroker_test.logbroker_test_pb2.LogbrokerTestMessage',
            'source_id_prefix': 'passport-api-logbroker-test',
            'credentials_config': LOGBROKER_TVM_CREDENTIALS_CONFIG,
            'connect_timeout': 2.0,
        },
        'testing': {
            'host': 'logbroker.yandex.net',
            'port': 2135,
            'topic': 'passport/logbroker-test-testing',
            'message_class': 'passport.backend.core.protobuf.logbroker_test.logbroker_test_pb2.LogbrokerTestMessage',
            'source_id_prefix': 'passport-api-logbroker-test',
            'credentials_config': LOGBROKER_TVM_CREDENTIALS_CONFIG,
            'connect_timeout': 2.0,
        },
        'production': {
            'host': 'logbroker.yandex.net',
            'port': 2135,
            'topic': 'passport/logbroker-test',
            'message_class': 'passport.backend.core.protobuf.logbroker_test.logbroker_test_pb2.LogbrokerTestMessage',
            'source_id_prefix': 'passport-api-logbroker-test',
            'credentials_config': LOGBROKER_TVM_CREDENTIALS_CONFIG,
            'connect_timeout': 0.5,
        },
    },
}

_LOGBROKER_WRITER_LOGBROKER_TEST['localhost']['rc'] = _LOGBROKER_WRITER_LOGBROKER_TEST['localhost']['production']


_LOGBROKER_WRITER_CHALLENGE_PUSHES = {
    'localhost': {
        'development': frozendict({
            'host': 'lbkx.logbroker.yandex.net',
            'port': 2136,
            'ca_cert_file': '/etc/ssl/certs/ca-certificates.crt',
            'topic': 'passport/passport-challenge-pushes-testing',
            'message_class': 'passport.backend.core.protobuf.challenge_pushes.challenge_pushes_pb2.ChallengePushRequest',
            'source_id_prefix': 'passport-api-challenge-pushes',
            'credentials_config': LOGBROKER_TVM_CREDENTIALS_CONFIG,
            'connect_timeout': 2.0,
        }),
        'testing': frozendict({
            'host': 'lbkx.logbroker.yandex.net',
            'port': 2136,
            'ca_cert_file': '/etc/ssl/certs/ca-certificates.crt',
            'topic': 'passport/passport-challenge-pushes-testing',
            'message_class': 'passport.backend.core.protobuf.challenge_pushes.challenge_pushes_pb2.ChallengePushRequest',
            'source_id_prefix': 'passport-api-challenge-pushes',
            'credentials_config': LOGBROKER_TVM_CREDENTIALS_CONFIG,
            'connect_timeout': 2.0,
        }),
        'production': frozendict({
            'host': 'lbkx.logbroker.yandex.net',
            'port': 2136,
            'ca_cert_file': '/etc/ssl/certs/ca-certificates.crt',
            'topic': 'passport/passport-challenge-pushes',
            'message_class': 'passport.backend.core.protobuf.challenge_pushes.challenge_pushes_pb2.ChallengePushRequest',
            'source_id_prefix': 'passport-api-challenge-pushes',
            'credentials_config': LOGBROKER_TVM_CREDENTIALS_CONFIG,
            'connect_timeout': 1.0,
            'write_timeout': 1.0 if get_current_dc() == 'iva' else 0.5,
        }),
    },
}

_LOGBROKER_WRITER_CHALLENGE_PUSHES['localhost']['rc'] = _LOGBROKER_WRITER_CHALLENGE_PUSHES['localhost']['production'].copy()

_LOGBROKER_WRITER_TAKEOUT = {
    'localhost': {
        'development': frozendict({
            'host': 'logbroker.yandex.net',
            'port': 2135,
            'topic': 'passport/passport-takeout-tasks-development',
            'message_class': 'passport.backend.core.protobuf.takeout.takeout_pb2.TakeoutRequest',
            'source_id_prefix': 'passport-api-takeout-tasks',
            'credentials_config': LOGBROKER_TVM_CREDENTIALS_CONFIG,
            'connect_timeout': 2.0,
        }),
        'testing': frozendict({
            'host': 'logbroker.yandex.net',
            'port': 2135,
            'topic': 'passport/passport-takeout-tasks-testing',
            'message_class': 'passport.backend.core.protobuf.takeout.takeout_pb2.TakeoutRequest',
            'source_id_prefix': 'passport-api-takeout-tasks',
            'credentials_config': LOGBROKER_TVM_CREDENTIALS_CONFIG,
            'connect_timeout': 2.0,
        }),
        'production': frozendict({
            'host': 'logbroker.yandex.net',
            'port': 2135,
            'topic': 'passport/passport-takeout-tasks',
            'message_class': 'passport.backend.core.protobuf.takeout.takeout_pb2.TakeoutRequest',
            'source_id_prefix': 'passport-api-takeout-tasks',
            'credentials_config': LOGBROKER_TVM_CREDENTIALS_CONFIG,
            'connect_timeout': 0.5,
            'write_timeout': 1.0 if get_current_dc() == 'iva' else 0.5,
        }),
    },
}

_LOGBROKER_WRITER_TAKEOUT['localhost']['rc'] = _LOGBROKER_WRITER_TAKEOUT['localhost']['production'].copy()


LOGBROKER_WRITERS = {}
for writer_config, writer_name in (
    (_LOGBROKER_WRITER_LOGBROKER_TEST, 'logbroker_test'),
    (_LOGBROKER_WRITER_CHALLENGE_PUSHES, 'challenge_pushes'),
    (_LOGBROKER_WRITER_TAKEOUT, 'takeout_tasks'),
):
    config = writer_config.get(yenv.name, {}).get(yenv.type)
    if config:
        LOGBROKER_WRITERS[writer_name] = config
