# -*- coding: utf-8 -* #
from socket import gethostname

from frozendict import frozendict
import yenv


LOGBROKER_TVM_CREDENTIALS_CONFIG = {
    'credentials_type': 'tvm',
    'tvm_alias': 'logbroker_api',
}

LOGBROKER_WRITER_TAKEOUT = {
    'localhost': {
        'development': frozendict({
            'host': 'logbroker.yandex.net',
            'port': 2135,
            'topic': 'passport/passport-takeout-tasks-development',
            'message_class': 'passport.backend.core.protobuf.takeout.takeout_pb2.TakeoutRequest',
            'source_id_prefix': 'passport-takeout-takeout-tasks',
            'credentials_config': LOGBROKER_TVM_CREDENTIALS_CONFIG,
            'connect_timeout': 2.0,
            'write_timeout': 2.0,
        }),
        'testing': frozendict({
            'host': 'logbroker.yandex.net',
            'port': 2135,
            'topic': 'passport/passport-takeout-tasks-testing',
            'message_class': 'passport.backend.core.protobuf.takeout.takeout_pb2.TakeoutRequest',
            'source_id_prefix': 'passport-takeout-takeout-tasks',
            'credentials_config': LOGBROKER_TVM_CREDENTIALS_CONFIG,
            'connect_timeout': 2.0,
            'write_timeout': 2.0,
        }),
        'production': frozendict({
            'host': 'logbroker.yandex.net',
            'port': 2135,
            'topic': 'passport/passport-takeout-task',
            'message_class': 'passport.backend.core.protobuf.takeout.takeout_pb2.TakeoutRequest',
            'source_id_prefix': 'passport-takeout-takeout-tasks',
            'credentials_config': LOGBROKER_TVM_CREDENTIALS_CONFIG,
            'connect_timeout': 0.5,
            'write_timeout': 1.0,
        }),
    },
}

LOGBROKER_WRITER_TAKEOUT['localhost']['rc'] = LOGBROKER_WRITER_TAKEOUT['localhost']['production'].copy()

LOGBROKER_WRITERS = {}
for writer_config, writer_name in (
    (LOGBROKER_WRITER_TAKEOUT, 'takeout_tasks'),
):
    config = writer_config.get(yenv.name, {}).get(yenv.type)
    if config:
        LOGBROKER_WRITERS[writer_name] = config
