# -*- coding: utf-8 -*-
import os

import yenv


_current_user = os.environ.get('USER', os.environ.get('LOGNAME', 'root'))

if yenv.type == 'development' and _current_user not in ('root', 'www-data'):
    DEBUG = True
else:
    DEBUG = False

APP_LOGGER_NAME = 'api.requests.flask'

_LOG_PATH = '' if DEBUG else '/var/log/yandex/passport-api/'
_HISTORYDB_LOG_PATH = _LOG_PATH + 'historydb.' if DEBUG else _LOG_PATH + 'historydb/'
_STATBOX_LOG_PATH = _LOG_PATH + 'statbox.' if DEBUG else _LOG_PATH + 'statbox/'
_GRAPHITE_LOG_PATH = _LOG_PATH + 'graphite.' if DEBUG else _LOG_PATH + 'graphite/'
_PHONE_LOG_PATH = _LOG_PATH + 'phone.' if DEBUG else _LOG_PATH + 'phone/'

LOGGING = {
    'version': 1,
    'disable_existing_loggers': False,
    'filters': {
        'request_id': {
            '()': 'passport.backend.core.logging_utils.filters.RequestIdFilter',
        },
        'tskv_request_id': {
            '()': 'passport.backend.core.logging_utils.filters.TskvRequestIdFilter',
        },
    },
    'formatters': {
        'default': {
            'format': '%(process)d %(asctime)s %(name)-15s %(levelname)-10s %(message)s',
        },
        'request': {
            'format': '%(asctime)s %(request_id)s %(name)-15s %(levelname)-10s %(message)s',
        },
        'simple': {
            'format': "%(message)s"
        },
        'eav_fail': {
            'format': '%(asctime)s %(message)s',
        },
        'statbox': {
            'format': '%(message)s\trequest_id=%(request_id)s',
        },
        'graphite': {
            'format': '%(message)s\trequest_id=%(request_id)s',
        },
    },
    'root': {
        'handlers': ['passport.debug', 'passport.warning'],
        'level': 'DEBUG',
    },
    'handlers': {
        'console': {
            'class': 'logging.StreamHandler',
            'level': 'DEBUG',
            'formatter': 'request',
            'filters': ['request_id'],
        },
        'exception': {
            'class': 'passport.backend.core.logging_utils.handlers.ExceptionHandler',
            'level': 'ERROR',
            'log_path': _LOG_PATH,
            'filters': ['request_id'],
        },
        'historydb.auth': {
            'class': 'ylog.handlers.OSFileHandler',
            'filename': _HISTORYDB_LOG_PATH + 'auth.log',
            'formatter': 'simple',
        },
        'historydb.event': {
            'class': 'ylog.handlers.OSFileHandler',
            'filename': _HISTORYDB_LOG_PATH + 'event.log',
            'formatter': 'simple',
        },
        'historydb.tskv.event': {
            'class': 'ylog.handlers.OSFileHandler',
            'filename': _HISTORYDB_LOG_PATH + 'event_tskv.log',
            'formatter': 'simple',
        },
        'historydb.restore': {
            'class': 'ylog.handlers.OSFileHandler',
            'filename': _HISTORYDB_LOG_PATH + 'restore.log',
            'formatter': 'simple',
        },
        'historydb.auth_challenge': {
            'class': 'ylog.handlers.OSFileHandler',
            'filename': _HISTORYDB_LOG_PATH + 'auth_challenge.log',
            'formatter': 'simple',
        },
        'statbox': {
            'class': 'ylog.handlers.OSFileHandler',
            'filename': _STATBOX_LOG_PATH + 'statbox.log',
            'formatter': 'statbox',
            'filters': ['tskv_request_id'],
        },
        'passport.debug': {
            'class': 'ylog.handlers.OSFileHandler',
            'filename': _LOG_PATH + 'debug.log',
            'formatter': 'request',
            'filters': ['request_id'],
            'level': 'DEBUG',
        },
        'passport.warning': {
            'class': 'ylog.handlers.OSFileHandler',
            'filename': _LOG_PATH + 'warning.log',
            'formatter': 'request',
            'filters': ['request_id'],
            'level': 'WARNING',
        },
        # Временный handler для записи ошибок в eav
        'eav.fail': {
            'class': 'ylog.handlers.OSFileHandler',
            'filename': _LOG_PATH + 'eav_fail.log',
            'formatter': 'eav_fail',
        },
        'graphite_logger': {
            'class': 'ylog.handlers.OSFileHandler',
            'filename': _GRAPHITE_LOG_PATH + 'graphite.log',
            'formatter': 'graphite',
            'filters': ['tskv_request_id'],
        },
        'phone_logger': {
            'class': 'ylog.handlers.OSFileHandler',
            'filename': _PHONE_LOG_PATH + 'phone.log',
            'formatter': 'simple',
        },
        'cryptastat': {
            'class': 'ylog.handlers.OSFileHandler',
            'filename': _STATBOX_LOG_PATH + 'cryptastat.log',
            'formatter': 'simple',
        },
        'pharma': {
            'class': 'ylog.handlers.OSFileHandler',
            'filename': _STATBOX_LOG_PATH + 'pharma.log',
            'formatter': 'simple',
        },
        'antifraud': {
            'class': 'ylog.handlers.OSFileHandler',
            'filename': _STATBOX_LOG_PATH + 'antifraud.log',
            'formatter': 'simple',
        },
        'yasms_private': {
            'class': 'ylog.handlers.OSFileHandler',
            'filename': _STATBOX_LOG_PATH + 'yasms_private.log',
            'formatter': 'simple',
        },
        'access': {
            'class': 'ylog.handlers.OSFileHandler',
            'filename': _STATBOX_LOG_PATH + 'access.log',
            'formatter': 'simple',
        },
        'passport_family': {
            'class': 'ylog.handlers.OSFileHandler',
            'filename': _STATBOX_LOG_PATH + 'passport-family.log',
            'formatter': 'simple',
        },
        'passport_messages': {
            'class': 'ylog.handlers.OSFileHandler',
            'filename': _STATBOX_LOG_PATH + 'passport-messages.log',
            'formatter': 'simple',
        },
        'avatars': {
            'class': 'ylog.handlers.OSFileHandler',
            'filename': _STATBOX_LOG_PATH + 'avatars.log',
            'formatter': 'simple',
        },
        'social_binding': {
            'class': 'ylog.handlers.OSFileHandler',
            'filename': _STATBOX_LOG_PATH + 'social-bindings.log',
            'formatter': 'simple',
        },
        'credentials': {
            'class': 'ylog.handlers.OSFileHandler',
            'filename': _STATBOX_LOG_PATH + 'credentials.log',
            'formatter': 'simple',
        },
        'account_modification': {
            'class': 'ylog.handlers.OSFileHandler',
            'filename': _STATBOX_LOG_PATH + 'account_modification.log',
            'formatter': 'statbox',
            'filters': ['tskv_request_id'],
        },
        'account_modification_infosec': {
            'class': 'ylog.handlers.OSFileHandler',
            'filename': _STATBOX_LOG_PATH + 'account_modification_infosec.log',
            'formatter': 'statbox',
            'filters': ['tskv_request_id'],
        },
    },
    'loggers': {
        # Логгер для сторонних библиотек
        'requests': {
            'handlers': ['passport.warning'],
            'level': 'WARNING',
            'propagate': False,
        },
        'sqlalchemy.engine': {
            'handlers': [],
            'level': 'DEBUG',
            'propagate': False,
        },
        'urllib3.connectionpool': {
            'handlers': [],
            'level': 'DEBUG',
            'propagate': False,
        },
        'ydb.connection': {
            'handlers': [],
            'level': 'DEBUG',
            'propagate': False,
        },
        'ydb.resolver.DiscoveryEndpointsResolver': {
            'handlers': [],
            'level': 'DEBUG',
            'propagate': False,
        },
        'botocore': {
            'handlers': ['passport.warning'],
            'level': 'WARNING',
            'propagate': False,
        },

        # Наши, родные, логгеры
        'api.requests.error': {'handlers': ['exception']},
        'passport.frodo.error': {'handlers': ['exception']},
        'historydb.auth': {
            'handlers': ['historydb.auth'],
            'level': 'DEBUG',
            'propagate': False,
        },
        'historydb.event': {
            'handlers': ['historydb.event'],
            'level': 'DEBUG',
            'propagate': False,
        },
        'historydb.tskv.event': {
            'handlers': ['historydb.tskv.event'],
            'level': 'DEBUG',
            'propagate': False,
        },
        'historydb.restore': {
            'handlers': ['historydb.restore'],
            'level': 'DEBUG',
            'propagate': False,
        },
        'historydb.auth_challenge': {
            'handlers': ['historydb.auth_challenge'],
            'level': 'DEBUG',
            'propagate': False,
        },
        'statbox': {
            'handlers': ['statbox'],
            'level': 'DEBUG',
            'propagate': False,
        },
        'passport.initialize': {
            'handlers': ['passport.debug', 'passport.warning'],
            'level': 'INFO',
            'propagate': False,
        },
        'passport.useragent': {
            'handlers': ['passport.debug', 'passport.warning', 'exception'],
            'level': 'INFO',
            'propagate': False,
        },
        'passport.mailer.mailer': {
            'handlers': ['passport.debug', 'passport.warning', 'exception'],
            'level': 'ERROR',
            'propagate': False,
        },
        'passport.conf': {
            'handlers': ['passport.debug', 'passport.warning', 'exception'],
            'level': 'DEBUG',
            'propagate': False,
        },
        'eav.fail': {
            'handlers': ['eav.fail'],
            'level': 'DEBUG',
            'propagate': False,
        },
        'passport.graphite_logger': {
            'handlers': ['graphite_logger'],
            'level': 'DEBUG',
            'propagate': False,
        },
        'passport.phone_logger': {
            'handlers': ['phone_logger'],
            'level': 'DEBUG',
            'propagate': False,
        },
        'cryptastat': {
            'handlers': ['cryptastat'],
            'level': 'DEBUG',
            'propagate': False,
        },
        'pharma': {
            'handlers': ['pharma'],
            'level': 'DEBUG',
            'propagate': False,
        },
        'antifraud': {
            'handlers': ['antifraud'],
            'level': 'DEBUG',
            'propagate': False,
        },
        'yasms_private': {
            'handlers': ['yasms_private'],
            'level': 'DEBUG',
            'propagate': False,
        },
        'access': {
            'handlers': ['access'],
            'level': 'DEBUG',
            'propagate': False,
        },
        'passport_family': {
            'handlers': ['passport_family'],
            'level': 'DEBUG',
            'propagate': False,
        },
        'passport_messages': {
            'handlers': ['passport_messages'],
            'level': 'DEBUG',
            'propagate': False,
        },
        'avatars': {
            'handlers': ['avatars'],
            'level': 'DEBUG',
            'propagate': False,
        },
        'social_binding': {
            'handlers': ['social_binding'],
            'level': 'DEBUG',
            'propagate': False,
        },
        'credentials': {
            'handlers': ['credentials'],
            'level': 'DEBUG',
            'propagate': False,
        },

        # блок конфигурации для билдеров
        'passport.blackbox': {
            'handlers': ['passport.debug', 'passport.warning'],
            'level': 'DEBUG',
            'propagate': False,
        },
        'passport.captcha': {
            'handlers': ['passport.debug', 'passport.warning'],
            'level': 'DEBUG',
            'propagate': False,
        },
        'passport.yasms': {
            'handlers': ['passport.debug', 'passport.warning'],
            'level': 'DEBUG',
            'propagate': False,
        },
        'passport.email_validator': {
            'handlers': ['passport.debug', 'passport.warning'],
            'level': 'DEBUG',
            'propagate': False,
        },
        'passport.social_broker': {
            'handlers': ['passport.debug', 'passport.warning'],
            'level': 'DEBUG',
            'propagate': False,
        },
        'passport.suggest.login': {
            'handlers': ['passport.debug', 'passport.warning'],
            'level': 'DEBUG',
            'propagate': False,
        },
        'passport.suggest.name': {
            'handlers': ['passport.debug', 'passport.warning'],
            'level': 'DEBUG',
            'propagate': False,
        },
        'passport.oauth': {
            'handlers': ['passport.debug', 'passport.warning'],
            'level': 'DEBUG',
            'propagate': False,
        },
        'passport.historydb_api': {
            'handlers': ['passport.debug', 'passport.warning'],
            'level': 'DEBUG',
            'propagate': False,
        },
        'passport.social_api': {
            'handlers': ['passport.debug', 'passport.warning'],
            'level': 'DEBUG',
            'propagate': False,
        },
        'passport.mail_api': {
            'handlers': ['passport.debug', 'passport.warning'],
            'level': 'DEBUG',
            'propagate': False,
        },
        'passport.frodo': {
            'handlers': ['passport.debug', 'passport.warning'],
            'level': 'DEBUG',
            'propagate': False,
        },

        # блок для модулей, от которых не хотим получать DEBUG-сообщений
        'passport.tracks.RedisManager': {
            'handlers': ['passport.debug', 'passport.warning'],
            'level': 'WARNING',
            'propagate': False,
        },
        'passport.api.views.ping': {
            'handlers': ['passport.debug', 'passport.warning'],
            'level': 'WARNING',
            'propagate': False,
        },
        'passport.grants.optional': {
            'handlers': ['passport.debug', 'passport.warning'],
            'level': 'WARNING',
            'propagate': False,
        },
        'account_modification': {
            'handlers': ['account_modification'],
            'level': 'DEBUG',
            'propagate': False,
        },
        'account_modification_infosec': {
            'handlers': ['account_modification_infosec'],
            'level': 'DEBUG',
            'propagate': False,
        },
    },
}


if DEBUG:
    LOGGING['root']['handlers'].append('console')
    LOGGING['handlers']['exception'] = {
        'class': 'logging.FileHandler',
        'filename': 'exception.log',
        'formatter': 'default',
    }
