# -*- coding: utf-8 -*-
import yenv


_WMI_API_URLS = {
    'other': {
        'development': 'https://meta-test.mail.yandex.net/',
        'testing': 'https://meta-test.mail.yandex.net/',
        'rc': 'https://meta.mail.yandex.net/',
        'production': 'https://meta.mail.yandex.net/',
    },
}

_WMI_API_URLS['localhost'] = _WMI_API_URLS['other']

# максимальное время ожидания ответа WMI API
WMI_API_TIMEOUT = 2

# число попыток получить ответ от WMI API
WMI_API_RETRIES = 1


_RPOP_API_URLS = {
    'other': {
        'development': 'http://rpop-tst1j.mail.yandex.net:2048/',
        'testing': 'http://rpop-tst1j.mail.yandex.net:2048/',
        'rc': 'https://yarm.mail.yandex.net:3443/',
        'production': 'https://yarm.mail.yandex.net:3443/',
    },
}

_RPOP_API_URLS['localhost'] = _RPOP_API_URLS['other']

# максимальное время ожидания ответа RPOP API
RPOP_API_TIMEOUT = 2

# число попыток получить ответ от RPOP API
RPOP_API_RETRIES = 1


_FURITA_API_URLS = {
    'other': {
        'development': 'http://furita-test.mail.yandex.net/',
        'testing': 'http://furita-test.mail.yandex.net/',
        'rc': 'http://furita.mail.yandex.net/',
        'production': 'http://furita.mail.yandex.net/',
    },
}

_FURITA_API_URLS['localhost'] = _FURITA_API_URLS['other']

# максимальное время ожидания ответа Furita API
FURITA_API_TIMEOUT = 2

# число попыток получить ответ от Furita API
FURITA_API_RETRIES = 1

_HUSKY_API_URLS = {
    'development': 'http://husky-api.test.mail.yandex.net/',
    'testing': 'http://husky-api.test.mail.yandex.net/',
    'rc': 'http://husky-api.mail.yandex.net/',
    'production': 'http://husky-api.mail.yandex.net/',
}

HUSKY_API_TIMEOUT = 1
HUSKY_API_RETRIES = 2

_COLLIE_API_URLS = {
    'development': 'https://collie-test.mail.yandex.net/',
    'testing': 'https://collie-test.mail.yandex.net/',
    'rc': 'https://collie.mail.yandex.net/',
    'production': 'https://collie.mail.yandex.net/',
}
COLLIE_API_TIMEOUT = 2
COLLIE_API_RETRIES = 1

if yenv.name == 'localhost':
    WMI_API_URL = _WMI_API_URLS[yenv.name][yenv.type]
    RPOP_API_URL = _RPOP_API_URLS[yenv.name][yenv.type]
    FURITA_API_URL = _FURITA_API_URLS[yenv.name][yenv.type]
    HUSKY_API_URL = _HUSKY_API_URLS[yenv.type]
    COLLIE_API_URL = _COLLIE_API_URLS[yenv.type]
else:
    HUSKY_API_URL = FURITA_API_URL = RPOP_API_URL = WMI_API_URL = COLLIE_API_URL = ''

HUSKY_ENABLED = bool(HUSKY_API_URL)
