# -*- coding: utf-8 -*-
import yenv


# Используется для определения провайдера для мейлиша по доменной части алиаса.
# Соответствие провайдер <-> домены взято отсюда: https://st.yandex-team.ru/PASSP-17287#1502979628000
# Двухбуквенные коды провайдеров взяты отсюда: https://wiki.yandex-team.ru/social/providers/
_PROVIDER_TO_DOMAIN = {
    'gg': ['gmail.com'],
    'mr': ['mail.ru', 'bk.ru', 'list.ru', 'inbox.ru'],
    'yh': ['yahoo.com', 'ymail.com', 'rocketmail.com'],
    'ms': ['outlook.com', 'hotmail.com', 'live.com', 'msn.com'],
    # Рамблера нету в социализме. Было принято решение придумать двухбуквенный код ra.
    'ra': ['rambler.ru', 'lenta.ru', 'autorambler.ru', 'myrambler.ru', 'ro.ru', 'rambler.ua'],
}


MAILISH_DOMAIN_TO_PROVIDER = {}
for provider, domains in _PROVIDER_TO_DOMAIN.items():
    for domain in domains:
        MAILISH_DOMAIN_TO_PROVIDER[domain] = provider


ALLOW_NATIVE_MAILISH_EMAILS = yenv.type in ('development', 'testing')
