# -*- coding: utf-8 -*-

import yenv

from .secrets import MARKET_CONTENT_API_KEY


_MARKET_CONTENT_API_URLS = {
    'localhost': {
        'development': 'https://content-api.tst.vs.market.yandex.net',
        'testing': 'https://content-api.tst.vs.market.yandex.net',
        'rc': 'https://api.content.market.yandex.ru',
        'production': 'https://api.content.market.yandex.ru',
    },
}

if yenv.name == 'localhost':
    MARKET_CONTENT_API_URL = _MARKET_CONTENT_API_URLS[yenv.name][yenv.type]
else:
    MARKET_CONTENT_API_URL = ''

MARKET_CONTENT_API_TIMEOUT = 1
MARKET_CONTENT_API_RETRIES = 2
