# -*- coding: utf-8 -*-

import yenv


MDA2_SLAVE_DOMAINS = (
    'auto.ru',
    'avto.ru',
    'bringly.ru',
    'edadeal.ru',
    'edastage.ru',
    'k50.ru',
    'k50dev.ru',
    'k50wldev.ru',
    'kinopoisk.ru',
    'toloka.ai',
    'yandex.delivery',
    'yandexsport.ru',
    'yango.com',
    'yango.delivery',
    'dzen.ru',
    'ya.ru',
)


BASE_MDA2_SLAVE_DOMAIN_CONFIG = {
    # Отображение из имени куки на корневом домене в имя куки на подчинённом. Если кука отсуствует в списке или же
    # её имя на подчинённом домене пусто - кука на подчинённый домен не выставится.
    'cookies': {
        name: name
        for name in (
            'Session_id',
            'yandex_login',
        )
    },
}


# Настройки для подчинённых доменов (мёрджатся с BASE_MDA2_SLAVE_DOMAIN_CONFIG)
CUSTOM_MDA_DOMAIN_CONFIGS = {
    'auto.ru': {
        'cookies': {
            'i': 'i',
            'L': 'L',
        },
    },
    'avto.ru': {
        'cookies': {
            'i': 'i',
            'L': 'L',
        },
    },
    'kinopoisk.ru': {
        'cookies': {
            'Session_id': 'ya_sess_id',
            'yandexuid': 'yandexuid',
            'i': 'i',
        },
    },
    'ya.ru': {
        'cookies': {
            'my': 'my',
            'yandex_gid': 'yandex_gid',
            'yandexuid': 'yandexuid',
            'yp': 'yp',
        },
    },
}


# На 1%
MDA_EXPERIMENTAL_COOKIE_DENOMINATOR = 100
if yenv.type in {'development', 'testing', 'rc'}:
    MDA_EXPERIMENTAL_COOKIE_DENOMINATOR = 1
