# -*- coding: utf-8 -*-
from frozendict import frozendict
import yenv

from . import secrets
from .hosts import get_current_dc


# Настройки для OAuth-а
_OAUTH_URLS = {
    'other': {
        'development': 'https://oauth-test-internal.yandex.ru/',
        'testing': 'https://oauth-test-internal.yandex.ru/',
        'rc': 'https://oauth-rc-internal.yandex.ru/',
        'production': 'https://oauth-internal.yandex.ru/',
    },
    'stress': {
        'stress': 'https://oauth-load-internal.yandex.ru/',
    },
    'intranet': {
        'testing': 'https://oauth-test-internal.yandex-team.ru/',
        'rc': 'https://oauth-rc-internal.yandex-team.ru/',
        'production': 'https://oauth-internal.yandex-team.ru/',
    },
}

_OAUTH_URLS['intranet']['development'] = _OAUTH_URLS['intranet']['testing']

_OAUTH_URLS['localhost'] = _OAUTH_URLS['other']

# Потребитель "по умолчанию"
OAUTH_CONSUMER = 'passport'

OAUTH_URL = _OAUTH_URLS[yenv.name][yenv.type]

# Время ожидания ответа от OAuth и быстрого OAuth
OAUTH_TIMEOUT = 0.8
FAST_OAUTH_TIMEOUT = 0.3

# в тестинге Финки хотим таймаут побольше
current_dc = get_current_dc()
if current_dc and current_dc.startswith('f') and yenv.type == 'testing':
    OAUTH_TIMEOUT = 2.0

# Число попыток получить ответ от OAuth и быстрого OAuth
OAUTH_RETRIES = 2
FAST_OAUTH_RETRIES = 1

# Требуемый scope для обмена токена на трэк
OAUTH_TOKEN_TO_TRACK_SCOPE = 'passport:token-to-track'

# Время жизни кода, выдаваемого для АМ
AM_CODE_TTL = 600

# Приложения для OAuth-а
OAUTH_APPLICATION_TOKEN_TO_TRACK = frozendict({
    'client_id': secrets.OAUTH_APP_TOKEN_TO_TRACK_CLIENT_ID,
    'client_secret': secrets.OAUTH_APP_TOKEN_TO_TRACK_CLIENT_SECRET,
})

OAUTH_APPLICATION_NATIVE_SOCIAL_AUTH = frozendict({
    'client_id': secrets.OAUTH_APP_NATIVE_SOCIAL_AUTH_CLIENT_ID,
    'client_secret': secrets.OAUTH_APP_NATIVE_SOCIAL_AUTH_CLIENT_SECRET,
})

OAUTH_APPLICATIONS_FOR_MUSIC = frozendict({
    'mt': frozendict({
        'client_id': secrets.OAUTH_APP_MUSIC_MTS_REG_CLIENT_ID,
        'client_secret': secrets.OAUTH_APP_MUSIC_MTS_REG_CLIENT_SECRET,
    }),
    'vf': frozendict({
        'client_id': secrets.OAUTH_APP_MUSIC_VODAFONE_REG_CLIENT_ID,
        'client_secret': secrets.OAUTH_APP_MUSIC_VODAFONE_REG_CLIENT_SECRET,
    }),
    'mts-belarus': frozendict({
        'client_id': secrets.OAUTH_APP_MUSIC_MTS_BELARUS_REG_CLIENT_ID,
        'client_secret': secrets.OAUTH_APP_MUSIC_MTS_BELARUS_REG_CLIENT_SECRET,
    }),
    'geocell': frozendict({
        'client_id': secrets.OAUTH_APP_MUSIC_GEOCELL_REG_CLIENT_ID,
        'client_secret': secrets.OAUTH_APP_MUSIC_GEOCELL_REG_CLIENT_SECRET,
    }),
})

OAUTH_APPLICATION_AM_XTOKEN = frozendict({
    'client_id': secrets.OAUTH_APP_AM_XTOKEN_CLIENT_ID,
    'client_secret': secrets.OAUTH_APP_AM_XTOKEN_CLIENT_SECRET,
})

OAUTH_APPLICATION_YAMB = frozendict({
    'client_id': secrets.OAUTH_APP_YAMB_CLIENT_ID,
    'client_secret': secrets.OAUTH_APP_YAMB_CLIENT_SECRET,
})

OAUTH_KOLONKA_KOLONKISH_SCOPE = 'quasar:all'
OAUTH_KOLONKA_CODE_TTL = 600
OAUTH_APPLICATION_KOLONKA = frozendict({
    'client_id': secrets.OAUTH_APP_KOLONKA_CLIENT_ID,
    'client_secret': secrets.OAUTH_APP_KOLONKA_CLIENT_SECRET,
})
