# -*- coding: utf-8 -*-
import os

import yenv

from . import secrets
from .logs import DEBUG


OCTOPUS_URL = 'https://platform.telephony.yandex.net'

OCTOPUS_TIMEOUT = 1
OCTOPUS_RETRIES = 2

OCTOPUS_AUTH_TOKEN = secrets.OCTOPUS_AUTH_TOKEN

# Быстрое отключение возможности подтвердить телефон звонком.
# Если файл есть, то никаких звонков.
_PHONE_CONFIRMATION_DISABLING_CALLS_FILE = '/var/lib/yandex/passport-api/calls-off'
PHONE_CONFIRMATION_CALL_ENABLED = not os.path.exists(_PHONE_CONFIRMATION_DISABLING_CALLS_FILE)

PHONE_CONFIRMATION_CALL_COUNTRIES = (
    'ru',  # Россия
)
PHONE_CONFIRMATION_CALL_COUNTRIES_WITH_DENOMINATOR = {}
PHONE_CONFIRMATION_FLASH_CALL_COUNTRIES = (
    'ao',
)
PHONE_CONFIRMATION_FLASH_CALL_COUNTRIES_WITH_DENOMINATOR = {}

OCTOPUS_SUPPORTED_LANGUAGES = (
    'ru',
    'en',
)


PHONE_VALIDATION_MAX_CALLS_COUNT = 2
if DEBUG:   # pragma: no cover
    PHONE_VALIDATION_MAX_CALLS_COUNT = 20

PHONE_VALIDATION_MAX_CALLS_CHECKS_COUNT = 4
PHONE_VALIDATION_CODE_LENGTH = 6
# пытаемся проверить статус в течение минуты
PHONE_CONFIRMATION_CHECK_TIMEOUT = 60

KOLMOGOR_KEYSPACE_OCTOPUS_CALLS_COUNTERS = 'octopus_calls_counters'
KOLMOGOR_KEYSPACE_OCTOPUS_CALLS_FLAG = 'octopus_calls_shut_down_flag'

TEST_VALID_PHONE_NUMBER_PREFIX = '+70001'

PASSPORT_CALLING_NUMBER = '+78006009639'

# 2000 суффиксов отсюда PASSP-24312
# ещё 8000 отсюда PASSP-28743
FLASH_CALL_NUMBERS = []
FLASH_CALL_NUMBERS.extend([
    '+7901129' + suffix.strip() for suffix in
    '''
    0013 0014 0015 0016 0017 0018 0019 0021 0023 0024 0025 0026 0027 0028 0031 0032 0034 0035 0036 0037
    0038 0039 0041 0042 0043 0045 0046 0047 0048 0049 0051 0052 0053 0054 0056 0057 0058 0059 0061 0062
    0063 0064 0065 0067 0068 0069 0071 0072 0073 0074 0075 0076 0078 0079 0081 0082 0083 0084 0085 0086
    0087 0089 0091 0093 0094 0095 0096 0097 0098 0112 0113 0114 0115 0116 0117 0118 0119 0120 0122 0124
    0125 0126 0127 0128 0130 0132 0133 0134 0135 0136 0137 0138 0139 0140 0142 0143 0144 0145 0146 0147
    0148 0149 0150 0152 0153 0154 0155 0156 0157 0158 0159 0160 0162 0163 0164 0165 0166 0167 0168 0169
    0170 0172 0173 0174 0175 0176 0177 0178 0179 0180 0182 0183 0184 0185 0186 0187 0188 0189 0190 0192
    0193 0194 0195 0196 0197 0198 0199 0211 0213 0214 0215 0216 0217 0218 0219 0221 0223 0224 0225 0226
    0227 0228 0230 0231 0233 0235 0236 0237 0238 0239 0240 0241 0243 0244 0245 0246 0247 0248 0249 0250
    0251 0253 0254 0255 0256 0257 0258 0259 0260 0261 0263 0264 0265 0266 0267 0268 0269 0270 0271 0273
    0274 0275 0276 0277 0278 0279 0280 0281 0283 0284 0285 0286 0287 0288 0289 0291 0293 0294 0295 0296
    0297 0298 0299 0310 0311 0312 0314 0315 0316 0317 0318 0319 0320 0322 0324 0325 0326 0327 0328 0331
    0332 0334 0335 0336 0337 0338 0339 0340 0341 0342 0344 0346 0347 0348 0349 0350 0351 0352 0354 0355
    0356 0357 0358 0359 0360 0361 0362 0364 0365 0366 0367 0368 0369 0370 0371 0372 0374 0375 0376 0377
    0378 0379 0380 0381 0382 0384 0385 0386 0387 0388 0389 0390 0391 0392 0394 0395 0396 0397 0398 0399
    0410 0411 0412 0413 0415 0416 0417 0418 0419 0420 0421 0422 0423 0425 0426 0427 0428 0430 0431 0433
    0435 0436 0437 0438 0439 0441 0442 0443 0445 0446 0447 0448 0449 0450 0451 0452 0453 0455 0457 0458
    0459 0460 0461 0462 0463 0465 0466 0467 0468 0469 0470 0471 0472 0473 0475 0476 0477 0478 0479 0480
    0481 0482 0483 0485 0486 0487 0488 0489 0490 0491 0492 0493 0495 0496 0497 0498 0499 0510 0511 0512
    0513 0514 0516 0517 0518 0519 0520 0521 0522 0523 0524 0526 0527 0528 0530 0531 0532 0533 0534 0536
    0537 0538 0539 0540 0541 0542 0544 0546 0547 0548 0549 0551 0552 0553 0554 0556 0557 0558 0559 0560
    0561 0562 0563 0564 0566 0568 0569 0570 0571 0572 0573 0574 0576 0577 0578 0579 0580 0581 0582 0583
    0584 0586 0587 0588 0589 0590 0591 0592 0593 0594 0596 0597 0598 0599 0610 0611 0612 0613 0614 0615
    0617 0618 0619 0620 0621 0622 0623 0624 0625 0627 0628 0630 0631 0632 0633 0634 0635 0637 0638 0639
    0640 0641 0642 0643 0644 0645 0647 0648 0649 0650 0651 0652 0653 0655 0657 0658 0659 0661 0662 0663
    0664 0665 0667 0668 0669 0670 0671 0672 0673 0674 0675 0677 0679 0680 0681 0682 0683 0684 0685 0687
    0688 0689 0690 0691 0692 0693 0694 0695 0697 0698 0699 0710 0711 0712 0713 0714 0715 0716 0718 0719
    0720 0721 0722 0723 0724 0725 0726 0728 0730 0731 0732 0733 0734 0735 0736 0738 0739 0740 0741 0742
    0743 0744 0745 0746 0748 0749 0750 0751 0752 0753 0754 0755 0756 0758 0759 0760 0761 0762 0763 0764
    0766 0768 0769 0771 0772 0773 0774 0775 0776 0778 0779 0780 0781 0782 0783 0784 0785 0786 0788 0790
    0791 0792 0793 0794 0795 0796 0798 0799 0810 0811 0812 0813 0814 0815 0816 0817 0819 0820 0821 0822
    0823 0824 0825 0826 0827 0830 0831 0832 0833 0834 0835 0836 0837 0839 0840 0841 0842 0843 0844 0845
    0846 0847 0849 0850 0851 0853 0854 0855 0856 0857 0859 0860 0861 0862 0863 0864 0865 0866 0867 0869
    0870 0871 0872 0873 0874 0875 0877 0879 0881 0882 0883 0884 0885 0886 0887 0889 0890 0891 0892 0893
    0894 0895 0896 0897 0899 0910 0911 0912 0913 0914 0915 0916 0917 0918 0920 0922 0923 0924 0925 0926
    0927 0928 0930 0931 0932 0933 0934 0935 0936 0937 0938 0940 0941 0942 0943 0944 0945 0946 0947 0948
    0950 0951 0952 0953 0954 0955 0956 0957 0958 0960 0961 0962 0963 0964 0965 0966 0967 0968 0970 0971
    0972 0973 0974 0975 0976 0977 0978 0980 0981 0982 0983 0984 0985 0986 0988 1002 1003 1004 1005 1006
    1007 1008 1009 1021 1022 1023 1024 1025 1026 1027 1028 1031 1032 1033 1034 1035 1036 1037 1038 1039
    1041 1042 1043 1044 1045 1046 1047 1048 1049 1051 1052 1053 1054 1055 1056 1057 1058 1059 1061 1062
    1063 1064 1065 1066 1067 1068 1069 1071 1072 1073 1074 1075 1076 1077 1078 1079 1081 1082 1083 1084
    1085 1086 1087 1088 1089 1091 1092 1093 1094 1095 1096 1097 1098 1099 1102 1103 1104 1105 1106 1107
    1108 1109 1120 1124 1125 1126 1127 1128 1130 1132 1134 1135 1136 1137 1138 1139 1140 1142 1143 1145
    1146 1147 1148 1149 1150 1152 1153 1154 1156 1157 1158 1159 1160 1162 1163 1164 1165 1167 1168 1169
    1170 1172 1173 1174 1175 1176 1178 1179 1180 1182 1183 1184 1185 1186 1187 1189 1190 1193 1194 1195
    1196 1197 1198 1203 1204 1205 1206 1207 1208 1209 1220 1223 1224 1225 1226 1227 1228 1230 1231 1233
    1235 1236 1237 1238 1239 1240 1241 1243 1244 1245 1246 1247 1248 1249 1250 1251 1253 1254 1255 1256
    1257 1258 1259 1260 1261 1263 1264 1265 1266 1267 1268 1269 1270 1271 1273 1274 1275 1276 1277 1278
    1279 1280 1281 1283 1284 1285 1286 1287 1288 1289 1302 1304 1305 1306 1307 1308 1309 1320 1322 1324
    1325 1326 1327 1328 1330 1332 1334 1335 1336 1337 1338 1339 1340 1341 1342 1344 1346 1347 1348 1349
    1350 1351 1352 1354 1355 1356 1357 1358 1359 1360 1361 1362 1364 1365 1366 1367 1368 1369 1370 1371
    1372 1374 1375 1376 1377 1378 1379 1380 1381 1382 1384 1385 1386 1387 1388 1389 1390 1391 1392 1394
    1395 1396 1397 1398 1399 1402 1403 1405 1406 1407 1408 1409 1420 1421 1422 1423 1425 1426 1427 1428
    1430 1431 1433 1435 1436 1437 1438 1439 1440 1442 1443 1445 1446 1447 1448 1449 1450 1451 1452 1453
    1455 1457 1458 1459 1460 1461 1462 1463 1465 1466 1467 1468 1469 1470 1471 1472 1473 1475 1476 1477
    1478 1479 1480 1481 1482 1483 1485 1486 1487 1489 1490 1491 1492 1493 1495 1496 1497 1498 1499 1502
    1503 1504 1506 1507 1508 1509 1520 1521 1522 1523 1524 1526 1527 1528 1530 1531 1532 1533 1534 1536
    1537 1538 1539 1540 1541 1542 1544 1546 1547 1548 1549 1550 1552 1553 1554 1556 1557 1558 1559 1560
    1561 1562 1563 1564 1566 1568 1569 1570 1571 1572 1573 1574 1576 1577 1578 1579 1580 1581 1582 1583
    1584 1586 1587 1588 1589 1590 1591 1592 1593 1594 1596 1597 1598 1599 1602 1603 1604 1605 1607 1608
    1609 1620 1621 1622 1623 1624 1625 1627 1628 1630 1631 1632 1633 1634 1635 1637 1638 1639 1640 1641
    1642 1643 1644 1645 1647 1648 1649 1650 1651 1652 1653 1655 1657 1658 1659 1660 1662 1663 1664 1665
    1667 1668 1669 1670 1671 1672 1673 1674 1675 1677 1679 1680 1681 1682 1683 1684 1685 1687 1688 1689
    1690 1691 1692 1693 1694 1695 1697 1698 1699 1702 1703 1704 1705 1706 1708 1709 1720 1721 1722 1723
    1724 1725 1726 1728 1730 1731 1732 1733 1734 1735 1736 1738 1739 1740 1741 1742 1743 1744 1745 1746
    1748 1749 1750 1751 1752 1753 1754 1755 1756 1758 1759 1760 1761 1762 1763 1764 1766 1768 1769 1770
    1772 1773 1774 1775 1776 1778 1779 1780 1781 1782 1783 1784 1785 1786 1788 1790 1791 1792 1793 1794
    1795 1796 1798 1799 1802 1803 1804 1805 1806 1807 1809 1820 1821 1822 1823 1824 1825 1826 1827 1830
    1831 1832 1833 1834 1835 1836 1837 1839 1840 1841 1842 1843 1844 1845 1846 1847 1849 1850 1851 1852
    1853 1854 1855 1856 1857 1859 1860 1861 1862 1863 1864 1865 1866 1867 1869 1870 1871 1872 1873 1874
    1875 1877 1879 1880 1882 1883 1884 1885 1886 1887 1889 1890 1891 1892 1893 1894 1895 1896 1897 1899
    1902 1903 1904 1905 1906 1907 1908 1920 1922 1923 1924 1925 1926 1927 1928 1930 1931 1932 1933 1934
    1935 1936 1937 1938 1940 1941 1942 1943 1944 1945 1946 1947 1948 1950 1951 1952 1953 1954 1955 1956
    1957 1958 1960 1961 1962 1963 1964 1965 1966 1967 1968 1970 1971 1972 1973 1974 1975 1976 1977 1978
    1980 1981 1982 1983 1984 1985 1986 1988 2003 2004 2005 2006 2007 2008 2009 2011 2013 2014 2015 2016
    2017 2018 2019 2031 2032 2033 2034 2035 2036 2037 2038 2039 2041 2042 2043 2044 2045 2046 2047 2048
    2049 2051 2052 2053 2054 2055 2056 2057 2058 2059 2061 2062 2063 2064 2065 2066 2067 2068 2069 2071
    2072 2073 2074 2075 2076 2077 2078 2079 2081 2082 2083 2084 2085 2086 2087 2088 2089 2091 2092 2093
    2094 2095 2096 2097 2098 2099 2102 2103 2104 2105 2106 2107 2108 2109 2110 2113 2114 2115 2116 2117
    2118 2119 2130 2132 2133 2134 2135 2136 2137 2138 2139 2140 2142 2143 2144 2145 2146 2147 2148 2149
    2150 2152 2153 2154 2155 2156 2157 2158 2159 2160 2162 2163 2164 2165 2166 2167 2168 2169 2170 2172
    2173 2174 2175 2176 2177 2178 2179 2180 2182 2183 2184 2185 2186 2187 2188 2189 2190 2192 2193 2194
    2195 2196 2197 2198 2199 2203 2204 2205 2206 2207 2208 2209 2213 2214 2215 2216 2217 2218 2219 2230
    2231 2235 2236 2237 2238 2239 2240 2241 2243 2245 2246 2247 2248 2249 2250 2251 2253 2254 2256 2257
    2258 2259 2260 2261 2263 2264 2265 2267 2268 2269 2270 2271 2273 2274 2275 2276 2278 2279 2280 2281
    2283 2284 2285 2286 2287 2289 2290 2291 2293 2294 2295 2296 2297 2298 2302 2304 2305 2306 2307 2308
    2309 2310 2311 2312 2314 2315 2316 2317 2318 2319 2330 2331 2334 2335 2336 2337 2338 2339 2340 2341
    2342 2344 2346 2347 2348 2349 2350 2351 2352 2354 2355 2356 2357 2358 2359 2360 2361 2362 2364 2365
    2366 2367 2368 2369 2370 2371 2372 2374 2375 2376 2377 2378 2379 2380 2381 2382 2384 2385 2386 2387
    2388 2389 2390 2391 2392 2394 2395 2396 2397 2398 2399 2402 2403 2405 2406 2407 2408 2409 2410 2411
    2412 2413 2415 2416 2417 2418 2419 2430 2431 2433 2435 2436 2437 2438 2439 2440 2441 2443 2445 2446
    2447 2448 2449 2450 2451 2452 2453 2455 2457 2458 2459 2460 2461 2462 2463 2465 2466 2467 2468 2469
    2470 2471 2472 2473 2475 2476 2477 2478 2479 2480 2481 2482 2483 2485 2486 2487 2488 2489 2490 2491
    2492 2493 2495 2496 2497 2498 2499 2502 2503 2504 2506 2507 2508 2509 2510 2511 2512 2513 2514 2516
    2517 2518 2519 2530 2531 2532 2533 2534 2536 2537 2538 2539 2540 2541 2542 2544 2546 2547 2548 2549
    2550 2551 2553 2554 2556 2557 2558 2559 2560 2561 2562 2563 2564 2566 2568 2569 2570 2571 2572 2573
    2574 2576 2577 2578 2579 2581 2582 2583 2584 2586 2587 2588 2589 2590 2591 2592 2593 2594 2596 2597
    2598 2599 2602 2603 2604 2605 2607 2608 2609 2610 2611 2612 2613 2614 2615 2617 2618 2619 2630 2631
    2632 2633 2634 2635 2637 2638 2639 2640 2641 2642 2643 2644 2645 2647 2648 2649 2650 2651 2652 2653
    2655 2657 2658 2659 2660 2661 2663 2664 2665 2667 2668 2669 2670 2671 2672 2673 2674 2675 2677 2679
    '''.split() if suffix
])
FLASH_CALL_NUMBERS.extend([
    '+7901808' + suffix.strip() for suffix in
    '''
    5980 5981 5982 5983 5984 5986 5990 5991 5992 5993 5994 5996 5997 5998 6002 6004 6005 6007 6009 6011
    6013 6014 6015 6017 6018 6019 6021 6022 6023 6025 6026 6027 6028 6029 6031 6033 6034 6035 6036 6037
    6038 6039 6041 6042 6043 6044 6045 6046 6047 6049 6051 6052 6053 6054 6055 6056 6057 6058 6059 6071
    6072 6073 6074 6075 6076 6078 6079 6081 6082 6084 6085 6087 6089 6091 6092 6093 6094 6095 6096 6097
    6098 6099 6102 6103 6104 6105 6106 6107 6109 6110 6112 6113 6114 6115 6117 6118 6119 6120 6122 6124
    6125 6126 6127 6128 6129 6130 6132 6133 6134 6135 6136 6137 6138 6139 6140 6142 6143 6144 6145 6146
    6147 6148 6149 6150 6152 6153 6154 6155 6156 6157 6158 6159 6170 6172 6173 6174 6175 6176 6177 6178
    6179 6180 6182 6183 6184 6185 6186 6187 6189 6190 6192 6193 6194 6195 6196 6197 6198 6199 6203 6204
    6205 6206 6207 6209 6211 6213 6214 6215 6216 6217 6218 6219 6220 6221 6223 6224 6225 6227 6228 6229
    6230 6231 6233 6235 6236 6237 6238 6239 6240 6241 6243 6244 6245 6246 6247 6248 6249 6250 6251 6253
    6254 6255 6256 6257 6258 6259 6270 6271 6273 6274 6275 6276 6277 6278 6279 6280 6281 6283 6284 6285
    6286 6287 6289 6290 6291 6293 6294 6295 6296 6297 6298 6299 6302 6304 6305 6306 6307 6309 6310 6311
    6312 6314 6315 6316 6317 6318 6319 6320 6322 6324 6325 6326 6327 6328 6329 6330 6331 6332 6334 6335
    6337 6338 6339 6340 6341 6342 6344 6346 6347 6348 6349 6350 6351 6352 6354 6355 6356 6357 6358 6359
    6370 6371 6372 6374 6375 6376 6377 6378 6379 6380 6381 6382 6384 6385 6386 6387 6389 6390 6391 6392
    6394 6395 6396 6397 6398 6399 6402 6403 6405 6406 6407 6409 6410 6411 6412 6413 6415 6416 6417 6418
    6419 6420 6421 6422 6423 6425 6426 6427 6428 6429 6430 6431 6433 6435 6436 6437 6438 6439 6440 6441
    6442 6443 6445 6447 6448 6449 6450 6451 6452 6453 6455 6457 6458 6459 6470 6471 6472 6473 6475 6476
    6477 6478 6479 6480 6481 6482 6483 6485 6486 6487 6489 6490 6491 6492 6493 6495 6496 6497 6498 6499
    6502 6503 6504 6506 6507 6509 6510 6511 6512 6513 6514 6516 6517 6518 6519 6520 6521 6522 6523 6524
    6526 6527 6528 6529 6530 6531 6532 6533 6534 6536 6537 6538 6539 6540 6541 6542 6544 6546 6547 6548
    6549 6550 6551 6552 6553 6554 6557 6558 6559 6570 6571 6572 6573 6574 6576 6577 6578 6579 6580 6581
    6582 6583 6584 6586 6587 6589 6590 6591 6592 6593 6594 6596 6597 6598 6599 6602 6603 6604 6605 6607
    6609 6610 6612 6613 6614 6615 6617 6618 6619 6620 6621 6623 6624 6625 6627 6628 6629 6630 6631 6632
    6634 6635 6637 6638 6639 6640 6641 6642 6643 6645 6647 6648 6649 6650 6651 6652 6653 6657 6658 6659
    6670 6671 6672 6673 6674 6675 6679 6681 6682 6683 6684 6685 6687 6689 6690 6691 6692 6693 6694 6695
    6697 6698 6702 6703 6704 6705 6706 6709 6710 6711 6712 6713 6714 6715 6716 6718 6719 6720 6721 6722
    6723 6724 6725 6726 6728 6729 6730 6731 6732 6733 6734 6735 6736 6738 6739 6740 6741 6742 6743 6744
    6745 6746 6748 6749 6750 6751 6752 6753 6754 6755 6756 6758 6759 6770 6771 6772 6773 6774 6775 6778
    6779 6780 6781 6782 6783 6784 6785 6786 6790 6791 6792 6793 6794 6795 6796 6798 6799 6802 6803 6804
    6805 6806 6807 6809 6810 6811 6812 6813 6814 6815 6816 6817 6819 6820 6821 6822 6823 6824 6825 6826
    6827 6829 6830 6831 6832 6833 6834 6835 6836 6837 6839 6840 6841 6842 6843 6844 6845 6846 6847 6849
    6850 6851 6852 6853 6854 6855 6856 6857 6859 6870 6871 6872 6873 6874 6875 6877 6879 6890 6891 6892
    6893 6894 6895 6896 6897 6899 6902 6903 6904 6905 6906 6907 6910 6911 6912 6913 6914 6915 6916 6917
    6918 6920 6921 6922 6923 6924 6925 6926 6927 6928 6930 6931 6932 6933 6934 6935 6936 6937 6938 6940
    6941 6942 6943 6944 6945 6946 6947 6948 6950 6951 6952 6953 6954 6955 6956 6957 6958 6970 6971 6972
    6973 6974 6975 6976 6977 6978 6980 6981 6982 6983 6984 6985 6986 6990 6991 6992 6993 6994 6995 6997
    6998 7002 7003 7004 7005 7006 7009 7011 7013 7014 7015 7016 7017 7018 7019 7021 7022 7023 7024 7025
    7026 7027 7028 7029 7031 7032 7033 7034 7035 7036 7037 7038 7039 7041 7042 7043 7044 7045 7046 7047
    7048 7049 7051 7052 7053 7054 7055 7056 7057 7058 7059 7061 7062 7063 7064 7065 7066 7067 7068 7069
    7081 7082 7083 7084 7085 7086 7089 7091 7092 7093 7094 7095 7096 7097 7098 7099 7102 7103 7104 7105
    7106 7107 7109 7110 7112 7113 7114 7115 7116 7118 7119 7120 7122 7124 7125 7126 7127 7128 7129 7130
    7132 7133 7134 7135 7136 7137 7138 7139 7140 7142 7143 7144 7145 7146 7147 7148 7149 7150 7152 7153
    7154 7155 7156 7157 7158 7159 7160 7162 7163 7164 7165 7166 7167 7168 7169 7180 7182 7183 7184 7185
    7186 7187 7189 7190 7192 7193 7194 7195 7196 7197 7198 7199 7203 7204 7205 7206 7207 7209 7211 7213
    7214 7215 7216 7217 7218 7219 7220 7221 7223 7224 7225 7226 7228 7229 7230 7231 7233 7235 7236 7237
    7238 7239 7240 7241 7243 7244 7245 7246 7247 7248 7249 7250 7251 7253 7254 7255 7256 7257 7258 7259
    7260 7261 7263 7264 7265 7266 7267 7268 7269 7280 7281 7283 7284 7285 7286 7287 7289 7290 7291 7293
    7294 7295 7296 7297 7298 7299 7302 7304 7305 7306 7307 7309 7310 7311 7312 7314 7315 7316 7317 7318
    7319 7320 7322 7324 7325 7326 7327 7328 7329 7330 7331 7332 7334 7335 7336 7338 7339 7340 7341 7342
    7344 7346 7347 7348 7349 7350 7351 7352 7354 7355 7356 7357 7358 7359 7360 7361 7362 7364 7365 7366
    7367 7368 7369 7380 7381 7382 7384 7385 7386 7387 7389 7390 7391 7392 7394 7395 7396 7397 7398 7399
    7402 7403 7405 7406 7407 7409 7410 7411 7412 7413 7415 7416 7417 7418 7419 7420 7421 7422 7423 7425
    7426 7427 7428 7429 7430 7431 7433 7435 7436 7437 7438 7439 7440 7441 7442 7443 7445 7446 7448 7449
    7450 7451 7452 7453 7455 7457 7458 7459 7460 7461 7462 7463 7465 7466 7467 7468 7469 7480 7481 7482
    7483 7485 7486 7487 7489 7490 7491 7492 7493 7495 7496 7497 7498 7499 7502 7503 7504 7506 7507 7509
    7510 7511 7512 7513 7514 7516 7517 7518 7519 7520 7521 7522 7523 7524 7526 7527 7528 7529 7530 7531
    7532 7533 7534 7536 7537 7538 7539 7540 7541 7542 7544 7546 7547 7548 7549 7550 7551 7552 7553 7554
    7556 7558 7559 7560 7561 7562 7563 7564 7566 7568 7569 7580 7581 7582 7583 7584 7586 7587 7589 7590
    7591 7592 7593 7594 7596 7597 7598 7599 7602 7603 7604 7605 7607 7609 7610 7611 7612 7613 7614 7615
    7617 7618 7619 7620 7621 7622 7623 7624 7625 7627 7628 7629 7630 7631 7632 7633 7634 7635 7637 7638
    7639 7640 7641 7642 7643 7644 7645 7647 7648 7649 7650 7651 7652 7653 7655 7657 7658 7659 7660 7661
    7662 7663 7664 7665 7668 7669 7680 7681 7682 7683 7684 7685 7687 7689 7690 7691 7692 7693 7694 7695
    7697 7698 7699 7702 7703 7704 7705 7706 7709 7710 7712 7713 7714 7715 7716 7718 7719 7720 7721 7723
    7724 7725 7726 7728 7729 7730 7731 7732 7734 7735 7736 7738 7739 7740 7741 7742 7743 7745 7746 7748
    7749 7750 7751 7752 7753 7754 7756 7758 7759 7760 7761 7762 7763 7764 7768 7769 7781 7782 7783 7784
    7785 7786 7790 7791 7792 7793 7794 7795 7796 7798 7802 7803 7804 7805 7806 7807 7809 7810 7811 7812
    7813 7814 7815 7816 7817 7819 7820 7821 7822 7823 7824 7825 7826 7827 7829 7830 7831 7832 7833 7834
    7835 7836 7837 7839 7840 7841 7842 7843 7844 7845 7846 7847 7849 7850 7851 7852 7853 7854 7855 7856
    7857 7859 7860 7861 7862 7863 7864 7865 7866 7867 7869 7890 7891 7892 7893 7894 7895 7896 7897 7899
    7902 7903 7904 7905 7906 7907 7910 7911 7912 7913 7914 7915 7916 7917 7918 7920 7921 7922 7923 7924
    7925 7926 7927 7928 7930 7931 7932 7933 7934 7935 7936 7937 7938 7940 7941 7942 7943 7944 7945 7946
    7947 7948 7950 7951 7952 7953 7954 7955 7956 7957 7958 7960 7961 7962 7963 7964 7965 7966 7967 7968
    7980 7981 7982 7983 7984 7985 7986 7990 7991 7992 7993 7994 7995 7996 7998 8002 8003 8004 8005 8006
    8007 8009 8011 8013 8014 8015 8016 8017 8019 8021 8022 8023 8024 8025 8026 8027 8029 8031 8032 8033
    8034 8035 8036 8037 8039 8041 8042 8043 8044 8045 8046 8047 8049 8051 8052 8053 8054 8055 8056 8057
    8059 8061 8062 8063 8064 8065 8066 8067 8069 8071 8072 8073 8074 8075 8076 8077 8079 8091 8092 8093
    8094 8095 8096 8097 8099 8102 8103 8104 8105 8106 8107 8109 8110 8112 8113 8114 8115 8116 8117 8119
    8120 8122 8124 8125 8126 8127 8129 8130 8132 8133 8134 8135 8136 8137 8139 8140 8142 8143 8144 8145
    8146 8147 8149 8150 8152 8153 8154 8155 8156 8157 8159 8160 8162 8163 8164 8165 8166 8167 8169 8170
    8172 8173 8174 8175 8176 8177 8179 8190 8192 8193 8194 8195 8196 8197 8199 8203 8204 8205 8206 8207
    8209 8211 8213 8214 8215 8216 8217 8219 8220 8221 8223 8224 8225 8226 8227 8229 8230 8231 8233 8235
    8236 8237 8239 8240 8241 8243 8244 8245 8246 8247 8249 8250 8251 8253 8254 8255 8256 8257 8259 8260
    8261 8263 8264 8265 8266 8267 8269 8270 8271 8273 8274 8275 8276 8277 8279 8290 8291 8293 8294 8295
    8296 8297 8299 8302 8304 8305 8306 8307 8309 8310 8311 8312 8314 8315 8316 8317 8319 8320 8322 8324
    8325 8326 8327 8329 8330 8331 8332 8334 8335 8336 8337 8339 8340 8341 8342 8344 8346 8347 8349 8350
    8351 8352 8354 8355 8356 8357 8359 8360 8361 8362 8364 8365 8366 8367 8369 8370 8371 8372 8374 8375
    8376 8377 8379 8390 8391 8392 8394 8395 8396 8397 8399 8402 8403 8405 8406 8407 8409 8410 8411 8412
    8413 8415 8416 8417 8419 8420 8421 8422 8423 8425 8426 8427 8429 8430 8431 8433 8435 8436 8437 8439
    8440 8441 8442 8443 8445 8446 8447 8449 8450 8451 8452 8453 8455 8457 8459 8460 8461 8462 8463 8465
    8466 8467 8469 8470 8471 8472 8473 8475 8476 8477 8479 8490 8491 8492 8493 8495 8496 8497 8499 8502
    8503 8504 8506 8507 8509 8510 8511 8512 8513 8514 8516 8517 8519 8520 8521 8522 8523 8524 8526 8527
    8529 8530 8531 8532 8533 8534 8536 8537 8539 8540 8541 8542 8544 8546 8547 8549 8550 8551 8552 8553
    8554 8556 8557 8559 8560 8561 8562 8563 8564 8566 8569 8570 8571 8572 8573 8574 8576 8577 8579 8590
    8591 8592 8593 8594 8596 8597 8599 8602 8603 8604 8605 8607 8609 8610 8611 8612 8613 8614 8615 8617
    8619 8620 8621 8622 8623 8624 8625 8627 8629 8630 8631 8632 8633 8634 8635 8637 8639 8640 8641 8642
    8643 8644 8645 8647 8649 8650 8651 8652 8653 8655 8657 8659 8660 8661 8662 8663 8664 8665 8667 8669
    8670 8671 8672 8673 8674 8675 8677 8679 8690 8691 8692 8693 8694 8695 8697 8699 8702 8703 8704 8705
    8706 8709 8710 8711 8712 8713 8714 8715 8716 8719 8720 8721 8722 8723 8724 8725 8726 8729 8730 8731
    8732 8733 8734 8735 8736 8739 8740 8741 8742 8743 8744 8745 8746 8749 8750 8751 8752 8753 8754 8755
    8756 8759 8760 8761 8762 8763 8764 8766 8769 8770 8771 8772 8773 8774 8775 8776 8779 8790 8791 8792
    8793 8794 8795 8796 8799 8902 8903 8904 8905 8906 8907 8910 8911 8912 8913 8914 8915 8916 8917 8920
    8921 8922 8923 8924 8925 8926 8927 8930 8931 8932 8933 8934 8935 8936 8937 8940 8941 8942 8943 8944
    8945 8946 8947 8950 8951 8952 8953 8954 8955 8956 8957 8960 8961 8962 8963 8964 8965 8966 8967 8970
    8971 8972 8973 8974 8975 8976 8977 8990 8991 8992 8993 8994 8995 8996 8997 9002 9003 9004 9005 9006
    9007 9011 9013 9014 9015 9016 9017 9018 9019 9021 9022 9023 9024 9025 9026 9027 9028 9029 9031 9032
    9033 9034 9035 9036 9037 9038 9039 9041 9042 9043 9044 9045 9046 9047 9048 9049 9051 9052 9053 9054
    9055 9056 9057 9058 9059 9061 9062 9063 9064 9065 9066 9067 9068 9069 9071 9072 9073 9074 9075 9076
    9077 9078 9079 9081 9082 9083 9084 9085 9086 9087 9102 9103 9104 9105 9106 9107 9109 9110 9112 9113
    9114 9115 9116 9117 9118 9120 9122 9124 9125 9126 9127 9128 9129 9130 9132 9133 9134 9135 9136 9137
    9138 9139 9140 9142 9143 9144 9145 9146 9147 9148 9149 9150 9152 9153 9154 9155 9156 9157 9158 9159
    9160 9162 9163 9164 9165 9166 9167 9168 9169 9170 9172 9173 9174 9175 9176 9177 9178 9179 9180 9182
    9183 9184 9185 9186 9187 9189 9203 9204 9205 9206 9207 9209 9211 9213 9214 9215 9216 9217 9218 9219
    9220 9221 9223 9224 9225 9226 9227 9228 9230 9231 9233 9235 9236 9237 9238 9239 9240 9241 9243 9244
    9245 9246 9247 9248 9249 9250 9251 9253 9254 9255 9256 9257 9258 9259 9260 9261 9263 9264 9265 9266
    9267 9268 9269 9270 9271 9273 9274 9275 9276 9277 9278 9279 9280 9281 9283 9284 9285 9286 9287 9289
    9302 9304 9305 9306 9307 9309 9310 9311 9312 9314 9315 9316 9317 9318 9319 9320 9322 9324 9325 9326
    9327 9328 9329 9330 9331 9332 9334 9335 9336 9337 9338 9340 9341 9342 9344 9346 9347 9348 9349 9350
    9351 9352 9354 9355 9356 9357 9358 9359 9360 9361 9362 9364 9365 9366 9367 9368 9369 9370 9371 9372
    9374 9375 9376 9377 9378 9379 9380 9381 9382 9384 9385 9386 9387 9389 9402 9403 9405 9406 9407 9409
    9410 9411 9412 9413 9415 9416 9417 9418 9419 9420 9421 9422 9423 9425 9426 9427 9428 9429 9430 9431
    9433 9435 9436 9437 9438 9439 9440 9441 9442 9443 9445 9446 9447 9448 9450 9451 9452 9453 9455 9457
    9458 9459 9460 9461 9462 9463 9465 9466 9467 9468 9469 9470 9471 9472 9473 9475 9476 9477 9478 9479
    9480 9481 9482 9483 9485 9486 9487 9489 9502 9503 9504 9506 9507 9509 9510 9511 9512 9513 9514 9516
    9517 9518 9519 9520 9521 9522 9523 9524 9526 9527 9528 9529 9530 9531 9532 9533 9534 9536 9537 9538
    9539 9540 9541 9542 9544 9546 9547 9548 9549 9550 9551 9552 9553 9554 9556 9557 9558 9560 9561 9562
    9563 9564 9566 9568 9569 9570 9571 9572 9573 9574 9576 9577 9578 9579 9580 9581 9582 9583 9584 9586
    9587 9589 9602 9603 9604 9605 9607 9609 9610 9611 9612 9613 9614 9615 9617 9618 9619 9620 9621 9622
    9623 9624 9625 9627 9628 9629 9630 9631 9632 9633 9634 9635 9637 9638 9639 9640 9641 9642 9643 9644
    9645 9647 9648 9649 9650 9651 9652 9653 9655 9657 9658 9659 9660 9661 9662 9663 9664 9665 9667 9668
    9670 9671 9672 9673 9674 9675 9677 9679 9680 9681 9682 9683 9684 9685 9687 9689 9702 9703 9704 9705
    9706 9709 9710 9711 9712 9713 9714 9715 9716 9718 9719 9720 9721 9722 9723 9724 9725 9726 9728 9729
    9730 9731 9732 9733 9734 9735 9736 9738 9739 9740 9741 9742 9743 9744 9745 9746 9748 9749 9750 9751
    9752 9753 9754 9755 9756 9758 9759 9760 9761 9762 9763 9764 9766 9768 9769 9770 9771 9772 9773 9774
    9775 9776 9778 9780 9781 9782 9783 9784 9785 9786 9802 9803 9804 9805 9806 9807 9809 9810 9811 9812
    9813 9814 9815 9816 9817 9819 9820 9821 9822 9823 9824 9825 9826 9827 9829 9830 9831 9832 9833 9834
    9835 9836 9837 9839 9840 9841 9842 9843 9844 9845 9846 9847 9849 9850 9851 9852 9853 9854 9855 9856
    9857 9859 9860 9861 9862 9863 9864 9865 9866 9867 9869 9870 9871 9872 9873 9874 9875 9877 9879 9902
    9903 9904 9905 9906 9907 9910 9912 9913 9914 9915 9916 9917 9918 9920 9921 9923 9924 9925 9926 9927
    9928 9930 9931 9932 9934 9935 9936 9937 9938 9940 9941 9942 9943 9945 9946 9947 9948 9950 9951 9952
    9953 9954 9956 9957 9958 9960 9961 9962 9963 9964 9965 9967 9968 9970 9971 9972 9973 9974 9975 9976
    9978 9981 9982 9983 9984 9985 9986 5978
    '''.split() if suffix
])
FLASH_CALL_NUMBERS.extend([
    '+7901899' + suffix.strip() for suffix in
    '''
    0013 0014 0015 0016 0017 0018 0019 0021 0023 0024 0025 0026 0027 0028 0029 0031 0032 0034 0035 0036
    0037 0038 0039 0041 0042 0043 0045 0046 0047 0048 0049 0051 0052 0053 0054 0056 0057 0058 0059 0061
    0062 0063 0064 0065 0067 0068 0069 0071 0072 0073 0074 0075 0076 0078 0079 0081 0082 0083 0084 0085
    0086 0087 0089 0091 0092 0093 0094 0095 0096 0097 0098 0112 0113 0114 0115 0116 0117 0118 0119 0120
    0124 0125 0126 0127 0128 0129 0130 0132 0134 0135 0136 0137 0138 0139 0140 0142 0143 0145 0146 0147
    0148 0149 0150 0152 0153 0154 0156 0157 0158 0159 0160 0162 0163 0164 0165 0167 0168 0169 0170 0172
    0173 0174 0175 0176 0178 0179 0180 0182 0183 0184 0185 0186 0187 0189 0190 0192 0193 0194 0195 0196
    0197 0198 0213 0214 0215 0216 0217 0218 0219 0221 0223 0224 0225 0226 0227 0228 0229 0230 0231 0235
    0236 0237 0238 0239 0240 0241 0243 0245 0246 0247 0248 0249 0250 0251 0253 0254 0256 0257 0258 0259
    0260 0261 0263 0264 0265 0267 0268 0269 0270 0271 0273 0274 0275 0276 0278 0279 0280 0281 0283 0284
    0285 0286 0287 0289 0290 0291 0293 0294 0295 0296 0297 0298 0310 0312 0314 0315 0316 0317 0318 0319
    0320 0324 0325 0326 0327 0328 0329 0331 0332 0334 0335 0336 0337 0338 0339 0340 0341 0342 0346 0347
    0348 0349 0350 0351 0352 0354 0356 0357 0358 0359 0360 0361 0362 0364 0365 0367 0368 0369 0370 0371
    0372 0374 0375 0376 0378 0379 0380 0381 0382 0384 0385 0386 0387 0389 0390 0391 0392 0394 0395 0396
    0397 0398 0410 0412 0413 0415 0416 0417 0418 0419 0420 0421 0423 0425 0426 0427 0428 0429 0430 0431
    0435 0436 0437 0438 0439 0441 0442 0443 0445 0446 0447 0448 0449 0450 0451 0452 0453 0457 0458 0459
    0460 0461 0462 0463 0465 0467 0468 0469 0470 0471 0472 0473 0475 0476 0478 0479 0480 0481 0482 0483
    0485 0486 0487 0489 0490 0491 0492 0493 0495 0496 0497 0498 0510 0512 0513 0514 0516 0517 0518 0519
    0520 0521 0523 0524 0526 0527 0528 0529 0530 0531 0532 0534 0536 0537 0538 0539 0540 0541 0542 0546
    0547 0548 0549 0551 0552 0553 0554 0556 0557 0558 0559 0560 0561 0562 0563 0564 0568 0569 0570 0571
    0572 0573 0574 0576 0578 0579 0580 0581 0582 0583 0584 0586 0587 0589 0590 0591 0592 0593 0594 0596
    0597 0598 0610 0612 0613 0614 0615 0617 0618 0619 0620 0621 0623 0624 0625 0627 0628 0629 0630 0631
    0632 0634 0635 0637 0638 0639 0640 0641 0642 0643 0645 0647 0648 0649 0650 0651 0652 0653 0657 0658
    0659 0661 0662 0663 0664 0665 0667 0668 0669 0670 0671 0672 0673 0674 0675 0679 0680 0681 0682 0683
    0684 0685 0687 0689 0690 0691 0692 0693 0694 0695 0697 0698 0710 0712 0713 0714 0715 0716 0718 0719
    0720 0721 0723 0724 0725 0726 0728 0729 0730 0731 0732 0734 0735 0736 0738 0739 0740 0741 0742 0743
    0745 0746 0748 0749 0750 0751 0752 0753 0754 0756 0758 0759 0760 0761 0762 0763 0764 0768 0769 0771
    0772 0773 0774 0775 0776 0778 0779 0780 0781 0782 0783 0784 0785 0786 0790 0791 0792 0793 0794 0795
    0796 0798 0810 0812 0813 0814 0815 0816 0817 0819 0820 0821 0823 0824 0825 0826 0827 0829 0830 0831
    0832 0834 0835 0836 0837 0839 0840 0841 0842 0843 0845 0846 0847 0849 0850 0851 0853 0854 0856 0857
    0859 0860 0861 0862 0863 0864 0865 0867 0869 0870 0871 0872 0873 0874 0875 0879 0881 0882 0883 0884
    0885 0886 0887 0889 0890 0891 0892 0893 0894 0895 0896 0897 0910 0912 0913 0914 0915 0916 0917 0918
    0920 0921 0923 0924 0925 0926 0927 0928 0930 0931 0932 0934 0935 0936 0937 0938 0940 0941 0942 0943
    0945 0946 0947 0948 0950 0951 0952 0953 0954 0956 0957 0958 0960 0961 0962 0963 0964 0965 0967 0968
    0970 0971 0972 0973 0974 0975 0976 0978 0980 0981 0982 0983 0984 0985 0986 1002 1003 1004 1005 1006
    1007 1008 1009 1021 1023 1024 1025 1026 1027 1028 1029 1031 1032 1034 1035 1036 1037 1038 1039 1041
    1042 1043 1045 1046 1047 1048 1049 1051 1052 1053 1054 1056 1057 1058 1059 1061 1062 1063 1064 1065
    1067 1068 1069 1071 1072 1073 1074 1075 1076 1078 1079 1081 1082 1083 1084 1085 1086 1087 1089 1091
    1092 1093 1094 1095 1096 1097 1098 1102 1103 1104 1105 1106 1107 1108 1109 1120 1124 1125 1126 1127
    1128 1129 1130 1132 1134 1135 1136 1137 1138 1139 1140 1142 1143 1145 1146 1147 1148 1149 1150 1152
    1153 1154 1156 1157 1158 1159 1160 1162 1163 1164 1165 1167 1168 1169 1170 1172 1173 1174 1175 1176
    1178 1179 1180 1182 1183 1184 1185 1186 1187 1189 1190 1192 1193 1194 1195 1196 1197 1198 1203 1204
    1205 1206 1207 1208 1209 1220 1223 1224 1225 1226 1227 1228 1229 1230 1231 1235 1236 1237 1238 1239
    1240 1241 1243 1245 1246 1247 1248 1249 1250 1251 1253 1254 1256 1257 1258 1259 1260 1261 1263 1264
    1265 1267 1268 1269 1270 1271 1273 1274 1275 1276 1278 1279 1280 1281 1283 1284 1285 1286 1287 1289
    1290 1291 1293 1294 1295 1296 1297 1298 1302 1304 1305 1306 1307 1308 1309 1320 1324 1325 1326 1327
    1328 1329 1330 1332 1334 1335 1336 1337 1338 1339 1340 1341 1342 1346 1347 1348 1349 1350 1351 1352
    1354 1356 1357 1358 1359 1360 1361 1362 1364 1365 1367 1368 1369 1370 1371 1372 1374 1375 1376 1378
    1379 1380 1381 1382 1384 1385 1386 1387 1389 1390 1391 1392 1394 1395 1396 1397 1398 1402 1403 1405
    1406 1407 1408 1409 1420 1421 1423 1425 1426 1427 1428 1429 1430 1431 1435 1436 1437 1438 1439 1440
    1442 1443 1445 1446 1447 1448 1449 1450 1451 1452 1453 1457 1458 1459 1460 1461 1462 1463 1465 1467
    1468 1469 1470 1471 1472 1473 1475 1476 1478 1479 1480 1481 1482 1483 1485 1486 1487 1489 1490 1491
    1492 1493 1495 1496 1497 1498 1502 1503 1504 1506 1507 1508 1509 1520 1521 1523 1524 1526 1527 1528
    1529 1530 1531 1532 1534 1536 1537 1538 1539 1540 1541 1542 1546 1547 1548 1549 1550 1552 1553 1554
    1556 1557 1558 1559 1560 1561 1562 1563 1564 1568 1569 1570 1571 1572 1573 1574 1576 1578 1579 1580
    1581 1582 1583 1584 1586 1587 1589 1590 1591 1592 1593 1594 1596 1597 1598 1602 1603 1604 1605 1607
    1608 1609 1620 1621 1623 1624 1625 1627 1628 1629 1630 1631 1632 1634 1635 1637 1638 1639 1640 1641
    1642 1643 1645 1647 1648 1649 1650 1651 1652 1653 1657 1658 1659 1660 1662 1663 1664 1665 1667 1668
    1669 1670 1671 1672 1673 1674 1675 1679 1680 1681 1682 1683 1684 1685 1687 1689 1690 1691 1692 1693
    1694 1695 1697 1698 1702 1703 1704 1705 1706 1708 1709 1720 1721 1723 1724 1725 1726 1728 1729 1730
    1731 1732 1734 1735 1736 1738 1739 1740 1741 1742 1743 1745 1746 1748 1749 1750 1751 1752 1753 1754
    1756 1758 1759 1760 1761 1762 1763 1764 1768 1769 1770 1772 1773 1774 1775 1776 1778 1779 1780 1781
    1782 1783 1784 1785 1786 1790 1791 1792 1793 1794 1795 1796 1798 1802 1803 1804 1805 1806 1807 1809
    1820 1821 1823 1824 1825 1826 1827 1829 1830 1831 1832 1834 1835 1836 1837 1839 1840 1841 1842 1843
    1845 1846 1847 1849 1850 1851 1852 1853 1854 1856 1857 1859 1860 1861 1862 1863 1864 1865 1867 1869
    1870 1871 1872 1873 1874 1875 1879 1880 1882 1883 1884 1885 1886 1887 1889 1890 1891 1892 1893 1894
    1895 1896 1897 1902 1903 1904 1905 1906 1907 1908 1920 1921 1923 1924 1925 1926 1927 1928 1930 1931
    1932 1934 1935 1936 1937 1938 1940 1941 1942 1943 1945 1946 1947 1948 1950 1951 1952 1953 1954 1956
    1957 1958 1960 1961 1962 1963 1964 1965 1967 1968 1970 1971 1972 1973 1974 1975 1976 1978 1980 1981
    1982 1983 1984 1985 1986 2003 2004 2005 2006 2007 2008 2009 2013 2014 2015 2016 2017 2018 2019 2031
    2032 2034 2035 2036 2037 2038 2039 2041 2042 2043 2045 2046 2047 2048 2049 2051 2052 2053 2054 2056
    2057 2058 2059 2061 2062 2063 2064 2065 2067 2068 2069 2071 2072 2073 2074 2075 2076 2078 2079 2081
    2082 2083 2084 2085 2086 2087 2089 2091 2092 2093 2094 2095 2096 2097 2098 2102 2103 2104 2105 2106
    2107 2108 2109 2110 2113 2114 2115 2116 2117 2118 2119 2130 2132 2134 2135 2136 2137 2138 2139 2140
    2142 2143 2145 2146 2147 2148 2149 2150 2152 2153 2154 2156 2157 2158 2159 2160 2162 2163 2164 2165
    2167 2168 2169 2170 2172 2173 2174 2175 2176 2178 2179 2180 2182 2183 2184 2185 2186 2187 2189 2190
    2192 2193 2194 2195 2196 2197 2198 2203 2204 2205 2206 2207 2208 2209 2213 2214 2215 2216 2217 2218
    2219 2230 2231 2235 2236 2237 2238 2239 2240 2241 2243 2245 2246 2247 2248 2249 2250 2251 2253 2254
    2256 2257 2258 2259 2260 2261 2263 2264 2265 2267 2268 2269 2270 2271 2273 2274 2275 2276 2278 2279
    2280 2281 2283 2284 2285 2286 2287 2289 2290 2291 2293 2294 2295 2296 2297 2298 2302 2304 2305 2306
    2307 2308 2309 2310 2312 2314 2315 2316 2317 2318 2319 2330 2331 2334 2335 2336 2337 2338 2339 2340
    2341 2342 2346 2347 2348 2349 2350 2351 2352 2354 2356 2357 2358 2359 2360 2361 2362 2364 2365 2367
    2368 2369 2370 2371 2372 2374 2375 2376 2378 2379 2380 2381 2382 2384 2385 2386 2387 2389 2390 2391
    2392 2394 2395 2396 2397 2398 2402 2403 2405 2406 2407 2408 2409 2410 2412 2413 2415 2416 2417 2418
    2419 2430 2431 2435 2436 2437 2438 2439 2440 2441 2443 2445 2446 2447 2448 2449 2450 2451 2452 2453
    2457 2458 2459 2460 2461 2462 2463 2465 2467 2468 2469 2470 2471 2472 2473 2475 2476 2478 2479 2480
    2481 2482 2483 2485 2486 2487 2489 2490 2491 2492 2493 2495 2496 2497 2498 2502 2503 2504 2506 2507
    2508 2509 2510 2512 2513 2514 2516 2517 2518 2519 2530 2531 2532 2534 2536 2537 2538 2539 2540 2541
    2542 2546 2547 2548 2549 2550 2551 2553 2554 2556 2557 2558 2559 2560 2561 2562 2563 2564 2568 2569
    2570 2571 2572 2573 2574 2576 2578 2579 2581 2582 2583 2584 2586 2587 2589 2590 2591 2592 2593 2594
    2596 2597 2598 2602 2603 2604 2605 2607 2608 2609 2610 2612 2613 2614 2615 2617 2618 2619 2630 2631
    2632 2634 2635 2637 2638 2639 2640 2641 2642 2643 2645 2647 2648 2649 2650 2651 2652 2653 2657 2658
    2659 2660 2661 2663 2664 2665 2667 2668 2669 2670 2671 2672 2673 2674 2675 2679 2680 2681 2682 2683
    2684 2685 2687 2689 2690 2691 2692 2693 2694 2695 2697 2698 2702 2703 2704 2705 2706 2708 2709 2710
    2712 2713 2714 2715 2716 2718 2719 2730 2731 2732 2734 2735 2736 2738 2739 2740 2741 2742 2743 2745
    2746 2748 2749 2750 2751 2752 2753 2754 2756 2758 2759 2760 2761 2762 2763 2764 2768 2769 2770 2771
    2773 2774 2775 2776 2778 2779 2780 2781 2782 2783 2784 2785 2786 2790 2791 2792 2793 2794 2795 2796
    2798 2802 2803 2804 2805 2806 2807 2809 2810 2812 2813 2814 2815 2816 2817 2819 2830 2831 2832 2834
    2835 2836 2837 2839 2840 2841 2842 2843 2845 2846 2847 2849 2850 2851 2852 2853 2854 2856 2857 2859
    2860 2861 2862 2863 2864 2865 2867 2869 2870 2871 2872 2873 2874 2875 2879 2880 2881 2883 2884 2885
    2886 2887 2889 2890 2891 2892 2893 2894 2895 2896 2897 2902 2903 2904 2905 2906 2907 2908 2910 2912
    2913 2914 2915 2916 2917 2918 2930 2931 2932 2934 2935 2936 2937 2938 2940 2941 2942 2943 2945 2946
    2947 2948 2950 2951 2952 2953 2954 2956 2957 2958 2960 2961 2962 2963 2964 2965 2967 2968 2970 2971
    2972 2973 2974 2975 2976 2978 2980 2981 2982 2983 2984 2985 2986 3002 3004 3005 3006 3007 3008 3009
    3013 3014 3015 3016 3017 3018 3019 3021 3023 3024 3025 3026 3027 3028 3029 3041 3042 3043 3045 3046
    3047 3048 3049 3051 3052 3053 3054 3056 3057 3058 3059 3061 3062 3063 3064 3065 3067 3068 3069 3071
    3072 3073 3074 3075 3076 3078 3079 3081 3082 3083 3084 3085 3086 3087 3089 3091 3092 3093 3094 3095
    3096 3097 3098 3102 3103 3104 3105 3106 3107 3108 3109 3110 3112 3114 3115 3116 3117 3118 3119 3120
    3124 3125 3126 3127 3128 3129 3140 3142 3143 3145 3146 3147 3148 3149 3150 3152 3153 3154 3156 3157
    3158 3159 3160 3162 3163 3164 3165 3167 3168 3169 3170 3172 3173 3174 3175 3176 3178 3179 3180 3182
    3183 3184 3185 3186 3187 3189 3190 3192 3193 3194 3195 3196 3197 3198 3203 3204 3205 3206 3207 3208
    3209 3213 3214 3215 3216 3217 3218 3219 3220 3221 3224 3225 3226 3227 3228 3229 3240 3241 3243 3245
    3246 3247 3248 3249 3250 3251 3253 3254 3256 3257 3258 3259 3260 3261 3263 3264 3265 3267 3268 3269
    3270 3271 3273 3274 3275 3276 3278 3279 3280 3281 3283 3284 3285 3286 3287 3289 3290 3291 3293 3294
    3295 3296 3297 3298 3302 3304 3305 3306 3307 3308 3309 3310 3312 3314 3315 3316 3317 3318 3319 3320
    3324 3325 3326 3327 3328 3329 3340 3341 3342 3346 3347 3348 3349 3350 3351 3352 3354 3356 3357 3358
    3359 3360 3361 3362 3364 3365 3367 3368 3369 3370 3371 3372 3374 3375 3376 3378 3379 3380 3381 3382
    3384 3385 3386 3387 3389 3390 3391 3392 3394 3395 3396 3397 3398 3402 3403 3405 3406 3407 3408 3409
    3410 3412 3413 3415 3416 3417 3418 3419 3420 3421 3423 3425 3426 3427 3428 3429 3440 3441 3442 3445
    3446 3447 3448 3449 3450 3451 3452 3453 3457 3458 3459 3460 3461 3462 3463 3465 3467 3468 3469 3470
    3471 3472 3473 3475 3476 3478 3479 3480 3481 3482 3483 3485 3486 3487 3489 3490 3491 3492 3493 3495
    3496 3497 3498 3502 3503 3504 3506 3507 3508 3509 3510 3512 3513 3514 3516 3517 3518 3519 3520 3521
    3523 3524 3526 3527 3528 3529 3540 3541 3542 3546 3547 3548 3549 3550 3551 3552 3554 3556 3557 3558
    3559 3560 3561 3562 3563 3564 3568 3569 3570 3571 3572 3573 3574 3576 3578 3579 3580 3581 3582 3583
    3584 3586 3587 3589 3590 3591 3592 3593 3594 3596 3597 3598 3602 3603 3604 3605 3607 3608 3609 3610
    3612 3613 3614 3615 3617 3618 3619 3620 3621 3623 3624 3625 3627 3628 3629 3640 3641 3642 3643 3645
    3647 3648 3649 3650 3651 3652 3653 3657 3658 3659 3660 3661 3662 3664 3665 3667 3668 3669 3670 3671
    3672 3673 3674 3675 3679 3680 3681 3682 3683 3684 3685 3687 3689 3690 3691 3692 3693 3694 3695 3697
    3698 3702 3703 3704 3705 3706 3708 3709 3710 3712 3713 3714 3715 3716 3718 3719 3720 3721 3723 3724
    3725 3726 3728 3729 3740 3741 3742 3743 3745 3746 3748 3749 3750 3751 3752 3753 3754 3756 3758 3759
    3760 3761 3762 3763 3764 3768 3769 3770 3771 3772 3774 3775 3776 3778 3779 3780 3781 3782 3783 3784
    3785 3786 3790 3791 3792 3793 3794 3795 3796 3798 3802 3803 3804 3805 3806 3807 3809 3810 3812 3813
    3814 3815 3816 3817 3819 3820 3821 3823 3824 3825 3826 3827 3829 3840 3841 3842 3843 3845 3846 3847
    3849 3850 3851 3852 3853 3854 3856 3857 3859 3860 3861 3862 3863 3864 3865 3867 3869 3870 3871 3872
    3873 3874 3875 3879 3880 3881 3882 3884 3885 3886 3887 3889 3890 3891 3892 3893 3894 3895 3896 3897
    3902 3903 3904 3905 3906 3907 3908 3910 3912 3913 3914 3915 3916 3917 3918 3920 3921 3923 3924 3925
    3926 3927 3928 3940 3941 3942 3943 3945 3946 3947 3948 3950 3951 3952 3953 3954 3956 3957 3958 3960
    3961 3962 3963 3964 3965 3967 3968 3970 3971 3972 3973 3974 3975 3976 3978 3980 3981 3982 3983 3984
    3985 3986 4002 4003 4005 4006 4007 4008 4009 4013 4014 4015 4016 4017 4018 4019 4021 4023 4024 4025
    4026 4027 4028 4029 4031 4032 4034 4035 4036 4037 4038 4039 4051 4052 4053 4054 4056 4057 4058 4059
    4061 4062 4063 4064 4065 4067 4068 4069 4071 4072 4073 4074 4075 4076 4078 4079 4081 4082 4083 4084
    4085 4086 4087 4089 4091 4092 4093 4094 4095 4096 4097 4098 4102 4103 4104 4105 4106 4107 4108 4109
    4110 4112 4113 4115 4116 4117 4118 4119 4120 4124 4125 4126 4127 4128 4129 4130 4132 4134 4135 4136
    4137 4138 4139 4150 4152 4153 4154 4156 4157 4158 4159 4160 4162 4163 4164 4165 4167 4168 4169 4170
    4172 4173 4174 4175 4176 4178 4179 4180 4182 4183 4184 4185 4186 4187 4189 4190 4192 4193 4194 4195
    4196 4197 4198 4203 4204 4205 4206 4207 4208 4209 4213 4214 4215 4216 4217 4218 4219 4220 4221 4223
    4225 4226 4227 4228 4229 4230 4231 4235 4236 4237 4238 4239 4250 4251 4253 4254 4256 4257 4258 4259
    4260 4261 4263 4264 4265 4267 4268 4269 4270 4271 4273 4274 4275 4276 4278 4279 4280 4281 4283 4284
    4285 4286 4287 4289 4290 4291 4293 4294 4295 4296 4297 4298 4302 4304 4305 4306 4307 4308 4309 4310
    4312 4314 4315 4316 4317 4318 4319 4320 4324 4325 4326 4327 4328 4329 4330 4331 4332 4335 4336 4337
    4338 4339 4350 4351 4352 4354 4356 4357 4358 4359 4360 4361 4362 4364 4365 4367 4368 4369 4370 4371
    4372 4374 4375 4376 4378 4379 4380 4381 4382 4384 4385 4386 4387 4389 4390 4391 4392 4394 4395 4396
    4397 4398 4402 4403 4405 4406 4407 4408 4409 4410 4412 4413 4415 4416 4417 4418 4419 4420 4421 4423
    4425 4426 4427 4428 4429 4430 4431 4435 4436 4437 4438 4439 4450 4451 4452 4453 4457 4458 4459 4460
    4461 4462 4463 4465 4467 4468 4469 4470 4471 4472 4473 4475 4476 4478 4479 4480 4481 4482 4483 4485
    4486 4487 4489 4490 4491 4492 4493 4495 4496 4497 4498 4502 4503 4504 4506 4507 4508 4509 4510 4512
    4513 4514 4516 4517 4518 4519 4520 4521 4523 4524 4526 4527 4528 4529 4530 4531 4532 4534 4536 4537
    4538 4539 4550 4551 4552 4553 4556 4557 4558 4559 4560 4561 4562 4563 4564 4568 4569 4570 4571 4572
    4573 4574 4576 4578 4579 4580 4581 4582 4583 4584 4586 4587 4589 4590 4591 4592 4593 4594 4596 4597
    4598 4602 4603 4604 4605 4607 4608 4609 4610 4612 4613 4614 4615 4617 4618 4619 4620 4621 4623 4624
    4625 4627 4628 4629 4630 4631 4632 4634 4635 4637 4638 4639 4650 4651 4652 4653 4657 4658 4659 4660
    4661 4662 4663 4665 4667 4668 4669 4670 4671 4672 4673 4674 4675 4679 4680 4681 4682 4683 4684 4685
    4687 4689 4690 4691 4692 4693 4694 4695 4697 4698 4702 4703 4704 4705 4706 4708 4709 4710 4712 4713
    4714 4715 4716 4718 4719 4720 4721 4723 4724 4725 4726 4728 4729 4730 4731 4732 4734 4735 4736 4738
    4739 4750 4751 4752 4753 4754 4756 4758 4759 4760 4761 4762 4763 4764 4768 4769 4770 4771 4772 4773
    4775 4776 4778 4779 4780 4781 4782 4783 4784 4785 4786 4790 4791 4792 4793 4794 4795 4796 4798 4802
    4803 4804 4805 4806 4807 4809 4810 4812 4813 4814 4815 4816 4817 4819 4820 4821 4823 4824 4825 4826
    4827 4829 4830 4831 4832 4834 4835 4836 4837 4839 4850 4851 4852 4853 4854 4856 4857 4859 4860 4861
    4862 4863 4864 4865 4867 4869 4870 4871 4872 4873 4874 4875 4879 4880 4881 4882 4883 4885 4886 4887
    4889 4890 4891 4892 4893 4894 4895 4896 4897 4902 4903 4904 4905 4906 4907 4908 4910 4912 4913 4914
    4915 4916 4917 4918 4920 4921 4923 4924 4925 4926 4927 4928 4930 4931 4932 4934 4935 4936 4937 4938
    4950 4951 4952 4953 4954 4956 4957 4958 4960 4961 4962 4963 4964 4965 4967 4968 4970 4971 4972 4973
    4974 4975 4976 4978 4980 4981 4982 4983 4984 4985 4986 5002 5003 5004 5006 5007 5008 5009 5013 5014
    5015 5016 5017 5018 5019 5021 5023 5024 5025 5026 5027 5028 5029 5031 5032 5034 5035 5036 5037 5038
    5039 5041 5042 5043 5045 5046 5047 5048 5049 5061 5062 5063 5064 5065 5067 5068 5069 5071 5072 5073
    5074 5075 5076 5078 5079 5081 5082 5083 5084 5085 5086 5087 5089 5091 5092 5093 5094 5095 5096 5097
    5098 5102 5103 5104 5105 5106 5107 5108 5109 5110 5112 5113 5114 5116 5117 5118 5119 5120 5124 5125
    5126 5127 5128 5129 5130 5132 5134 5135 5136 5137 5138 5139 5140 5142 5143 5145 5146 5147 5148 5149
    5160 5162 5163 5164 5165 5167 5168 5169 5170 5172 5173 5174 5175 5176 5178 5179 5180 5182 5183 5184
    5185 5186 5187 5189 5190 5192 5193 5194 5195 5196 5197 5198 5203 5204 5205 5206 5207 5208 5209 5213
    5214 5215 5216 5217 5218 5219 5220 5221 5223 5224 5226 5227 5228 5229 5230 5231 5235 5236 5237 5238
    5239 5240 5241 5243 5245 5246 5247 5248 5249 5260 5261 5263 5264 5265 5267 5268 5269 5270 5271 5273
    5274 5275 5276 5278 5279 5280 5281 5283 5284 5285 5286 5287 5289 5290 5291 5293 5294 5295 5296 5297
    5298 5302 5304 5305 5306 5307 5308 5309 5310 5312 5314 5315 5316 5317 5318 5319 5320 5324 5325 5326
    5327 5328 5329 5330 5331 5332 5334 5336 5337 5338 5339 5340 5341 5342 5346 5347 5348 5349 5360 5361
    5362 5364 5365 5367 5368 5369 5370 5371 5372 5374 5375 5376 5378 5379 5380 5381 5382 5384 5385 5386
    5387 5389 5390 5391 5392 5394 5395 5396 5397 5398 5402 5403 5405 5406 5407 5408 5409 5410 5412 5413
    5415 5416 5417 5418 5419 5420 5421 5423 5425 5426 5427 5428 5429 5430 5431 5435 5436 5437 5438 5439
    5440 5441 5442 5443 5446 5447 5448 5449 5460 5461 5462 5463 5465 5467 5468 5469 5470 5471 5472 5473
    5475 5476 5478 5479 5480 5481 5482 5483 5485 5486 5487 5489 5490 5491 5492 5493 5495 5496 5497 5498
    5502 5503 5504 5506 5507 5508 5509 5510 5512 5513 5514 5516 5517 5518 5519 5520 5521 5523 5524 5526
    5527 5528 5529 5530 5531 5532 5534 5536 5537 5538 5539 5540 5541 5542 5546 5547 5548 5549 5560 5561
    5562 5563 5564 5568 5569 5570 5571 5572 5573 5574 5576 5578 5579 5580 5581 5582 5583 5584 5586 5587
    5589 5590 5591 5592 5593 5594 5596 5597 5598 5602 5603 5604 5605 5607 5608 5609 5610 5612 5613 5614
    5615 5617 5618 5619 5620 5621 5623 5624 5625 5627 5628 5629 5630 5631 5632 5634 5635 5637 5638 5639
    5640 5641 5642 5643 5645 5647 5648 5649 5660 5661 5662 5663 5664 5667 5668 5669 5670 5671 5672 5673
    5674 5675 5679 5680 5681 5682 5683 5684 5685 5687 5689 5690 5691 5692 5693 5694 5695 5697 5698 5702
    5703 5704 5705 5706 5708 5709 5710 5712 5713 5714 5715 5716 5718 5719 5720 5721 5723 5724 5725 5726
    5728 5729 5730 5731 5732 5734 5735 5736 5738 5739 5740 5741 5742 5743 5745 5746 5748 5749 5760 5761
    5762 5763 5764 5768 5769 5770 5771 5772 5773 5774 5776 5778 5779 5780 5781 5782 5783 5784 5785 5786
    5790 5791 5792 5793 5794 5795 5796 5798 5802 5803 5804 5805 5806 5807 5809 5810 5812 5813 5814 5815
    5816 5817 5819 5820 5821 5823 5824 5825 5826 5827 5829 5830 5831 5832 5834 5835 5836 5837 5839 5840
    5841 5842 5843 5845 5846 5847 5849 5860 5861 5862 5863 5864 5865 5867 5869 5870 5871 5872 5873 5874
    5875 5879 5880 5881 5882 5883 5884 5886 5887 5889 5890 5891 5892 5893 5894 5895 5896 5897 5902 5903
    5904 5905 5906 5907 5908 5910 5912 5913 5914 5915 5916 5917 5918 5920 5921 5923 5924 5925 5926 5927
    5928 5930 5931 5932 5934 5935 5936 5937 5938 5940 5941 5942 5943 5945 5946 5947 5948 5960 5961 5962
    5963 5964 5965 5967 5968 5970 5971 5972 5973 5974 5975 5976 5978 5980 5981 5982 5983 5984 5985 5986
    6002 6003 6004 6005 6007 6008 6009 6013 6014 6015 6016 6017 6018 6019 6021 6023 6024 6025 6026 6027
    6028 6029 6031 6032 6034 6035 6036 6037 6038 6039 6041 6042 6043 6045 6046 6047 6048 6049 6051 6052
    6053 6054 6056 6057 6058 6059 6071 6072 6073 6074 6075 6076 6078 6079 6081 6082 6083 6084 6085 6086
    6087 6089 6091 6092 6093 6094 6095 6096 6097 6098 6102 6103 6104 6105 6106 6107 6108 6109 6110 6112
    6113 6114 6115 6117 6118 6119 6120 6124 6125 6126 6127 6128 6129 6130 6132 6134 6135 6136 6137 6138
    6139 6140 6142 6143 6145 6146 6147 6148 6149 6150 6152 6153 6154 6156 6157 6158 6159 6170 6172 6173
    6174 6175 6176 6178 6179 6180 6182 6183 6184 6185 6186 6187 6189 6190 6192 6193 6194 6195 6196 6197
    6198 6203 6204 6205 6206 6207 6208 6209 6213 6214 6215 6216 6217 6218 6219 6220 6221 6223 6224 6225
    6227 6228 6229 6230 6231 6235 6236 6237 6238 6239 6240 6241 6243 6245 6246 6247 6248 6249 6250 6251
    6253 6254 6256 6257 6258 6259 6270 6271 6273 6274 6275 6276 6278 6279 6280 6281 6283 6284 6285 6286
    6287 6289 6290 6291 6293 6294 6295 6296 6297 6298 6302 6304 6305 6306 6307 6308 6309 6310 6312 6314
    6315 6316 6317 6318 6319 6320 6324 6325 6326 6327 6328 6329 6330 6331 6332 6334 6335 6337 6338 6339
    6340 6341 6342 6346 6347 6348 6349 6350 6351 6352 6354 6356 6357 6358 6359 6370 6371 6372 6374 6375
    6376 6378 6379 6380 6381 6382 6384 6385 6386 6387 6389 6390 6391 6392 6394 6395 6396 6397 6398 6402
    6403 6405 6406 6407 6408 6409 6410 6412 6413 6415 6416 6417 6418 6419 6420 6421 6423 6425 6426 6427
    6428 6429 6430 6431 6435 6436 6437 6438 6439 6440 6441 6442 6443 6445 6447 6448 6449 6450 6451 6452
    6453 6457 6458 6459 6470 6471 6472 6473 6475 6476 6478 6479 6480 6481 6482 6483 6485 6486 6487 6489
    6490 6491 6492 6493 6495 6496 6497 6498 6502 6503 6504 6506 6507 6508 6509 6510 6512 6513 6514 6516
    6517 6518 6519 6520 6521 6523 6524 6526 6527 6528 6529 6530 6531 6532 6534 6536 6537 6538 6539 6540
    6541 6542 6546 6547 6548 6549 6550 6551 6552 6553 6554 6557 6558 6559 6570 6571 6572 6573 6574 6576
    6578 6579 6580 6581 6582 6583 6584 6586 6587 6589 6590 6591 6592 6593 6594 6596 6597 6598 6602 6603
    6604 6605 6607 6608 6609 6610 6612 6613 6614 6615 6617 6618 6619 6620 6621 6623 6624 6625 6627 6628
    6629 6630 6631 6632 6634 6635 6637 6638 6639 6640 6641 6642 6643 6645 6647 6648 6649 6650 6651 6652
    6653 6657 6658 6659 6670 6671 6672 6673 6674 6675 6679 6680 6681 6682 6683 6684 6685 6687 6689 6690
    6691 6692 6693 6694 6695 6697 6698 6702 6703 6704 6705 6706 6708 6709 6710 6712 6713 6714 6715 6716
    6718 6719 6720 6721 6723 6724 6725 6726 6728 6729 6730 6731 6732 6734 6735 6736 6738 6739 6740 6741
    6742 6743 6745 6746 6748 6749 6750 6751 6752 6753 6754 6756 6758 6759 6770 6771 6772 6773 6774 6775
    6778 6779 6780 6781 6782 6783 6784 6785 6786 6790 6791 6792 6793 6794 6795 6796 6798 6802 6803 6804
    6805 6806 6807 6809 6810 6812 6813 6814 6815 6816 6817 6819 6820 6821 6823 6824 6825 6826 6827 6829
    6830 6831 6832 6834 6835 6836 6837 6839 6840 6841 6842 6843 6845 6846 6847 6849 6850 6851 6852 6853
    6854 6856 6857 6859 6870 6871 6872 6873 6874 6875 6879 6880 6881 6882 6883 6884 6885 6887 6889 6890
    6891 6892 6893 6894 6895 6896 6897 6902 6903 6904 6905 6906 6907 6908 6910 6912 6913 6914 6915 6916
    6917 6918 6920 6921 6923 6924 6925 6926 6927 6928 6930 6931 6932 6934 6935 6936 6937 6938 6940 6941
    6942 6943 6945 6946 6947 6948 6950 6951 6952 6953 6954 6956 6957 6958 6970 6971 6972 6973 6974 6975
    6976 6978 6980 6981 6982 6983 6984 6985 6986 7002 7003 7004 7005 7006 7008 7009 7013 7014 7015 7016
    7017 7018 7019 7021 7023 7024 7025 7026 7027 7028 7029 7031 7032 7034 7035 7036 7037 7038 7039 7041
    7042 7043 7045 7046 7047 7048 7049 7051 7052 7053 7054 7056 7057 7058 7059 7061 7062 7063 7064 7065
    7067 7068 7069 7081 7082 7083 7084 7085 7086 7087 7089 7091 7092 7093 7094 7095 7096 7097 7098 7102
    7103 7104 7105 7106 7107 7108 7109 7110 7112 7113 7114 7115 7116 7118 7119 7120 7124 7125 7126 7127
    7128 7129 7130 7132 7134 7135 7136 7137 7138 7139 7140 7142 7143 7145 7146 7147 7148 7149 7150 7152
    7153 7154 7156 7157 7158 7159 7160 7162 7163 7164 7165 7167 7168 7169 7180 7182 7183 7184 7185 7186
    7187 7189 7190 7192 7193 7194 7195 7196 7197 7198 7203 7204 7205 7206 7207 7208 7209 7213 7214 7215
    7216 7217 7218 7219 7220 7221 7223 7224 7225 7226 7228 7229 7230 7231 7235 7236 7237 7238 7239 7240
    7241 7243 7245 7246 7247 7248 7249 7250 7251 7253 7254 7256 7257 7258 7259 7260 7261 7263 7264 7265
    7267 7268 7269 7280 7281 7283 7284 7285 7286 7287 7289 7290 7291 7293 7294 7295 7296 7297 7298 7302
    7304 7305 7306 7307 7308 7309 7310 7312 7314 7315 7316 7317 7318 7319 7320 7324 7325 7326 7327 7328
    7329 7330 7331 7332 7334 7335 7336 7338 7339 7340 7341 7342 7346 7347 7348 7349 7350 7351 7352 7354
    7356 7357 7358 7359 7360 7361 7362 7364 7365 7367 7368 7369 7380 7381 7382 7384 7385 7386 7387 7389
    7390 7391 7392 7394 7395 7396 7397 7398 7402 7403 7405 7406 7407 7408 7409 7410 7412 7413 7415 7416
    7417 7418 7419 7420 7421 7423 7425 7426 7427 7428 7429 7430 7431 7435 7436 7437 7438 7439 7440 7441
    7442 7443 7445 7446 7448 7449 7450 7451 7452 7453 7457 7458 7459 7460 7461 7462 7463 7465 7467 7468
    7469 7480 7481 7482 7483 7485 7486 7487 7489 7490 7491 7492
    '''.split() if suffix
])
# Уникализация номеров телефонов по последним 4 цифрам в номере
# Алгоритм можно будет удалить, когда партнёр заменит номера
tmp = []
flash_call_dupes = []  # не используется, но полезно для поиска дублей при запуске через интерпретатор ya py
seen_codes = set()
for flash_call_calling_number in FLASH_CALL_NUMBERS:
    code = flash_call_calling_number[-4:]
    if code in seen_codes:
        flash_call_dupes.append(flash_call_calling_number)
        continue
    seen_codes.add(code)
    tmp.append(flash_call_calling_number)
FLASH_CALL_NUMBERS = tmp

PHONE_DIGITAL_PREFIXES_BLACKLIST = ['7954']

# Количество звонков, необходимое для начала подсчета статистики (> 1)
OCTOPUS_COUNTERS_MIN_COUNT = 10
# Порог отношения отказов телефонии ко всем созданным сессиям
OCTOPUS_GATES_WORKING_THRESHOLD = 0.9

CALL_STATUS_IN_PROGRESS = 'InProgress'
CALL_STATUS_REJECTED = 'Rejected'
CALL_STATUS_NO_ANSWER = 'NoAnswer'
CALL_STATUS_UNAVAILABLE = 'Unavailable'
CALL_STATUS_SUCCESS = 'Success'
CALL_STATUS_INTERRUPTED = 'Interrupted'

TELEPHONY_OK_STATUSES = [
    CALL_STATUS_IN_PROGRESS,
    CALL_STATUS_REJECTED,
    CALL_STATUS_NO_ANSWER,
    CALL_STATUS_UNAVAILABLE,
    CALL_STATUS_SUCCESS,
    CALL_STATUS_INTERRUPTED,
]
