# -*- coding: utf-8 -*-
import os

from passport.backend.utils.file import read_file
import yenv


# Незакодированные ПДД-домены, пользователям которых можно восстанавливать доступ
# к аккаунту через саппорт Яндекса.
# Список см. на Вики https://wiki.yandex-team.ru/support/kpk/passport/i/database#pdd
DOMAINS_SERVED_BY_SUPPORT = frozenset([
    '5ballov.ru',
    'aeterna.ru',
    'avril.ru',
    'borda.ru',
    'dezigner.ru',
    'email.su',
    'epage.ru',
    'fotoplenka.ru',
    'fromru.com',
    'front.ru',
    'hotbox.ru',
    'hotmail.ru',
    'hu2.ru',
    'justlunch.ru',
    'krovatka.su',
    'land.ru',
    'loveplanet.ru',
    'mail15.com',
    'mail2k.ru',
    'mail333.com',
    'memori.ru',
    'newmail.ru',
    'nextmail.ru',
    'nightmail.ru',
    'nm.ru',
    'nxt.ru',
    'photofile.ru',
    'pisem.net',
    'pochta.com',
    'pochta.ru',
    'pochtamt.ru',
    'pop3.ru',
    'programist.ru',
    'qip.ru',
    'rbcmail.ru',
    'restore-general.ru',
    'smtp.ru',
    'student.su',
    'tut.by',
    'webmail.ru',
    'xaker.ru',
    'zahvat.ru',
    'ziza.ru',
    # тестовые домены
    'restore-general.ru',  # Для тестирования на rc и в продакшне
    u'ресторе.генерал.рф',  # Для тестирования с кириллическими доменами
])


DOMAINS_USED_BY_DIRECTORY = frozenset(['yaserv.biz', 'yaconnect.com'])


RESTRICTED_DIRECTORY_SUBDOMAINS = set(read_file(
    os.path.join(os.path.dirname(__file__), 'restricted_directory_subdomains.txt'),
).strip().split())



OPTIONS_USE_NEW_SERIALIZATION_SCHEME = yenv.type == 'development'


USE_NEW_DIRECTORY_ACCOUNT_COMPLETION = yenv.type in ('development', 'testing')
