# -*- coding: utf-8 -*-
from passport.backend.api.settings.app_ids import (
    app_id_with_suffix,
    TAXI_SUFFIX_LIST,
)


PHONISH_NAMESPACE_DEFAULT = None  # именно None, чтобы не писать лишнего в БД
_PHONISH_NAMESPACE_VEZET = 'vezet'
_PHONISH_NAMESPACE_RUTAXI = 'rutaxi'


# app_id должны быть в lowercase
APP_ID_TO_PHONISH_NAMESPACE = {}
APP_ID_TO_PHONISH_NAMESPACE.update({
    app_id: _PHONISH_NAMESPACE_VEZET
    for app_id in app_id_with_suffix('ru.yandex.vezet', TAXI_SUFFIX_LIST)
})
APP_ID_TO_PHONISH_NAMESPACE.update({
    app_id: _PHONISH_NAMESPACE_RUTAXI
    for app_id in app_id_with_suffix('ru.nightwill.rutaxionline', TAXI_SUFFIX_LIST)
})
APP_ID_TO_PHONISH_NAMESPACE.update({
    app_id: _PHONISH_NAMESPACE_RUTAXI
    for app_id in app_id_with_suffix('com.its.rto', TAXI_SUFFIX_LIST)
})
