# -*- coding: utf-8 -*-

import yenv


_PUSH_API_URLS = {
    'intranet': {
        'development': 'https://push-sandbox.yandex.ru',
        'testing': 'https://push.yandex-team.ru',
        'rc': 'https://push.yandex-team.ru',
        'production': 'https://push.yandex-team.ru',
    },
    'localhost': {
        'development': 'https://push-sandbox.yandex.ru',
        'testing': 'https://push-sandbox.yandex.ru',
        'rc': 'https://push.yandex.ru',
        'production': 'https://push.yandex.ru',
    },
    'stress': {
        'stress': '',
    },
}

PUSH_API_URL = _PUSH_API_URLS[yenv.name][yenv.type]

# максимальное время ожидания ответа PushApi
if yenv.type in ('development', 'testing'):
    PUSH_API_TIMEOUT = 2
else:
    PUSH_API_TIMEOUT = 0.1

# число попыток получить ответ от PushApi
PUSH_API_RETRIES = 3

# имя сервиса в PushApi
PUSH_API_SERVICE_NAME = 'passport-push'

# ключи текстов для пуша про вероятный взлом
PUSH_SECURITY_TITLE_KEY = 'passport_push_security_title_key'
PUSH_SECURITY_MESSAGE_KEY = 'passport_push_security_message_key'

PUSH_APP_NAME_POSTFIX_ANDROID = '.passport'
