# -*- coding: utf-8 -*-

import yenv


QUEUE_CONSUMER = 'passport'
QUEUE_TIMEOUT = 0.3
QUEUE_RETRIES = 2

if yenv.type in {'production', 'rc'}:
    QUEUE_URL = 'http://queue-api.passport.yandex.net/'
elif yenv.type == 'testing':
    QUEUE_URL = 'http://queue-api-test.passport.yandex.net/'
elif yenv.type == 'development':
    QUEUE_URL = 'http://passportdev-python3.yandex.net:9012/'
    QUEUE_TIMEOUT = 5
else:
    QUEUE_URL = None


QUEUE_ENCRYPTION_KEY_EPOCH_LENGTH = 60 * 60 * 24 * 30  # 30 суток

QUEUE_ENCRYPTION_KEY_DIR = '/etc/yandex/passport-crypto-keys/queue'
