# -*- coding: utf-8 -*-
from frozendict import frozendict
import yenv

from . import secrets
from .hosts import get_host_id_by_hostname


def _server_config(hostname, port=6379, node_type='master', use_tls=False):
    return {
        'host': hostname,
        'port': port,
        'type': node_type,
        'socket_timeout': 0.5,
        'passwords': [
            pwd
            for pwd in [secrets.REDIS_PASSWORD, secrets.REDIS_PASSWORD_2]
            if pwd not in ['', '-']
        ],
        'use_tls': use_tls,
    }


def _group_with_master_config(hostname, port=6379, use_tls=False):
    return {
        'master': _server_config(hostname, port, use_tls=use_tls),
    }


_REDIS_CONFIG = {
    'other': {
        'development': {
            0x7F: frozendict({
                'master': _server_config('localhost'),
            }),
        },
        'testing': frozendict(
            (get_host_id_by_hostname(hostname), _group_with_master_config(hostname, port=6380, use_tls=True))
            for hostname in [
                's1.redis-test.passport.yandex.net',
                'v1.redis-test.passport.yandex.net',
            ]
        ),
        'production': frozendict(
            [(get_host_id_by_hostname(hostname), _group_with_master_config(hostname, port=6380, use_tls=True))
                for hostname in [
                    # Машины из RC.
                    's1.redis-rc.passport.yandex.net',
                    'v1.redis-rc.passport.yandex.net',
                    # Мытищи prestable
                    'm1.redis.passport.yandex.net',
                    'm2.redis.passport.yandex.net',
                    'm3.redis.passport.yandex.net',
                    'm4.redis.passport.yandex.net',
                    'm5.redis.passport.yandex.net',
                    'm6.redis.passport.yandex.net',
                    'm7.redis.passport.yandex.net',
                    'm8.redis.passport.yandex.net',
                    'm9.redis.passport.yandex.net',
                    'm10.redis.passport.yandex.net',
                    'm11.redis.passport.yandex.net',
                    'm12.redis.passport.yandex.net',
                    # sas
                    's1.redis.passport.yandex.net',
                    's2.redis.passport.yandex.net',
                    's3.redis.passport.yandex.net',
                    's4.redis.passport.yandex.net',
                    's5.redis.passport.yandex.net',
                    's6.redis.passport.yandex.net',
                    's7.redis.passport.yandex.net',
                    's8.redis.passport.yandex.net',
                    's9.redis.passport.yandex.net',
                    's10.redis.passport.yandex.net',
                    's11.redis.passport.yandex.net',
                    's12.redis.passport.yandex.net',
                    's13.redis.passport.yandex.net',
                    's14.redis.passport.yandex.net',
                    's15.redis.passport.yandex.net',
                    's16.redis.passport.yandex.net',
                    's17.redis.passport.yandex.net',
                    's18.redis.passport.yandex.net',
                    's19.redis.passport.yandex.net',
                    's20.redis.passport.yandex.net',
                    's21.redis.passport.yandex.net',
                    's22.redis.passport.yandex.net',
                    's23.redis.passport.yandex.net',
                    's24.redis.passport.yandex.net',
                    's25.redis.passport.yandex.net',
                    's26.redis.passport.yandex.net',
                    's27.redis.passport.yandex.net',
                    's28.redis.passport.yandex.net',
                    's29.redis.passport.yandex.net',
                    's30.redis.passport.yandex.net',
                    's31.redis.passport.yandex.net',
                    # iva
                    'i1.redis.passport.yandex.net',
                    'i2.redis.passport.yandex.net',
                    'i3.redis.passport.yandex.net',
                    'i4.redis.passport.yandex.net',
                    'i5.redis.passport.yandex.net',
                    'i6.redis.passport.yandex.net',
                    'i7.redis.passport.yandex.net',
                    'i8.redis.passport.yandex.net',
                    'i9.redis.passport.yandex.net',
                    'i10.redis.passport.yandex.net',
                    'i11.redis.passport.yandex.net',
                    'i12.redis.passport.yandex.net',
                    # vla
                    'v1.redis.passport.yandex.net',
                    'v2.redis.passport.yandex.net',
                    'v3.redis.passport.yandex.net',
                    'v4.redis.passport.yandex.net',
                    'v5.redis.passport.yandex.net',
                    'v6.redis.passport.yandex.net',
                    'v7.redis.passport.yandex.net',
                    'v8.redis.passport.yandex.net',
                    'v9.redis.passport.yandex.net',
                    'v10.redis.passport.yandex.net',
                    'v11.redis.passport.yandex.net',
                    'v12.redis.passport.yandex.net',
                    'v13.redis.passport.yandex.net',
                    'v14.redis.passport.yandex.net',
                    'v15.redis.passport.yandex.net',
                    'v16.redis.passport.yandex.net',
                    'v17.redis.passport.yandex.net',
                ]
            ],
        ),
    },
    'stress': {
        'stress': {
            0x5F: frozendict({
                'master': _server_config('passport-load.passport.yandex.net', port=6380, use_tls=True),
            }),
        }
    },
    'intranet': {
        'testing': frozendict(
            (get_host_id_by_hostname(hostname), _group_with_master_config(hostname, port=6380, use_tls=True))
            for hostname in [
                's1.redis-yateam-test.passport.yandex.net',
                'v1.redis-yateam-test.passport.yandex.net',
            ]
        ),
        'production': frozendict(
            [(get_host_id_by_hostname(hostname), _group_with_master_config(hostname, port=6380, use_tls=True))
                for hostname in [
                    'v1.redis-yateam.passport.yandex.net',
                    's1.redis-yateam.passport.yandex.net',
                    'i1.redis-yateam.passport.yandex.net',
                    # Машины из ятим-RC.
                    's1.redis-yateam-rc.passport.yandex.net',
                    'v1.redis-yateam-rc.passport.yandex.net',
                    # Мытищи prestable
                    'm1.redis-yateam.passport.yandex.net',
                ]
            ]
        ),
    },
}

for env_name in ['other', 'intranet']:
    _REDIS_CONFIG[env_name]['rc'] = _REDIS_CONFIG[env_name]['production']

_REDIS_CONFIG['localhost'] = _REDIS_CONFIG['other']

REDIS_CONFIG = _REDIS_CONFIG[yenv.name][yenv.type]

# Число попыток запросов/коннектов к редису
REDIS_RETRY_MAX_COUNT = 2
# Таймаут перезапроса в редис
REDIS_RETRY_TIMEOUT = .1
