# -*- coding: utf-8 -*-
import yenv


# Время жизни ссылки для входа в аккаунт (неделя)
AUTH_BY_KEY_LINK_LIFETIME_SECONDS = 60 * 60 * 24 * 7

# Шаблоны ссылки для восстановления
_AUTH_BY_KEY_LINK_TEMPLATE_URLS = {
    'localhost': {
        'development': 'https://0.passportdev.yandex.%(tld)s/auth?key=%(key)s',
        'testing': 'https://passport-test.yandex.%(tld)s/auth?key=%(key)s',
        'rc': 'https://passport-rc.yandex.%(tld)s/auth?key=%(key)s',
        'production': 'https://passport.yandex.%(tld)s/auth?key=%(key)s',
    },
}

if yenv.name == 'localhost':
    AUTH_BY_KEY_LINK_TEMPLATE_URL = _AUTH_BY_KEY_LINK_TEMPLATE_URLS[yenv.name][yenv.type]
else:
    AUTH_BY_KEY_LINK_TEMPLATE_URL = ''

PLUS_PROMO_CODE_MAX_LENGTH = 50
