# -*- coding: utf-8 -*-
from datetime import timedelta

from passport.backend.api.settings.constants.restore import (
    RESTORE_REQUEST_SOURCE_FOR_AUTO_RESTORE,
    RESTORE_REQUEST_SOURCE_FOR_AUTO_RESTORE_WITH_METHODS,
    RESTORE_REQUEST_SOURCE_FOR_DIRECT_URL,
)
from passport.backend.api.settings.tlds import PASSPORT_TLDS
import yenv


# Доля аудитории для показа ссылки на анкету на автоматическом восстановлении
SHOW_SEMI_AUTO_FORM_ON_AUTO_RESTORE_DENOMINATOR = 1

# Доля аудитории, для которой применяется модель на анкете
RESTORE_SEMI_AUTO_LEARNING_DENOMINATORS = {
    RESTORE_REQUEST_SOURCE_FOR_DIRECT_URL: 1,
    RESTORE_REQUEST_SOURCE_FOR_AUTO_RESTORE: 1,
    RESTORE_REQUEST_SOURCE_FOR_AUTO_RESTORE_WITH_METHODS: 1,
}

# Период, в течение которого повторное автоматическое ДА для пользователя не допускается
RESTORE_SEMI_AUTO_POSITIVE_DECISION_RETRY_IMPOSSIBLE_INTERVAL = 7 * 24 * 60 * 60
if yenv.type in ('development', 'testing'):
    RESTORE_SEMI_AUTO_POSITIVE_DECISION_RETRY_IMPOSSIBLE_INTERVAL = 10 * 60

# Глубина проверки IP при восстановлении semi_auto в днях
RESTORE_SEMI_AUTO_IP_CHECK_DEPTH = 365

# Лимит числа авторизаций, получаемых из истории
RESTORE_SEMI_AUTO_AUTHS_HISTORY_LIMIT = 10000

# Максимальный размер фото с паспортом
RESTORE_SEMI_AUTO_MAX_PHOTO_FILE_BYTES = 5 * 1024 * 1024

# Фиксированный порог для вычисления факторов глубины в истории авторизаций
RESTORE_SEMI_AUTO_FIXED_THRESHOLD_FOR_AGGREGATED_FACTORS = timedelta(days=30).total_seconds()

# Путь до файла, наличие которого говорит о необходимости выключить логику автоматического решения
RESTORE_SEMI_AUTO_DISABLE_AUTO_DECISION_FILE = '/var/lib/yandex/passport-api/disable-semi-auto-form-auto-decision'

# Имя исполняемого файла tensornet
RESTORE_SEMI_AUTO_TENSORNET_BINARY = 'tsnet2'

# Путь до обученной модели tensornet
RESTORE_SEMI_AUTO_TENSORNET_MODEL = '/usr/lib/yandex/passport-semiautoform-model/model/'

RESTORE_SEMI_AUTO_TENSORNET_FDFILE = '/usr/lib/yandex/passport-semiautoform-model/semiautoform.fd'

# Путь до файла с используемым моделью списком факторов
RESTORE_SEMI_AUTO_FEATURES_FILE = '/usr/lib/yandex/passport-semiautoform-model/features.txt'

# Признаки включения автоматического отрицательного и положительного решения по обученной формуле
RESTORE_SEMI_AUTO_NEGATIVE_DECISION_ENABLED = True
RESTORE_SEMI_AUTO_POSITIVE_DECISION_ENABLED = True

# Пороги для принятия отрицательного и положительного решения по обученной формуле
RESTORE_SEMI_AUTO_DECISION_THRESHOLDS = {
    RESTORE_REQUEST_SOURCE_FOR_DIRECT_URL: (0.6, 0.9),
    RESTORE_REQUEST_SOURCE_FOR_AUTO_RESTORE: (0.6, 0.9),
    RESTORE_REQUEST_SOURCE_FOR_AUTO_RESTORE_WITH_METHODS: (0.8, 0.9),
}

# Максимально разрешенное количество ошибок проверки защищенного телефона на процесс.
SECURE_PHONE_CHECK_ERRORS_COUNT_LIMIT = 10

# Максимально разрешенное количество ошибок проверки email-адреса для восстановления на процесс.
EMAIL_CHECK_ERRORS_COUNT_LIMIT = 10

# Максимально разрешенное число отправок email-сообщений на процесс.
RESTORATION_EMAILS_COUNT_LIMIT = 20

# Время жизни ссылки на восстановление, автоматически сгенерированной при восстановлении по email-адресу
RESTORATION_AUTO_LINK_LIFETIME_SECONDS = 3600

# Время жизни ссылки на восстановление, сгенерированной при восстановлении через саппорт
RESTORATION_MANUAL_LINK_LIFETIME_SECONDS = timedelta(days=7).total_seconds()

# Количество неудачных проверок КО, после которого требуем капчу
ANSWER_CHECK_ERRORS_CAPTCHA_THRESHOLD = 3

# Допустимая ошибка при сравнении КВ/КО - значение более строгое, чем по умолчанию
RESTORE_ANSWER_COMPARE_ALLOWED_DISTANCE_THRESHOLD = 0.9

# Количество неудачных проверок короткой анкеты для 2ФА, после которого требуем капчу
RESTORE_2FA_FORM_CHECK_ERRORS_CAPTCHA_THRESHOLD = 5

# Почтовые адреса для отправки писем в ОТРС
_RESTORE_TESTING_OTRS_ADDRESSES = {tld: 'support-test@yandex-team.ru' for tld in PASSPORT_TLDS}

_RESTORE_PRODUCTION_OTRS_ADDRESSES = {tld: 'spprstr@support.yandex.ru' for tld in PASSPORT_TLDS}
_RESTORE_PRODUCTION_OTRS_ADDRESSES.update({
    'ua': 'pwdrestore@support.yandex.ua',
    'com': 'pwdrestore@support.yandex.com',
    'co.il': 'pwdrestore@support.yandex.com',
    'fr': 'pwdrestore@support.yandex.com',
    'com.tr': 'recovery@passport.yandex.com.tr',
})

_RESTORE_OTRS_ADDRESSES = {
    'other': {
        'development': _RESTORE_TESTING_OTRS_ADDRESSES,
        'testing': _RESTORE_TESTING_OTRS_ADDRESSES,
        'rc': _RESTORE_PRODUCTION_OTRS_ADDRESSES,
        'production': _RESTORE_PRODUCTION_OTRS_ADDRESSES,
    },
}

_RESTORE_OTRS_ADDRESSES['localhost'] = _RESTORE_OTRS_ADDRESSES['other']

# Ссылка на Восстановлятор в теле письма в ОТРС
_RESTORE_ADM_FORM_DATA_URLS = {
    'other': {
        'development': 'http://adm-dev.yandex-team.ru/form/%(restore_id)s',
        'testing': 'https://adm-test.yandex-team.ru/form/%(restore_id)s',
        'rc': 'https://adm.yandex-team.ru/form/%(restore_id)s',
        'production': 'https://adm.yandex-team.ru/form/%(restore_id)s',
    },
}

_RESTORE_ADM_FORM_DATA_URLS['localhost'] = _RESTORE_ADM_FORM_DATA_URLS['other']


if yenv.name == 'localhost':
    RESTORE_OTRS_ADDRESSES = _RESTORE_OTRS_ADDRESSES[yenv.name][yenv.type]
    RESTORE_NOT_PASSED_ADDRESS = 'supprstr@support.yandex.ru'
    RESTORE_ADM_FORM_DATA_URL = _RESTORE_ADM_FORM_DATA_URLS[yenv.name][yenv.type]
else:
    RESTORE_OTRS_ADDRESSES = RESTORE_NOT_PASSED_ADDRESS = ''
    RESTORE_ADM_FORM_DATA_URL = ''


# Перенаправление лайтов с рестора на принудительную дорегистрацию
RESTORE_TO_FORCED_LITE_COMPLETION_ENABLED = False
