# -*- coding: utf-8 -*-
from copy import deepcopy

import yenv


SAML_SSO_ENABLED = yenv.name == 'localhost'
# требование имя/пароля при каждом заходе через IdP
SAML_SSO_FORCE_AUTHN = True

_DEBUG_ENABLED = yenv.type in ('development', 'testing')

_YANDEX_SP_CONFIG = {
    'sp': {
        'entityId': 'https://yandex.ru/',
        'assertionConsumerService': {
            'url': 'https://yandex.ru/?acs',  # не имеет смысла, мы на каждый запрос будем формировать урл ответа в зависимости от tld
            'binding': 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST',
        },
        'singleLogoutService': {
            'url': 'https://passport.yandex.com/auth/sso/logout/',
            'binding': 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect',
        },
        'NameIDFormat': 'urn:oasis:names:tc:SAML:2.0:nameid-format:persistent',
        # решили с безопасниками что пока без шифрования тела ответа будем делать
        'x509cert': '',
        'privateKey': '',
    },
}

_ADVANCED_CONFIG = {
    'strict': True,
    'debug': _DEBUG_ENABLED,

    'security': {
        'wantAttributeStatement': True,
        'wantNameId': True,
        'signatureAlgorithm': 'http://www.w3.org/2001/04/xmldsig-more#rsa-sha256',
    },
    'contactPerson': {
        'technical': {
            'givenName': 'technical_name',
            'emailAddress': 'technical@example.com',
        },
        'support': {
            'givenName': 'support_name',
            'emailAddress': 'support@example.com',
        },
    },
    'organization': {
        'en-US': {
            'name': 'Yandex',
            'displayname': 'Yandex',
            'url': 'https://yandex.ru',
        },
    },
}

_CONFIG = dict(_YANDEX_SP_CONFIG, **_ADVANCED_CONFIG)

# Шаблон url на ручку приема ответа ADFS фронта, будет передана в запросе в ADFS, необходимо поставить домен на который планируем получить куки после успешной авторизации
SAMLRESPONSE_RECEIVER_URL_PATH = 'auth/sso/commit'
SAMLREQUEST_LOGOUT_RECEIVER_URL_PATH = 'auth/sso/logout'
SAMLRESPONSE_RECEIVER_URL_TEMPLATE = 'https://%s/{}'.format(SAMLRESPONSE_RECEIVER_URL_PATH)


def get_yandex_sp_config():
    return deepcopy(_CONFIG)
