# -*- coding: utf-8 -*-
# isort:skip_file
import os
from imp import load_source


secret_settings = None


for config_file in (
    os.path.join(os.path.dirname(__file__), '../../../secret_settings.py'),
    '/usr/lib/yandex/passport-secrets/settings.py',
):
    try:
        secret_settings = load_source('secret_settings', config_file)
        break
    except IOError:
        pass

if not secret_settings:
    from passport.backend.api.settings.secrets import default as secret_settings

# логин-пароль для rw-доступа к БД
DB_USER = secret_settings.DB_USER
DB_PASSWORD = secret_settings.DB_PASSWORD

# логин-пароль для ro-доступа к БД
DB_SLAVE_USER = getattr(secret_settings, 'DB_SLAVE_USER', '')
DB_SLAVE_PASSWORD = getattr(secret_settings, 'DB_SLAVE_PASSWORD', '')

# пароль для доступа к Redis
REDIS_PASSWORD = secret_settings.REDIS_PASSWORD
REDIS_PASSWORD_2 = secret_settings.REDIS_PASSWORD_2

# соль для хэширования телефона по md5 перед отправкой в ФО
FRODO_SALT = secret_settings.FRODO_SALT

# client_id и client_secret используемых oauth-приложений
OAUTH_APP_TOKEN_TO_TRACK_CLIENT_ID = secret_settings.OAUTH_APP_TOKEN_TO_TRACK_CLIENT_ID
OAUTH_APP_TOKEN_TO_TRACK_CLIENT_SECRET = secret_settings.OAUTH_APP_TOKEN_TO_TRACK_CLIENT_SECRET

OAUTH_APP_NATIVE_SOCIAL_AUTH_CLIENT_ID = secret_settings.OAUTH_APP_NATIVE_SOCIAL_AUTH_CLIENT_ID
OAUTH_APP_NATIVE_SOCIAL_AUTH_CLIENT_SECRET = secret_settings.OAUTH_APP_NATIVE_SOCIAL_AUTH_CLIENT_SECRET

OAUTH_APP_MUSIC_MTS_REG_CLIENT_ID = secret_settings.OAUTH_APP_MUSIC_MTS_REG_CLIENT_ID
OAUTH_APP_MUSIC_MTS_REG_CLIENT_SECRET = secret_settings.OAUTH_APP_MUSIC_MTS_REG_CLIENT_SECRET

OAUTH_APP_MUSIC_VODAFONE_REG_CLIENT_ID = secret_settings.OAUTH_APP_MUSIC_VODAFONE_REG_CLIENT_ID
OAUTH_APP_MUSIC_VODAFONE_REG_CLIENT_SECRET = secret_settings.OAUTH_APP_MUSIC_VODAFONE_REG_CLIENT_SECRET

OAUTH_APP_MUSIC_MTS_BELARUS_REG_CLIENT_ID = secret_settings.OAUTH_APP_MUSIC_MTS_BELARUS_REG_CLIENT_ID
OAUTH_APP_MUSIC_MTS_BELARUS_REG_CLIENT_SECRET = secret_settings.OAUTH_APP_MUSIC_MTS_BELARUS_REG_CLIENT_SECRET

OAUTH_APP_MUSIC_GEOCELL_REG_CLIENT_ID = secret_settings.OAUTH_APP_MUSIC_GEOCELL_REG_CLIENT_ID
OAUTH_APP_MUSIC_GEOCELL_REG_CLIENT_SECRET = secret_settings.OAUTH_APP_MUSIC_GEOCELL_REG_CLIENT_SECRET

OAUTH_APP_AM_XTOKEN_CLIENT_ID = secret_settings.OAUTH_APP_AM_XTOKEN_CLIENT_ID
OAUTH_APP_AM_XTOKEN_CLIENT_SECRET = secret_settings.OAUTH_APP_AM_XTOKEN_CLIENT_SECRET

OAUTH_APP_UBER_CLIENT_ID = secret_settings.OAUTH_APP_UBER_CLIENT_ID
OAUTH_APP_UBER_CLIENT_SECRET = secret_settings.OAUTH_APP_UBER_CLIENT_SECRET

OAUTH_APP_YAMB_CLIENT_ID = secret_settings.OAUTH_APP_YAMB_CLIENT_ID
OAUTH_APP_YAMB_CLIENT_SECRET = secret_settings.OAUTH_APP_YAMB_CLIENT_SECRET

OAUTH_APP_KOLONKA_CLIENT_ID = secret_settings.OAUTH_APP_KOLONKA_CLIENT_ID
OAUTH_APP_KOLONKA_CLIENT_SECRET = secret_settings.OAUTH_APP_KOLONKA_CLIENT_SECRET

# Ключи для доступа к API Афиши
BILET_API_KEY = secret_settings.BILET_API_KEY
BILET_API_CLIENT_KEY = secret_settings.BILET_API_CLIENT_KEY

# Ключ для доступа к Content-API Маркета
MARKET_CONTENT_API_KEY = secret_settings.MARKET_CONTENT_API_KEY

# Клиентские сертификат и ключ для хождения в perimeter-api
PERIMETER_API_CLIENT_CERT = secret_settings.PERIMETER_API_CLIENT_CERT
PERIMETER_API_CLIENT_CERT_KEY = secret_settings.PERIMETER_API_CLIENT_CERT_KEY

# Ключ для доступа в Octopus
OCTOPUS_AUTH_TOKEN = secret_settings.OCTOPUS_AUTH_TOKEN

# Токен для доступа в Edadeal
EDADEAL_TOKEN = secret_settings.EDADEAL_TOKEN

# Токен для YDB
YDB_TOKEN = secret_settings.YDB_TOKEN

BILLING_TOKEN = secret_settings.BILLING_TOKEN

S3_SECRET_KEY_ID = secret_settings.S3_SECRET_KEY_ID
S3_SECRET_KEY = secret_settings.S3_SECRET_KEY

BOT_API_TOKEN = secret_settings.BOT_API_TOKEN

SIGNING_SECRETS = secret_settings.SIGNING_SECRETS

STAFF_TOKEN = secret_settings.STAFF_TOKEN

PASSPORT_ROBOT_LOGIN = secret_settings.PASSPORT_ROBOT_LOGIN
PASSPORT_ROBOT_PASSWORD = secret_settings.PASSPORT_ROBOT_PASSWORD
