# -*- coding: utf-8 -*-
from copy import copy
from datetime import timedelta
import os

from frozendict import frozendict
from passport.backend.api.settings.am_pushes import (
    AM_CAPABILITIES_BY_VERSION_ANDROID,
    AM_CAPABILITIES_BY_VERSION_IOS,
    AM_SUBSCRIPTION_APP_RULES,
    YAKEY_SUBSCRIPTION_APP_RULES,
)
from passport.backend.api.settings.antifraud import (
    ALLOW_ANTIFRAUD_ON_CHALLENGE_ON_TEST_YANDEX_LOGIN,
    ANTIFRAUD_API_RETRIES,
    ANTIFRAUD_API_TIMEOUT,
    ANTIFRAUD_API_URL,
    ANTIFRAUD_AUTH_SUB_CHANNEL,
    ANTIFRAUD_FALLBACK_CHALLENGES,
    ANTIFRAUD_FALLBACK_PHONE_CHALLENGES,
    ANTIFRAUD_ON_CHALLENGE_ENABLED,
    ANTIFRAUD_SHOW_CHALLENGE_ON_FAIL,
    FAMILY_INVITES_VIA_EMAIL_CHECK_ANTIFRAUD_SCORE,
    PHONE_CONFIRM_CHECK_ANTIFRAUD_SCORE,
    PHONE_CONFIRM_CHECK_IP_BLACKLIST,
    PHONE_CONFIRM_MASK_ANTIFRAUD_DENIAL,
    PHONE_CONFIRM_SHOW_ANTIFRAUD_CAPTCHA_FOR_CONSUMERS,
)
from passport.backend.api.settings.avatars_mds_api import (
    AVATAR_DEFAULT_SIZE,
    AVATAR_SECRET_SIGN_SPACE,
    AVATAR_SECRET_TTL,
    AVATARS_READ_URL,
    AVATARS_RETRIES,
    AVATARS_TIMEOUT,
    AVATARS_WRITE_URL,
    AVATARS_YAPIC_NAMESPACE,
    CHECK_AVATARS_SECRETS_DENOMINATOR,
    DEFAULT_AVATAR_KEY,
    GET_AVATAR_URL,
    GET_AVATAR_URL_SCHEMALESS,
    GET_AVATAR_WITH_SECRET_URL,
    ISSUE_AVATARS_SECRETS,
)
from passport.backend.api.settings.blacklisted_as.blacklisted_as import BLACKLISTED_AS_LIST
from passport.backend.api.settings.bot_api import (
    BOT_API_RETRIES,
    BOT_API_TIMEOUT,
    BOT_API_TOKEN,
    BOT_API_URL,
)
from passport.backend.api.settings.constants.common import (
    DATA_STATUS_NOT_USED,
    DATA_STATUS_OPTIONAL,
    DATA_STATUS_REQUIRED,
    DATA_TYPE_NAME,
    DATA_TYPE_PASSWORD,
    DATA_TYPE_PHONE_NUMBER,
    DEFAULT_COUNTRY,
    DEFAULT_LANGUAGE,
    DELETED_TRACK_TYPES,
    KIDDISH_LOGIN_GENERATION_RETRIES,
    KOLONKISH_LOGIN_GENERATION_RETRIES,
    PERMANENT_COOKIE_TTL,
    PHONISH_LOGIN_GENERATION_RETRIES,
    RECENT_ACCOUNT_USAGE_PERIOD,
    RETPATH_BAD_SYMBOLS,
    SESSIONAL_COOKIE_TTL,
    SHORT_COOKIE_TTL,
    TIMESTAMP_DELTA_ONE_DAY,
    YAMBOT_LOGIN_GENERATION_RETRIES,
)
from passport.backend.api.settings.constants.restore import (
    RESTORE_REQUEST_SOURCE_FOR_AUTO_RESTORE,
    RESTORE_REQUEST_SOURCE_FOR_AUTO_RESTORE_WITH_METHODS,
    RESTORE_REQUEST_SOURCE_FOR_CHANGE_HINT,
    RESTORE_REQUEST_SOURCE_FOR_DIRECT_URL,
)
from passport.backend.api.settings.foreign_domains import FOREIGN_DOMAINS_WITH_PASSPORT
from passport.backend.api.settings.lite import (
    ALLOW_LITE_REGISTRATION,
    DONT_PROMOTE_LITE_REGISTRATION_IN_WEB_FOR_ORIGINS,
    LITE_ACCOUNTS_ENFORCED_COMPLETION_DENOMINATOR,
    LITE_LOGIN_BLACKLISTED_DOMAINS,
    LITE_LOGIN_MAX_DOMAIN_LEVEL,
    MOBILE_LITE_DATA_STATUS_BY_APP_ID_PREFIX,
    MOBILE_LITE_DATA_STATUS_DEFAULT,
)
import yenv

from . import translations
from .account_deletion import (
    ACCOUNT_DELETER_PATH,
    ACCOUNT_DELETION_QUARANTINE_PERIOD,
    ACCOUNT_DELETION_RESTORE_POSSIBLE_PERIOD,
    ACCOUNT_FRESH_PERIOD,
    EMAIL_SUITABLE_FOR_ACCOUNT_DELETION_SINCE_TIME,
    LOGIN_QUARANTINE_PERIOD,
    PHONE_SUITABLE_FOR_ACCOUNT_DELETION_SINCE_TIME,
)
from .afisha_api import (
    AFISHA_API_RETRIES,
    AFISHA_API_TIMEOUT,
    AFISHA_API_URL,
    AFISHA_FRONT_URL,
)
from .allowed_hosts import (
    ADDITIONAL_ALLOWED_RETPATH_SCHEMES,
    ALLOWED_HOSTS,
    ALLOWED_PDD_HOSTS,
    ALLOWED_PDD_TLDS,
    ALLOWED_RETPATH_SCHEME_PREFIXES,
    DEFAULT_PDD_RETPATH_WITHOUT_TLD,
    HOSTS_BLACKLIST,
    HOSTS_WITH_PATHS_BLACKLIST,
    PDD_DOMAIN_RETPATH_WRAPPER_MAP,
)
from .alt_domains import (
    ALT_DOMAINS,
    ALT_DOMAINS_AVAILABLE_AT_REGISTRATION,
)
from .app_ids import TAXI_SUFFIX_LIST
from .auth_methods import (
    AUTH_METHOD_FROM_ID,
    AUTH_METHOD_MAGIC,
    AUTH_METHOD_MAGIC_LINK,
    AUTH_METHOD_MAGIC_X_TOKEN,
    AUTH_METHOD_OTP,
    AUTH_METHOD_PASSWORD,
    AUTH_METHOD_SAML_SSO,
    AUTH_METHOD_SMS_CODE,
    AUTH_METHOD_SOCIAL_PREFIX,
    AUTH_METHOD_SOCIAL_TEMPLATE,
    AUTH_METHOD_TO_ID,
    AUTH_METHOD_UNKNOWN,
)
from .bbro_api import (
    BBRO_API_RETRIES,
    BBRO_API_TIMEOUT,
    BBRO_API_URL,
)
from .bilet_api import (
    BILET_API_CLIENT_KEY,
    BILET_API_KEY,
    BILET_API_RETRIES,
    BILET_API_TIMEOUT,
    BILET_API_URL,
)
from .billing import (
    BILLING_TOKEN,
    BILLING_XMLRPC_RETRIES,
    BILLING_XMLRPC_TIMEOUT,
    BILLING_XMLRPC_URL,
    TRUST_3DS_CHALLENGE_PRODUCT_ID,
    TRUST_3DS_CHALLENGE_PRODUCT_PRICE,
    TRUST_BINDINGS_PUBLIC_KEY,
    TRUST_BINDINGS_RETRIES,
    TRUST_BINDINGS_TIMEOUT,
    TRUST_BINDINGS_URL,
    TRUST_PAYMENTS_RETRIES,
    TRUST_PAYMENTS_TIMEOUT,
    TRUST_PAYMENTS_URL,
    VALIDATE_CARD_ID_BEFORE_CREATING_CHAAS_TRACK,
)
from .blackbox import (
    BLACKBOX_ATTRIBUTES,
    BLACKBOX_AVAILABILITY_TEST_RETRIES,
    BLACKBOX_AVAILABILITY_TEST_UID,
    BLACKBOX_BASIC_ATTRIBUTES,
    BLACKBOX_BASIC_FIELDS,
    BLACKBOX_DANGEROUS_ATTRIBUTES,
    BLACKBOX_FIELDS,
    BLACKBOX_MAX_UIDS_PER_REQUEST,
    BLACKBOX_PHONE_EXTENDED_ATTRIBUTES,
    BLACKBOX_RETRIES,
    BLACKBOX_SESSION_VERSION,
    BLACKBOX_TIMEOUT,
    BLACKBOX_URL,
    TICKET_PARSER2_BLACKBOX_ENV,
)
from .captcha import (
    CAPTCHA_CHECKS,
    CAPTCHA_COUNTRY_MATCHING,
    CAPTCHA_LANGUAGE_MATCHING,
    CAPTCHA_RETRIES,
    CAPTCHA_SCALE_MATCHING,
    CAPTCHA_TIMEOUT,
    CAPTCHA_URL,
    CAPTCHA_VOICE_COUNTRY_MATCHING,
    CAPTCHA_VOICE_LANGUAGE_MATCHING,
    DISABLED_FOR_BLACK_AS_CAPTCHA_TRACK_TYPES,
    WAVE_CAPTCHA_COUNTRY_MATCHING,
    WAVE_CAPTCHA_LANGUAGE_MATCHING,
)
from .clean_web_api import (
    CLEAN_WEB_API_ENABLED,
    CLEAN_WEB_API_RETRIES,
    CLEAN_WEB_API_TIMEOUT,
    CLEAN_WEB_API_URL,
)
from .collections_api import (
    COLLECTIONS_API_RETRIES,
    COLLECTIONS_API_TIMEOUT,
    COLLECTIONS_API_URL,
)
from .cookies import (
    COOKIE_I_MAX_AGE,
    COOKIE_ILAHU_MAX_AGE,
    COOKIE_LAH_MAX_SIZE,
    COOKIE_SESSIONID_NOAUTH_MAX_AGE,
    COOKIE_YANDEX_LOGIN_MAX_AGE,
    COOKIE_YANDEXUID_MAX_AGE,
    COOKIE_YP_2FA_AGE,
    COOKIE_YP_2FA_FIELD,
    COOKIE_YP_2FA_IS_SET,
    COOKIE_YP_DISPLAY_NAME_AGE,
    COOKIE_YP_MULTIBROWSER_AGE,
    COOKIE_YP_MULTIBROWSER_FIELD,
    COOKIE_YP_MULTIBROWSER_IS_SET,
    COOKIE_YP_SP_AGE,
    COOKIE_YP_SP_FIELD,
    COOKIE_YP_SP_FIELD_FAMILY_SUBFIELD_VALUE,
    COOKIE_YS_COOKIE_CHECK_FIELD,
    COOKIE_YX_DISPLAY_NAME_FIELD,
    COOKIE_YX_DISPLAY_NAME_LENGTH,
)
from .counters import (
    COUNTERS,
    COUNTERS_REDIS_MANAGERS,
    RESTORE_PER_IP_COUNTER_LIMIT_FOR_SUPPORT_LINK,
)
from .counters.account_modification import (
    ACCOUNT_MODIFICATION_KOLMOGOR_KEY_SPACE,
    ACCOUNT_MODIFICATION_PER_UID_COUNTER_TEMPLATE,
)
from .counters.antifraud import (
    KOLMOGOR_ANTIFRAUD_CALL_FAIL_COUNTERS_1H,
    KOLMOGOR_ANTIFRAUD_CALL_FAIL_COUNTERS_10MIN,
    KOLMOGOR_ANTIFRAUD_CALL_FAIL_COUNTERS_24H,
    KOLMOGOR_KEYSPACE_ANTIFRAUD_FAIL_CALLS_COUNTER_1H,
    KOLMOGOR_KEYSPACE_ANTIFRAUD_FAIL_CALLS_COUNTER_10MIN,
    KOLMOGOR_KEYSPACE_ANTIFRAUD_FAIL_CALLS_COUNTER_24H,
)
from .counters.auth_challenge_per_ip import AUTH_CHALLENGE_PER_IP_LIMIT_COUNTER
from .counters.auth_email import (
    AUTH_EMAIL_RECENTLY_SENT_COUNTER,
    EMAIL_CHECK_OWNERSHIP_SENT_COUNTER_1H,
    EMAIL_CHECK_OWNERSHIP_SENT_COUNTER_24H,
    KOLMOGOR_KEY_SPACE_EMAIL_CHECK_OWNERSHIP_SENT_COUNTER_1H,
    KOLMOGOR_KEY_SPACE_EMAIL_CHECK_OWNERSHIP_SENT_COUNTER_24H,
)
from .counters.auth_magic_link import (
    AUTH_MAGIC_LINK_EMAIL_SENT_PER_IP_COUNTER,
    AUTH_MAGIC_LINK_EMAIL_SENT_PER_UID_COUNTER,
    AUTH_MAGIC_LINK_EMAIL_SENT_PER_UNTRUSTED_IP_COUNTER,
)
from .counters.auth_push import (
    AUTH_PUSH_COUNTER,
    AUTH_PUSH_KOLMOGOR_KEY_SPACE,
    PUSH_2FA_COUNTER,
    PUSH_2FA_KOLMOGOR_KEY_SPACE,
)
from .counters.bad_rfc_otp import BAD_RFC_OTP_COUNTER
from .counters.calls_per_ip import (
    PHONE_CONFIRMATION_CALLS_PER_IP_LIMIT_COUNTER,
    UNTRUSTED_PHONE_CONFIRMATION_CALLS_PER_IP_LIMIT_COUNTER,
)
from .counters.calls_per_phone import CALLS_PER_PHONE_LIMIT_COUNTER
from .counters.change_password import (
    CHANGE_PASSWORD_PER_PHONE_NUMBER_LIMIT_COUNTER,
    CHANGE_PASSWORD_PER_USER_IP_LIMIT_COUNTER,
)
from .counters.check_answer import (
    CHECK_ANSWER_PER_IP_AND_UID_LIMIT_COUNTER,
    CHECK_ANSWER_PER_IP_LIMIT_COUNTER,
    CHECK_ANSWER_PER_UID_LIMIT_COUNTER,
)
from .counters.common import (
    KOLMOGOR_KEY_SPACE_1H,
    KOLMOGOR_KEY_SPACE_10MIN,
    KOLMOGOR_KEY_SPACE_24H,
)
from .counters.drive import (
    DEVICE_PUBLIC_KEY_KOLMOGOR_KEY_SPACE,
    DEVICE_PUBLIC_KEY_SHORT_KOLMOGOR_KEY_SPACE,
    DRIVE_CREATE_DEVICE_PUBLIC_KEY_RPD_COUNTER,
    DRIVE_CREATE_DEVICE_PUBLIC_KEY_RPS_COUNTER,
)
from .counters.email_validator import (
    VALIDATOR_EMAIL_SENT_PER_UID_AND_ADDRESS_COUNTER,
    VALIDATOR_EMAIL_SENT_PER_UID_COUNTER,
)
from .counters.family import (
    FAMILY_INVITE_ISSUE_PER_FAMILY_COUNTER,
    FAMILY_INVITE_ISSUE_PER_UID_COUNTER,
    FAMILY_INVITE_KOLMOGOR_KEY_SPACE,
)
from .counters.migrate_mailish import MIGRATE_MAILISH_PER_CONSUMER_COUNTER
from .counters.passman_recovery_key import PASSMAN_RECOVERY_KEY_ADD_COUNTER
from .counters.profile_fails import PROFILE_FAILS_COUNTER
from .counters.question_change_email_notification import QUESTION_CHANGE_EMAIL_NOTIFICATION_COUNTER
from .counters.register_mailish import REGISTER_MAILISH_PER_CONSUMER_COUNTER
from .counters.register_phonish_by_phone import REGISTER_PHONISH_BY_PHONE_PER_CONSUMER_COUNTER
from .counters.registration_email import (
    REGISTRATION_EMAIL_PER_EMAIL_LIMIT_COUNTER,
    REGISTRATION_EMAIL_PER_IP_LIMIT_COUNTER,
    REGISTRATION_EMAIL_PER_UNTRUSTED_IP_LIMIT_COUNTER,
)
from .counters.registration_karma import (
    REGKARMA_BAD_COUNTER,
    REGKARMA_BAD_ENABLED,
    REGKARMA_GOOD_COUNTER,
    REGKARMA_GOOD_ENABLED,
)
from .counters.registration_kolonkish import (
    REGISTRATION_KOLONKISH_PER_CREATOR_UID_LONG_TERM,
    REGISTRATION_KOLONKISH_PER_CREATOR_UID_SHORT_TERM,
)
from .counters.registration_social import (
    SOCIAL_LOGIN_GENERATION_RETRIES,
    SOCIALREG_PER_IP_CAPTCHA_LIMIT_COUNTER,
    SOCIALREG_PER_PROVIDER_CAPTCHA_LIMIT_COUNTER,
)
from .counters.registration_uncompleted import (
    UNCOMPLETEDREG_CALLS_CAPTCHA_LIMIT_COUNTER,
    UNCOMPLETEDREG_PER_IP_CAPTCHA_LIMIT_COUNTER,
)
from .counters.restore import (
    LOGIN_RESTORE_PER_IP_LIMIT_COUNTER,
    LOGIN_RESTORE_PER_PHONE_LIMIT_COUNTER,
    RESTORE_PER_IP_LIMIT_COUNTER,
    RESTORE_SEMI_AUTO_COMPARE_PER_IP_LIMIT_COUNTER,
    RESTORE_SEMI_AUTO_COMPARE_PER_UID_LIMIT_COUNTER,
)
from .counters.sms_per_ip import (
    AUTH_FORWARDING_SMS_PER_IP_LIMIT_COUNTER,
    PHONE_CONFIRMATION_SMS_PER_IP_FOR_APP_COUNTER_FMT,
    PHONE_CONFIRMATION_SMS_PER_IP_FOR_CONSUMER_COUNTER_FMT,
    PHONE_CONFIRMATION_SMS_PER_IP_LIMIT_COUNTER,
    REGISTRATION_COMPLETED_WITH_SMS_PER_IP_LIMIT_COUNTER,
    REGISTRATION_SMS_SENT_PER_IP_LIMIT_COUNTER,
    TRUSTED_COUNTRIES,
    TRUSTED_YANGO_PHONE_CODES,
    UNTRUSTED_AUTH_FORWARDING_SMS_PER_IP_LIMIT_COUNTER,
    UNTRUSTED_PHONE_CONFIRMATION_SMS_PER_IP_LIMIT_COUNTER,
    UNTRUSTED_REGISTRATION_COMPLETED_WITH_SMS_PER_IP_LIMIT_COUNTER,
)
from .counters.sms_per_phone import (
    SMS_PER_PHONE_LIMIT_COUNTER,
    SMS_PER_PHONE_ON_REGISTRATION_LIMIT_COUNTER,
    SMS_PER_PHONISH_ON_REGISTRATION_LIMIT_COUNTER,
)
from .counters.userinfo import SHORT_USERINFO_COUNTER
from .counters.yakey_2fa_pictures import (
    YAKEY_2FA_PICTURES_DENY_FLAG_COUNTER,
    YAKEY_2FA_PICTURES_SHOWN_COUNTER,
    YAKEY_2FA_PICTURES_SHOWN_KEYSPACE,
)
from .counters.yapic import (
    YAPIC_DELETE_PER_IP_LIMIT_COUNTER,
    YAPIC_DELETE_PER_UID_LIMIT_COUNTER,
    YAPIC_UPLOAD_PER_IP_LIMIT_COUNTER,
    YAPIC_UPLOAD_PER_UID_LIMIT_COUNTER,
)
from .datasync_api import (
    DATASYNC_API_RETRIES,
    DATASYNC_API_TIMEOUT,
    DATASYNC_API_URL,
    DATASYNC_CACHE_RETRIES,
    DATASYNC_CACHE_TIMEOUT,
    DISK_PLUS_PARTNER_ID,
    DISK_PLUS_PRODUCT_ID,
)
from .db import (
    DB_CONFIG,
    ENV_IPV6_ONLY,
    PING_DB_NAMES,
    PREPARE_CONNECTION_ATTEMPTS,
)
from .domain_keyspaces import (
    DOMAIN_KEYSPACES,
    PASSPORT_SUBDOMAIN,
)
from .drive_api import (
    DRIVE_API_RETRIES,
    DRIVE_API_TIMEOUT,
    DRIVE_API_URL,
)
from .edadeal import (
    EDADEAL_RETRIES,
    EDADEAL_TIMEOUT,
    EDADEAL_TOKEN,
    EDADEAL_URL,
)
from .email_domain import (
    DEFAULT_EMAIL_DOMAIN,
    DEFAULT_EMAIL_DOMAINS,
    NATIVE_EMAIL_DOMAINS,
)
from .email_validator import (
    ALLOW_NONASCII_IN_EMAILS,
    CONFIRM_EMAIL_WITHOUT_CODE_ENABLED,
    EMAIL_VALIDATOR_CONFIRMATION_CODE_TTL,
    EMAIL_VALIDATOR_EMAIL_LANGUAGES,
    EMAIL_VALIDATOR_SENDER,
    EMAIL_VALIDATOR_SHORT_CODE_DELIMITER,
    EMAIL_VALIDATOR_SHORT_CODE_LENGTH,
)
from .env_profile import (
    ALLOW_PROFILE_CHECK_FOR_MOBILE,
    ALLOW_PROFILE_CHECK_FOR_WEB,
    AUTH_PROFILE_CHALLENGE_ENABLED,
    AUTH_PROFILE_ENABLED,
    MOBILE_PROFILE_DISTANCE_THRESHOLD,
    PROFILE_TRIAL_PERIOD,
    WEB_PROFILE_DISTANCE_THRESHOLD,
)
from .family import (
    FAMILY_DISABLE_SMS_INVITE,
    FAMILY_INVITE_URL_TEMPLATE,
    FAMILY_MAX_KIDS_NUMBER,
    FAMILY_MAX_SIZE,
)
from .federal_configs_api import (
    FEDERAL_CONFIGS_API_NAMESPACE,
    FEDERAL_CONFIGS_API_RETRIES,
    FEDERAL_CONFIGS_API_TIMEOUT,
    FEDERAL_CONFIGS_API_URL,
)
from .fio_suggest_api import FIO_SUGGEST_API_URL
from .forced_challenge import (
    FORCED_CHALLENGE_CHANCE,
    FORCED_CHALLENGE_PERIOD_LENGTH,
)
from .frodo import (
    FRODO_DUMMY_IP,
    FRODO_RETRIES,
    FRODO_SECRET_SALT,
    FRODO_TIMEOUT,
    FRODO_URL,
)
from .geosearch_api import (
    GEOSEARCH_API_RETRIES,
    GEOSEARCH_API_TIMEOUT,
    GEOSEARCH_API_URL,
)
from .hint_questions import (
    DONT_SHOW_HINT_IF_SECURE_NUMBER_AVAILABLE,
    HINT_QUESTION_IDS_FOR_LANGUAGES,
)
from .historydb_api import (
    ACCOUNT_EVENTS_DEFAULT_LIMIT,
    ACCOUNT_EVENTS_MAX_LIMIT,
    ACCOUNT_HISTORY_DEFAULT_LIMIT,
    ACCOUNT_HISTORY_MAX_LIMIT,
    HISTORYDB_API_RETRIES,
    HISTORYDB_API_RETRIES_FOR_TAKEOUT,
    HISTORYDB_API_TIMEOUT,
    HISTORYDB_API_TIMEOUT_FOR_RESTORE,
    HISTORYDB_API_TIMEOUT_FOR_TAKEOUT,
    HISTORYDB_API_URL,
    HISTORYDB_API_USE_TVM,
    LASTAUTH_DEFAULT_HOURS_LIMIT,
    LASTAUTH_DEFAULT_LIMIT,
)
from .hosts import HOSTS
from .kolmogor import (
    KOLMOGOR_RETRIES,
    KOLMOGOR_TIMEOUT,
    KOLMOGOR_URL,
)
from .language import (
    ALL_SUPPORTED_LANGUAGES,
    DETECT_LANGUAGES,
    DISPLAY_LANGUAGES,
    LANGUAGE_TO_TLD_MAPPING,
    MOBILE_FALLBACKS,
    MOBILE_RU_FALLBACK_LANGUAGES,
    PORTAL_LANGUAGES,
)
from .ldap import (
    LDAP_HOST,
    LDAP_NETWORK_TIMEOUT,
    LDAP_PORT,
    LDAP_SCHEME,
    LDAP_TIMEOUT,
    LDAP_USER_DOMAIN,
)
from .libraries import (
    GEOBASE_AS_NAME_FILE,
    GEOBASE_IPV4_ORIGIN_FILE,
    GEOBASE_IPV6_ORIGIN_FILE,
    GEOBASE_LOOKUP_FILE,
    IPREG_LOOKUP_FILE,
)
from .list_of_tlds import TOP_LEVEL_DOMAINS
from .logbroker import (
    LOGBROKER_TVM_CREDENTIALS_CONFIG,
    LOGBROKER_WRITERS,
)
from .logs import (
    APP_LOGGER_NAME,
    DEBUG,
    LOGGING,
)
from .mail_apis import (
    COLLIE_API_RETRIES,
    COLLIE_API_TIMEOUT,
    COLLIE_API_URL,
    FURITA_API_RETRIES,
    FURITA_API_TIMEOUT,
    FURITA_API_URL,
    HUSKY_API_RETRIES,
    HUSKY_API_TIMEOUT,
    HUSKY_API_URL,
    HUSKY_ENABLED,
    RPOP_API_RETRIES,
    RPOP_API_TIMEOUT,
    RPOP_API_URL,
    WMI_API_RETRIES,
    WMI_API_TIMEOUT,
    WMI_API_URL,
)
from .mail_static import (
    MAIL_NOISE_IMAGE_URL,
    MAIL_SHADOW_IMAGE_URL,
)
from .mail_subscriptions.subscription_services import SENDER_MAIL_SUBSCRIPTION_SERVICES
from .mailer import (
    COUNTRY_CODE_TO_MAIL_ADDRESSES_TLD,
    MAIL_ADDRESSES_DEFAULT_TLD,
    MAIL_DEFAULT_FROM_ADDRESS,
    MAIL_DEFAULT_REPLY_TO,
    MAIL_SENDMAIL_PATH,
)
from .mailish import (
    ALLOW_NATIVE_MAILISH_EMAILS,
    MAILISH_DOMAIN_TO_PROVIDER,
)
from .market import (
    MARKET_CONTENT_API_KEY,
    MARKET_CONTENT_API_RETRIES,
    MARKET_CONTENT_API_TIMEOUT,
    MARKET_CONTENT_API_URL,
)
from .mda2 import (
    BASE_MDA2_SLAVE_DOMAIN_CONFIG,
    CUSTOM_MDA_DOMAIN_CONFIGS,
    MDA2_SLAVE_DOMAINS,
    MDA_EXPERIMENTAL_COOKIE_DENOMINATOR,
)
from .messenger_api import (
    MESSENGER_FANOUT_API_ENABLED,
    MESSENGER_FANOUT_API_RETRIES,
    MESSENGER_FANOUT_API_TIMEOUT,
    MESSENGER_FANOUT_API_URL,
)
from .mobile_device_info import INVALID_DEVICE_IDS
from .music import (
    MUSIC_API_RETRIES,
    MUSIC_API_TIMEOUT,
    MUSIC_API_URL,
)
from .oauth import (
    AM_CODE_TTL,
    FAST_OAUTH_RETRIES,
    FAST_OAUTH_TIMEOUT,
    OAUTH_APPLICATION_AM_XTOKEN,
    OAUTH_APPLICATION_KOLONKA,
    OAUTH_APPLICATION_NATIVE_SOCIAL_AUTH,
    OAUTH_APPLICATION_TOKEN_TO_TRACK,
    OAUTH_APPLICATION_YAMB,
    OAUTH_APPLICATIONS_FOR_MUSIC,
    OAUTH_CONSUMER,
    OAUTH_KOLONKA_CODE_TTL,
    OAUTH_KOLONKA_KOLONKISH_SCOPE,
    OAUTH_RETRIES,
    OAUTH_TIMEOUT,
    OAUTH_TOKEN_TO_TRACK_SCOPE,
    OAUTH_URL,
)
from .octopus_api import (
    CALL_STATUS_IN_PROGRESS,
    CALL_STATUS_INTERRUPTED,
    CALL_STATUS_NO_ANSWER,
    CALL_STATUS_REJECTED,
    CALL_STATUS_SUCCESS,
    CALL_STATUS_UNAVAILABLE,
    FLASH_CALL_NUMBERS,
    KOLMOGOR_KEYSPACE_OCTOPUS_CALLS_COUNTERS,
    KOLMOGOR_KEYSPACE_OCTOPUS_CALLS_FLAG,
    OCTOPUS_AUTH_TOKEN,
    OCTOPUS_COUNTERS_MIN_COUNT,
    OCTOPUS_GATES_WORKING_THRESHOLD,
    OCTOPUS_RETRIES,
    OCTOPUS_SUPPORTED_LANGUAGES,
    OCTOPUS_TIMEOUT,
    OCTOPUS_URL,
    PASSPORT_CALLING_NUMBER,
    PHONE_CONFIRMATION_CALL_COUNTRIES,
    PHONE_CONFIRMATION_CALL_COUNTRIES_WITH_DENOMINATOR,
    PHONE_CONFIRMATION_CALL_ENABLED,
    PHONE_CONFIRMATION_CHECK_TIMEOUT,
    PHONE_CONFIRMATION_FLASH_CALL_COUNTRIES,
    PHONE_CONFIRMATION_FLASH_CALL_COUNTRIES_WITH_DENOMINATOR,
    PHONE_DIGITAL_PREFIXES_BLACKLIST,
    PHONE_VALIDATION_CODE_LENGTH,
    PHONE_VALIDATION_MAX_CALLS_CHECKS_COUNT,
    PHONE_VALIDATION_MAX_CALLS_COUNT,
    TELEPHONY_OK_STATUSES,
    TEST_VALID_PHONE_NUMBER_PREFIX,
)
from .password_blacklist import PASSWORD_BLACKLIST
from .password_hash import BLACKBOX_MD5_ARGON_HASH_DENOMINATOR
from .password_policy import (
    BASIC_PASSWORD_POLICY_MIDDLE_QUALITY,
    BASIC_PASSWORD_POLICY_MIN_LENGTH,
    BASIC_PASSWORD_POLICY_MIN_QUALITY,
    BASIC_PASSWORD_POLICY_PWDHISTORY_SEARCH_DEPTH,
    STRONG_PASSWORD_POLICY_MIDDLE_QUALITY,
    STRONG_PASSWORD_POLICY_MIN_LENGTH,
    STRONG_PASSWORD_POLICY_MIN_QUALITY,
    STRONG_PASSWORD_POLICY_PWDHISTORY_SEARCH_DEPTH,
)
from .pdd_domains import (
    DOMAINS_SERVED_BY_SUPPORT,
    DOMAINS_USED_BY_DIRECTORY,
    OPTIONS_USE_NEW_SERIALIZATION_SCHEME,
    RESTRICTED_DIRECTORY_SUBDOMAINS,
    USE_NEW_DIRECTORY_ACCOUNT_COMPLETION,
)
from .perimeter_api import (
    PERIMETER_API_CLIENT_CERT,
    PERIMETER_API_CLIENT_CERT_KEY,
    PERIMETER_API_RETRIES,
    PERIMETER_API_TIMEOUT,
    PERIMETER_API_URL,
)
from .phone_karma import (
    PHONE_KARMA_COUNTER_THRESHOLD,
    PHONE_KARMA_DRY_RUN,
    PHONE_KARMA_WHITELIST,
    PHONE_KARMA_WHITELIST_PREFIXES,
    USE_PHONE_KARMA,
)
from .phone_squatter import (
    PHONE_SQUATTER_DRY_RUN,
    PHONE_SQUATTER_RETRIES,
    PHONE_SQUATTER_TIMEOUT,
    PHONE_SQUATTER_URL,
    USE_PHONE_SQUATTER,
)
from .phone_whitelisted_consumers import PHONE_WHITELISTED_CONSUMERS
from .phonish import (
    APP_ID_TO_PHONISH_NAMESPACE,
    PHONISH_NAMESPACE_DEFAULT,
)
from .plus import DISK_PLUS_ENABLED
from .push_api import (
    PUSH_API_RETRIES,
    PUSH_API_SERVICE_NAME,
    PUSH_API_TIMEOUT,
    PUSH_API_URL,
    PUSH_APP_NAME_POSTFIX_ANDROID,
    PUSH_SECURITY_MESSAGE_KEY,
    PUSH_SECURITY_TITLE_KEY,
)
from .queue import (
    QUEUE_CONSUMER,
    QUEUE_ENCRYPTION_KEY_DIR,
    QUEUE_ENCRYPTION_KEY_EPOCH_LENGTH,
    QUEUE_RETRIES,
    QUEUE_TIMEOUT,
    QUEUE_URL,
)
from .redis import (
    REDIS_CONFIG,
    REDIS_RETRY_MAX_COUNT,
    REDIS_RETRY_TIMEOUT,
)
from .register import (
    AUTH_BY_KEY_LINK_LIFETIME_SECONDS,
    AUTH_BY_KEY_LINK_TEMPLATE_URL,
    PLUS_PROMO_CODE_MAX_LENGTH,
)
from .restore import (
    ANSWER_CHECK_ERRORS_CAPTCHA_THRESHOLD,
    EMAIL_CHECK_ERRORS_COUNT_LIMIT,
    RESTORATION_AUTO_LINK_LIFETIME_SECONDS,
    RESTORATION_EMAILS_COUNT_LIMIT,
    RESTORATION_MANUAL_LINK_LIFETIME_SECONDS,
    RESTORE_2FA_FORM_CHECK_ERRORS_CAPTCHA_THRESHOLD,
    RESTORE_ADM_FORM_DATA_URL,
    RESTORE_ANSWER_COMPARE_ALLOWED_DISTANCE_THRESHOLD,
    RESTORE_NOT_PASSED_ADDRESS,
    RESTORE_OTRS_ADDRESSES,
    RESTORE_SEMI_AUTO_AUTHS_HISTORY_LIMIT,
    RESTORE_SEMI_AUTO_DECISION_THRESHOLDS,
    RESTORE_SEMI_AUTO_DISABLE_AUTO_DECISION_FILE,
    RESTORE_SEMI_AUTO_FEATURES_FILE,
    RESTORE_SEMI_AUTO_FIXED_THRESHOLD_FOR_AGGREGATED_FACTORS,
    RESTORE_SEMI_AUTO_IP_CHECK_DEPTH,
    RESTORE_SEMI_AUTO_LEARNING_DENOMINATORS,
    RESTORE_SEMI_AUTO_MAX_PHOTO_FILE_BYTES,
    RESTORE_SEMI_AUTO_NEGATIVE_DECISION_ENABLED,
    RESTORE_SEMI_AUTO_POSITIVE_DECISION_ENABLED,
    RESTORE_SEMI_AUTO_POSITIVE_DECISION_RETRY_IMPOSSIBLE_INTERVAL,
    RESTORE_SEMI_AUTO_TENSORNET_BINARY,
    RESTORE_SEMI_AUTO_TENSORNET_FDFILE,
    RESTORE_SEMI_AUTO_TENSORNET_MODEL,
    RESTORE_TO_FORCED_LITE_COMPLETION_ENABLED,
    SECURE_PHONE_CHECK_ERRORS_COUNT_LIMIT,
    SHOW_SEMI_AUTO_FORM_ON_AUTO_RESTORE_DENOMINATOR,
)
from .rfc_otp import RFC_OTP_ISSUER
from .s3 import (
    S3_CONNECT_TIMEOUT,
    S3_ENDPOINT,
    S3_PRESIGNED_URL_TTL,
    S3_READ_TIMEOUT,
    S3_RETRIES,
    S3_SECRET_KEY,
    S3_SECRET_KEY_ID,
    S3_TAKEOUT_BUCKET_NAME,
)
from .saml_sso import (
    get_yandex_sp_config,
    SAML_SSO_ENABLED,
    SAML_SSO_FORCE_AUTHN,
    SAMLREQUEST_LOGOUT_RECEIVER_URL_PATH,
    SAMLRESPONSE_RECEIVER_URL_PATH,
    SAMLRESPONSE_RECEIVER_URL_TEMPLATE,
)
from .secrets import (
    OAUTH_APP_UBER_CLIENT_ID,
    OAUTH_APP_UBER_CLIENT_SECRET,
    PASSPORT_ROBOT_LOGIN,
    PASSPORT_ROBOT_PASSWORD,
)
from .sender_api import (
    SENDER_API_RETRIES,
    SENDER_API_TIMEOUT,
    SENDER_API_UNSUBSCRIBE_EXT_ACCOUNT,
    SENDER_API_URL,
)
from .shakur import (
    CHECK_SHAKUR_DURING_PASSWORD_VALIDATION,
    IS_SHAKUR_CHECK_DISABLED,
    PASSWORD_PWN_CHECK_SUSPENSION_DAYS,
    PWNED_PASSWORD_CHANGE_DENOMINATOR,
    SHAKUR_LIMIT,
    SHAKUR_RETRIES,
    SHAKUR_TIMEOUT,
    SHAKUR_URL,
    SHAKUR_USE_TVM,
    SHAKUR_WHITELIST_LOGIN_MASKS,
)
from .sharding import (
    DB_SHARDING_CONFIG,
    DB_SHARDING_RANGES,
)
from .signing import (
    SIGNING_REGISTRY,
    SIGNING_REGISTRY_FORESIGHT,
    SIGNING_REGISTRY_FORESIGHT_CACHE_TTL,
    SIGNING_REGISTRY_KEY_TTL,
    YANDEX_AND_YANDEX_TEAM_SIGNING_REGISTRY_PATH,
)
from .sms_retriever import (
    ANDROID_PACKAGE_PREFIX_TO_KEY,
    ANDROID_PACKAGE_PREFIXES_WHITELIST,
    ANDROID_PACKAGE_PUBLIC_KEY_DEFAULT,
)
from .social import (
    ALLOWED_SOCIAL_RETPATH_SCHEME_PREFIXES,
    ALLOWED_SOCIAL_RETPATH_SCHEMES,
    AUTH_ALLOWED_PROVIDER_TO_ID,
    AUTH_ALLOWED_PROVIDERS,
    CHALLENGE_ON_SOCIAL_AUTH_ENABLED,
    REGISTER_BY_TASK_PROVIDERS,
    REGISTER_BY_TOKEN_PROVIDERS,
    SOCIAL_API_CONSUMER,
    SOCIAL_API_RETRIES,
    SOCIAL_API_TIMEOUT,
    SOCIAL_API_URL,
    SOCIAL_AUTH_PROVIDERS,
    SOCIAL_BROKER_RETRIES,
    SOCIAL_BROKER_TIMEOUT,
    SOCIAL_BROKER_URL,
    SOCIAL_DEFAULT_SUBSCRIPTION,
    SOCIAL_PROVIDERS_TO_USE_EXTERNAL_USERAGENT,
    SOCIAL_SUGGEST_RELATED_ACCOUNT_CONSUMERS_RE_LIST,
    SOCIAL_SUGGEST_RELATED_ACCOUNT_ENABLED,
    SOCIAL_TRUSTED_SIMPLE_PHONE,
)
from .ssl import SSL_CA_CERT
from .staff import (
    STAFF_RETRIES,
    STAFF_TIMEOUT,
    STAFF_TOKEN,
    STAFF_URL,
)
from .suggest.login_suggester_conf import (
    AUTO_CHUNKS_INITIAL_WEIGHT,
    AUTO_CHUNKS_WEIGHT_STEP,
    CONSONANTS,
    EXCLUDE_LOGIN_REGEXP,
    EXCLUDE_NAME_REGEXP,
    FEMALE_GENDER,
    FEMALE_SEX_REGEXP,
    GENDER_TO_CHUNKS_REGEXP,
    INITIAL_WEIGHT,
    LANG_TO_FEMALE_NAMES_FILE,
    LANG_TO_FEMALE_SURNAME_REGEXP,
    LANG_TO_MALE_NAMES_FILE,
    LANG_TO_MALE_SURNAME_REGEXP,
    LANG_TO_MIXES,
    LANG_TO_TRANSLITERATIONS_FILE,
    LETTER_TO_NUMBER_COMBINATION_LIMIT,
    LETTER_TO_NUMBER_REPLACEMENTS,
    LETTER_TO_NUMBER_REPLACEMENTS_KEYS,
    LETTER_TO_NUMBER_TRANSLITERATION_LIMIT,
    LOGIN_ENDS_WITH_NUMBER_REGEXP,
    LOGIN_PREFIXES,
    LOGIN_SUGGEST_MAX_ITERATIONS,
    LOGIN_SUGGESTIONS_LIMIT,
    MALE_GENDER,
    MALE_SEX_REGEXP,
    MANUAL_CHUNKS_INITIAL_WEIGHT,
    MANUAL_CHUNKS_WEIGHT_STEP,
    MAX_COMBINATIONS,
    MAX_LOGIN_LENGTH,
    MAX_NAME_LENGTH,
    MAX_TRANSLITERATIONS,
    PREFIX_WEIGHT,
    RECENT_YEAR_REGEXP,
    REPLACEMENTS_FACTOR_STEP,
    REPLACEMENTS_INITIAL_FACTOR,
    SEPARATOR,
    SYNONYM_INITIAL_WEIGHT,
    UNDEFINED_GENDER,
    VOWELS,
)
from .support_code import (
    SUPPORT_CODE_API_ENABLED,
    SUPPORT_CODE_GENERATE_RETRIES,
    SUPPORT_CODE_LENGTH,
    SUPPORT_CODE_TTL,
)
from .takeout import (
    TAKEOUT_ARCHIVE_CONTENT_TYPE,
    TAKEOUT_ARCHIVE_TTL,
    TIME_FOR_ACCEPTING_EXTRACT,
    TIME_FOR_COMPLETING_EXTRACT,
)
from .tensornet import (
    TENSORNET_API_URL,
    TENSORNET_MODEL_CONFIGS,
)
from .tlds import (
    COMPLEX_TLDS,
    PASSPORT_DEFAULT_TLD,
    PASSPORT_TLDS,
    PORTAL_EXTRA_TLDS,
)
from .tv import (
    TV_AUTH_CLIENT_ID,
    TV_AUTH_CODE_STRENGTH,
)
from .ufo_api import (
    UFO_API_RETRIES,
    UFO_API_TIMEOUT,
    UFO_API_URL,
    UFO_API_USE_RC,
)
from .urls import (
    COMPLETION_URL_AM_TEMPLATE,
    COMPLETION_URL_TEMPLATE,
    DISK_JOURNAL_URL_TEMPLATE,
    FOREIGN_PASSPORT_BASE_URL_TEMPLATE,
    ID_BASE_URL_TEMPLATE,
    MAIL_JOURNAL_URL_TEMPLATE,
    PASSPORT_BASE_URL_TEMPLATE,
    PROFILE_ACCESS_URL_TEMPLATE,
    PROFILE_CHANGE_HINT_URL_TEMPLATE,
    PROFILE_EMAILS_URL_TEMPLATE,
    PROFILE_JOURNAL_URL_TEMPLATE,
    PROFILE_PHONES_URL_TEMPLATE,
    PROFILE_URL_TEMPLATE,
    PUSH_2FA_CODE_URL_TEMPLATE,
    PUSH_ACCOUNT_MODIFICATION_MAP_URL_TEMPLATE,
    PUSH_ACCOUNT_MODIFICATION_URL_TEMPLATE,
    RESTORE_BY_LINK_TEMPLATE_URL,
    RESTORE_DEFAULT_URL_TEMPLATE,
)
from .useragent import (
    BROWSER_DECODE,
    BROWSER_ENCODE,
    OS_DECODE,
    OS_DUMB_ENCODE,
    OS_ENCODE,
    OS_FAMILY_DECODE,
    OS_FAMILY_ENCODE,
)
from .video_api import (
    VIDEO_API_RETRIES,
    VIDEO_API_TIMEOUT,
    VIDEO_API_URL,
)
from .webauthn import (
    WEBAUTHN_AUTHENTICATOR_ATTACHMENT,
    WEBAUTHN_CHALLENGE_DEFAULT_BYTE_LEN,
    WEBAUTHN_CREDENTIALS_MAX_COUNT,
    WEBAUTHN_IS_NONE_ATTESTATION_PERMITTED,
    WEBAUTHN_IS_SELF_ATTESTATION_PERMITTED,
    WEBAUTHN_IS_TRUSTED_ATTESTATION_CERT_REQUIRED,
    WEBAUTHN_IS_USER_VERIFICATION_REQUIRED,
    WEBAUTHN_RELYING_PARTY_NAME,
)
from .yasms import (
    _TAXI_APP_IDS,
    APP_ID_SPECIFIC_ROUTE_DENOMINATOR,
    APP_ID_TO_SMS_ROUTE,
    CONSUMER_TO_SMS_ROUTE,
    FAKE_CODE,
    PERIOD_OF_PHONE_NUMBER_LOYALTY,
    PERIOD_OF_PHONE_NUMBER_LOYALTY_PRACTICAL,
    PHONE_QUARANTINE_SECONDS,
    SMS_LEGACY_VALIDATION_CODE_LENGTH,
    SMS_VALIDATION_CODE_LENGTH,
    TEST_PHONE_NUMBERS_ACCEPTING_FAKE_CODE,
    YANGO_APP_IDS,
    YASMS_CLEAN_PHONE_NUMBER_BINDINGS_LIMIT,
    YASMS_CONSUMERS_WITHOUT_OLD_PREFIX,
    YASMS_MARK_OPERATION_TTL,
    YASMS_PHONE_BINDING_LIMIT,
    YASMS_RETRIES,
    YASMS_SENDER,
    YASMS_TIMEOUT,
    YASMS_URL,
    YASMS_VALIDATION_LIMIT,
)
from .ydb import (
    TRY_USE_YDB,
    YDB_CONNECTION_TIMEOUT,
    YDB_DATABASE,
    YDB_DEADLINE,
    YDB_DRIVE_DATABASE,
    YDB_DRIVE_ENABLED,
    YDB_ENDPOINT,
    YDB_FAMILY_INVITE_DATABASE,
    YDB_FAMILY_INVITE_ENABLED,
    YDB_GET_SESSION_TIMEOUT,
    YDB_PERCENTAGE,
    YDB_PROFILE_ENABLED,
    YDB_PROFILE_TABLE,
    YDB_READ_LIMIT,
    YDB_RETRIES,
    YDB_SUPPORT_CODE_DATABASE,
    YDB_SUPPORT_CODE_ENABLED,
    YDB_TIMEOUT,
    YDB_TOKEN,
    YDB_TURBOAPP_PARTNERS_DATABASE,
    YDB_TURBOAPP_PARTNERS_ENABLED,
    YDB_USE_TVM,
)
from .ysa_mirror_api import (
    YSA_MIRROR_API_ENABLED,
    YSA_MIRROR_API_RETRIES,
    YSA_MIRROR_API_TIMEOUT,
)


# таймаут пингования лингво-апи
LINGVO_API_PING_TIMEOUT = 1  # в секундах

# максимальное количество пулов в UserAgent (выставляется по количеству хостов сторонних сервисов, в которые ходим)
USERAGENT_MAX_POOL_SIZE = 100

# использовать ли глобальный кэш ответов днс сервера
USE_GLOBAL_DNS_CACHE = True

# время кэширования DNS
DNS_CLEANING_INTERVAL = 300.0

# время между обновлениями списка грантов
GRANTS_CONFIG_CACHE_TIME = 60
PASSPORT_GRANTS_FILE_MASK = 'consumer_grants.{env_type}.json'
if yenv.type == 'development':
    # используем тестовые гранты в dev
    PASSPORT_GRANTS_FILE_MASK = 'consumer_grants.testing.json'
GRANTS_FILES = [
    {
        'grants_dir': '/usr/lib/yandex/passport-grants/',
        'mask': PASSPORT_GRANTS_FILE_MASK,
    },
    {
        'grants_dir': '/usr/lib/yandex/yasms-grants/',
        'mask': 'yasms_for_passport.{env_type}.json',
    },
]

TVM_KEYRING_CONFIG_NAME = 'passport_api'
TVM_CREDENTIALS_CACHE_TIME = 60

EXPERIMENTS_CONFIG_NAME = 'passport'
EXPERIMENTS_CONFIG_CACHE_TIME = 60
EXPERIMENTS_CONFIG_DIR = '/var/cache/yandex/passport-api-experiments/'

DB_DEFAULT_CONNECT_ARGS = {
    'mysql': frozendict({
        'connect_timeout': 1,
        'read_timeout': 2,
        'write_timeout': 2,
        'charset': 'utf8',
    }),
    'sqlite': frozendict(),
}

# число попыток выполнения запроса/коннекта
DB_RETRIES = 2

# время, которое ждём, чтобы приступить к следующей попытке
DB_RETRY_TIMEOUT = 1

# количество соединений с БД
DB_POOL_SIZE = 3

# максимальное время жизни соединения
DB_POOL_RECYCLE = 600

# максимальное количество одноразовых соединений при истощении пула
DB_POOL_MAX_OVERFLOW = 50

# находимся ли мы на YT
if yenv.name == 'intranet':
    IS_INTRANET = True

else:
    IS_INTRANET = False


ALLOW_REGISTRATION = not IS_INTRANET
ALLOW_MAGIC_LINK = not IS_INTRANET
ALLOW_AUTH_BY_SMS_FOR_WEB = True
ALLOW_AUTH_BY_SMS_FOR_MOBILE = True
MAX_LAH_AGE_TO_ALLOW_AUTH_BY_SMS = 90 * TIMESTAMP_DELTA_ONE_DAY
ALLOW_AUTH_BY_SMS_FOR_MOBILE_ONLY_FOR_TEST_LOGINS = False
AUTH_BY_SMS_FOR_MOBILE__ALLOW_SKIP_SIB_CHECKS_FOR_TEST_LOGINS = yenv.type in ('development', 'testing')
AUTH_BY_SMS__ALLOW_SKIP_SIB_CHECKS = False
FORBID_AUTH_BY_SMS_FOR_SMS_2FA = True

# Эту настройку нельзя включать в проде, пока антифрод не сделает и не выкатит на 100% отправку пушей об успешных входах
ALLOW_AUTH_AFTER_LOGIN_RESTORE_FOR_ALL = True

# Время жизни трека
TRACK_TTL = 3 * 60 * 60  # в секундах PASSP-5135
# ТТЛ, меньше которого считаем трек проэкспайренным
TRACK_TTL_OFFSET = 5  # в секундах

# Периоды (в секундах), в течение которых позволяем многократно получать креденшл (куку или токен) по одному и тому же
# треку. Нужно для ретраев при получении креденшла.
SESSION_REISSUE_INTERVAL = 30
TOKEN_REISSUE_INTERVAL = 60


# адрес фронтенд на nodejs
FRONTEND_HOST = 'http://127.0.0.1:3000'
FRONTEND_PING_TIMEOUT = 1  # в секундах

# Время кэширования LRandoms
LRANDOMS_CACHE_TIME = 7200
LRANDOMS_EXPIRE_OFFSET = 60


# Профилирование
PROFILE_ENABLED = False
PROFILE_STATS_PATH = '/tmp/passport_api.prof'


# Отключение логирования непройденных капч при авторизации
DISABLE_FAILED_CAPTCHA_LOGGING = False


# Запрещена ли смену пароля, если ФО ответила плохой кармой про пользователя
FORBIDDEN_CHANGE_PASSWORD_WITH_BAD_FRODO_KARMA = yenv.type in ('development', 'testing')

# Быстрое отключение смс-валидации на принудительной смене пароля.
# Если файл есть, то мы превращаем в тыкву принудительную смену пароля.
DISABLE_CHANGE_PASSWORD_PHONE_EXPERIMENT = IS_INTRANET
if os.path.exists('/var/lib/yandex/passport-api/disable-change-password-phone-experiment'):
    DISABLE_CHANGE_PASSWORD_PHONE_EXPERIMENT = True

# Включать, если возможно, sms_2fa после принудительной смены пароля
ENABLE_SMS_2FA_AFTER_CHANGE_PASSWORD = True


# Количество неудачных проверок ПИН, после которых функция блокируется.
ALLOWED_PIN_CHECK_FAILS_COUNT = 10

# Минимальная дистанция, при которой считаем ответ
# на КВ правильным при нечетком сравнении.
HINT_ANSWER_DISTANCE_THRESHOLD = 0.7


FILE_SYSTEM_ENCODING = 'utf-8'

CSRF_TOKEN_BYTES_COUNT = 16


FORCE_ISSUE_PORTAL_COOKIE_TO_LITE_USERS = True


# Максимальное время последнего ввода пароля,
# для которого мы не просим пользователя переввести пароль
# на модифицирующих операциях
PASSWORD_VERIFICATION_MAX_AGE = 30 * 60  # 30 минут


# минимальный интервал между отправками писем о показе челленжа
if yenv.type in ['development', 'testing']:
    SEND_AUTH_EMAILS_INTERVAL = 10 * 60
elif yenv.name == 'intranet':
    SEND_AUTH_EMAILS_INTERVAL = TIMESTAMP_DELTA_ONE_DAY
else:
    SEND_AUTH_EMAILS_INTERVAL = 7 * TIMESTAMP_DELTA_ONE_DAY

# Лимит счётчика неуспешных челленжей
AUTH_CHALLENGE_MAX_ATTEMPTS = 10
# Время протухания счётчика
AUTH_CHALLENGE_PERIOD = 3600 * 24

AUTH_MAGIC_LINK_CONFIRMS_LIMIT = 4
AUTH_MAGIC_LINK_POLL_INTERVAL = 1
AUTH_MAGIC_LINK_TTL = 600       # 10 минут
ALLOW_MAGIC_LINK_FOR_LITE = ALLOW_MAGIC_LINK

AUTH_MAGIC_LINK_TEMPLATE = ''
REGISTER_MAGIC_LINK_TEMPLATE = ''

if yenv.name == 'localhost':
    AUTH_MAGIC_LINK_TEMPLATE = 'https://%s.yandex.{tld}/auth/link/?{query_string}' % PASSPORT_SUBDOMAIN
    REGISTER_MAGIC_LINK_TEMPLATE = 'https://%s.yandex.{tld}/register/link/?{query_string}' % PASSPORT_SUBDOMAIN

# Флаг, показывающий необходимость записать окружение в auth_challenge.log
WRITE_YENV_TO_AUTH_CHALLENGE_LOG = yenv.type == 'rc'

CHECK_ANSWER_UNTIL_CAPTCHA_LIMIT_BY_UID = 3
CHECK_ANSWER_UNTIL_CAPTCHA_LIMIT_BY_IP = 10

YAKEY_BACKUP_EXPIRATION_PERIOD = 90 * 24 * 3600   # 3 месяца в секундах

# Настройки "картинок", используемых Ключом в качестве дополнительного фактора при входе по 2фа
YAKEY_2FA_PICTURES_TOTAL_COUNT = 20  # сколько всего возможных картинок
YAKEY_2FA_PICTURES_COUNT = 4  # сколько картинок показываем пользователю
YAKEY_2FA_PICTURES_TTL = 60  # время валидности очередной картинки (в секундах)

# Количество неудачных проверок короткого кода, после которых
# нужно посылать новое письмо для подтверждения email.
ALLOWED_EMAIL_SHORT_CODE_FAILED_CHECK_COUNT = 3

if yenv.type in ['development']:
    CHECK_ANSWER_UNTIL_CAPTCHA_LIMIT_BY_UID = 10
    CHECK_ANSWER_UNTIL_CAPTCHA_LIMIT_BY_IP = 1000
elif yenv.type in ['testing']:
    CHECK_ANSWER_UNTIL_CAPTCHA_LIMIT_BY_UID = 5
    CHECK_ANSWER_UNTIL_CAPTCHA_LIMIT_BY_IP = 7

# Флаг, включающий шифрование логов HistoryDB
HISTORYDB_LOG_ENCRYPTION_ENABLED = False
if yenv.type != 'development':
    HISTORYDB_LOG_ENCRYPTION_ENABLED = True


# Шаблоны для короткой ссылки, содержащей в себе трек
_SHORT_TRACK_LINK_TEMPLATES = {
    'localhost': {
        'development': 'https://0.passportdev.yandex.%(tld)s/a/%(track_id)s/',
        'testing': 'https://passport-test.yandex.%(tld)s/a/%(track_id)s/',
        'rc': 'https://passport-rc.yandex.%(tld)s/a/%(track_id)s/',
        'production': 'https://passport.yandex.%(tld)s/a/%(track_id)s/',
    },
}

if yenv.name == 'localhost':
    SHORT_TRACK_LINK_TEMPLATE = _SHORT_TRACK_LINK_TEMPLATES[yenv.name][yenv.type]
else:
    SHORT_TRACK_LINK_TEMPLATE = ''

AUTH_FORWARDING_SMS_IDENTITY = 'auth_forwarding_by_sms'

AUTH_FORWARDING_TRACK_TTL = 10 * 60

# Число отправленных с IP смс (при авторизации по смс), после которого для отправки требуется капча
AUTH_BY_SMS_CAPTCHA_THRESHOLD_PER_IP = 3
# Число отправленных смс на один номер (при авторизации по смс), после которого для отправки требуется капча
AUTH_BY_SMS_CAPTCHA_THRESHOLD_PER_PHONE = 2
# Флаг, включающий возможность авторизации по смс
AUTH_BY_SMS_ENABLED = True

AUTH_BY_SMS_YASMS_IDENTITY = 'auth_by_sms'


_RECOVERY_EMAIL_PRODUCTION = 'recovery_sms@passport.yandex.ru'
_RECOVERY_EMAIL_TESTING = 'support-test@yandex-team.ru'

_RECOVERY_EMAILS = {
    'development': _RECOVERY_EMAIL_TESTING,
    'testing': _RECOVERY_EMAIL_TESTING,
    'stress': _RECOVERY_EMAIL_TESTING,
    'rc': _RECOVERY_EMAIL_PRODUCTION,
    'production': _RECOVERY_EMAIL_PRODUCTION,
}

_TR_RECOVERY_EMAIL_PRODUCTION = 'pasaport@destek.yandex.com.tr'

_TR_RECOVERY_EMAILS = copy(_RECOVERY_EMAILS)
_TR_RECOVERY_EMAILS['production'] = _TR_RECOVERY_EMAILS['rc'] = _TR_RECOVERY_EMAIL_PRODUCTION

RECOVERY_EMAIL_BY_TLD = {
    'default': _RECOVERY_EMAILS[yenv.type],
    'com.tr': _TR_RECOVERY_EMAILS[yenv.type],
}

_RECOVERY_ADM_USERS_URLS = {
    'development': 'http://adm-test.yandex-team.ru/users/',
    'testing': 'https://adm-test.yandex-team.ru/users/',
    'stress': 'https://adm-test.yandex-team.ru/users/',
    'rc': 'https://adm.yandex-team.ru/users/',
    'production': 'https://adm.yandex-team.ru/users/',
}

RECOVERY_ADM_USERS_URL = _RECOVERY_ADM_USERS_URLS[yenv.type]

MAGIC_LINK_CODE_LENGTH = 3

# После логаута мы должны спрятать саджест аккаунтов на указанное время
# (соответствующий момент времени запишем в куку ilahu)
IGNORE_LAH_AFTER_LOGOUT_FOR = 8 * 3600

IS_TEST = DEBUG or yenv.type in ['testing']

ADDITIONAL_DATA_FREEZE_PERIOD_AFTER_DECLINE = {
    'short': timedelta(minutes=5),
    'long': timedelta(days=30),
}

ADDITIONAL_DATA_FREEZE_PERIOD_AFTER_COMPLETION = copy(ADDITIONAL_DATA_FREEZE_PERIOD_AFTER_DECLINE)

CLIENT_IDS_ALLOWED_TO_BIND_PHONE = set()
if yenv.name == 'localhost':
    if yenv.type in {'rc', 'production'}:  # pragma: no cover
        CLIENT_IDS_ALLOWED_TO_BIND_PHONE = {
            '6564430abb6d44ea8c042bc27e96f957',  # Дзен
            'e1af730960ff4d9ba7b1a646eed7ca0d',  # Навигатор
            'dbe5c1ce8c154f1c827c7365ef8dc51b',  # автотесты Паспорта
        }
    elif yenv.type in {'development', 'testing'}:
        CLIENT_IDS_ALLOWED_TO_BIND_PHONE = {
            '7d7f759014354afbb5799a8bb1026682',  # автотесты Паспорта
        }

DEVICE_ID_BLACKLIST = set()  # актуальный список будет приезжать из overridden_settings

PING_FILE = 'ping.html' if DEBUG else '/usr/lib/yandex/passport-front-web-data/data/ping.html'

# Максимальное число алиасов (alias_type=8) для ПДД-пользователя (PASSP-23528)
if yenv.type in ['development', 'testing']:
    MAX_PDD_ALIASES_COUNT = 20
else:
    MAX_PDD_ALIASES_COUNT = 1000


DEVICE_PUBLIC_KEY_OWNER_TO_OWNER_ID = dict(
    drive_production=1,
    drive_virtual=2,
)

DRIVE_PRODUCTION_PUBLIC_KEY_OWNER_ID = DEVICE_PUBLIC_KEY_OWNER_TO_OWNER_ID['drive_production']
DRIVE_VIRTUAL_PUBLIC_KEY_OWNER_ID = DEVICE_PUBLIC_KEY_OWNER_TO_OWNER_ID['drive_virtual']

DRIVE_DEVICE_PUBLIC_KEY_API_ENABLED = True

# Т.к. API проброса авторизации Драйва использует YDB, а запросы в YDB уже
# ломали Паспорт, вешая воркер, будет полезным иметь флажок, который
# выключает API.
DRIVE_AUTH_FORWARDING_API_ENABLED = True

# В секундах
DRIVE_AUTH_FORWARDING_NONCE_TTL = 10

DRIVE_NONCE_SIGN_SPACE = 'auto_head_unit'

UNKNOWN_DRIVE_SESSIONS_ALLOWED = yenv.type == 'testing'

# Разрешить запись sandbox_device_id в YDB
ALLOW_DRIVE_SANDBOX_IDS = True

AM_IOS_CHALLENGE_MIN_VERSION = '5.92'
AM_ANDROID_CHALLENGE_MIN_VERSION = '7.0.0'
AM_ANDROID_CHALLENGE_MIN_VERSION_FOR_LITE = '7.6.0'

# челлендж с смской включен для АМ
PHONE_CONFIRMATION_CHALLENGE_ENABLED_FOR_AM_DENOMINATOR = 1  # 100%
PHONE_CONFIRMATION_CHALLENGE_FOR_ALL_APPS = False  # PHONE_CONFIRMATION_CHALLENGE_APP_IDS игнорируется, если True
PHONE_CONFIRMATION_CHALLENGE_APP_IDS = {
    # такси
    'ru.yandex.taxi',
    'ru.yandex.taxi.beta',
    'ru.yandex.taxi.debug',
    'ru.yandex.taxi.develop',
    'ru.yandex.taxi.inhouse',
    'ru.yandex.ytaxi',
    # ПП
    'ru.yandex.searchplugin',
    'ru.yandex.searchplugin.beta',
    'ru.yandex.mobile',
    # семпл АМа
    'ru.yandex.auth.client.am_release_sl',
    'ru.yandex.mobile.auth.samplesl',
    'ru.yandex.mobile.auth.samplesl.debug',
}

CHALLENGE_ON_HAS_CARDS_APP_IDS = PHONE_CONFIRMATION_CHALLENGE_APP_IDS
PHONE_CONFIRMATION_CHALLENGE_ACTUALITY_THRESHOLD_DAYS = 90
CHALLENGE_ON_HAS_CARDS_FOR_ALL_APPS = False  # CHALLENGE_ON_HAS_CARDS_APP_IDS игнорируется, если True

# Доля пользователей, которым шлется письмо про вход
EMAIL_NOTIFICATIONS_DENOMINATOR = 1 if yenv.name == 'localhost' else 0

NOTIFY_TESTER_ONLY = yenv.type in {'development', 'testing'}

IS_BIND_TEST_PHONE_TO_NONTEST_ACCOUNT_ALLOWED = yenv.type == 'testing'

ALLOW_NEOPHONISH_REGISTRATION = ALLOW_REGISTRATION

IS_BIND_PHONISH_TO_CURRENT_ACCOUNT_ENABLED = yenv.name == 'localhost'


_MOBILEPROXY_INTERNAL_HOSTS = {
    'localhost': {
        'development': 'mobileproxy-test-internal.passport.yandex.net',
        'testing': 'mobileproxy-test-internal.passport.yandex.net',
        'rc': 'mobileproxy-rc-internal.passport.yandex.net',
        'production': 'mobileproxy-internal.passport.yandex.net',
    },
}
MOBILEPROXY_INTERNAL_HOST = _MOBILEPROXY_INTERNAL_HOSTS.get(yenv.name, {}).get(yenv.type)

MOBILEPROXY_CONSUMER = 'mobileproxy'


BIND_RELATED_PHONISH_ACCOUNT_APP_IDS = set(_TAXI_APP_IDS)
if yenv.type in {'testing'}:
    BIND_RELATED_PHONISH_ACCOUNT_APP_IDS.update(
        [
            'ru.yandex.auth.client',
            'ru.yandex.mobile.auth.sample',
        ],
    )


# Сколько челленжей грузить из истории для поиска нужного
CHALLENGE_HISTORY_LIMIT = 10  # больше 10 челленжей за пару секунд маловероятны
# Погрешность сравнения ts при поиске нужного челленжа
CHALLENGE_HISTORY_THRESHOLD = 0.001  # 1 миллисекунда
if yenv.type in {'development', 'testing'}:
    CHALLENGE_HISTORY_THRESHOLD = 5  # для удобства автотестов

KARMA_PREFIX_TO_WASH_BY_SUPPORT_LINK = (0, 1, 3, 4, 6, 7, 8)


# Модели должны быть в lowercase
MAGNITOLA_MODELS = (
    'mtrx_avn',
    'car infotainment',  # AUTUS
)
MAGNITOLA_APP_IDS = (
    'com.yandex.music.auto',
    'ru.yandex.radio',
    'ru.yandex.yandexnavi',
)

# 2fa пуши
PUSH_2FA_CHALLENGE_ENABLED = False
PUSH_2FA_CHALLENGE_ENABLED_DENOMINATOR = 1 if yenv.name == 'localhost' else 0
PUSH_2FA_CODE_LENGTH = 6

# Ограничение на количество email-ов в профиле пользователя
MAX_EMAILS_PER_PROFILE = 100

# Отсылать email о смене КВКО
SEND_EMAIL_AFTER_HINT_QUESTION_CHANGE = True

# Деноминатор для выключения смс2фа только на новых устройствах.
DISABLE_SMS_2FA_CHALLENGE_ONLY_ON_KNOWN_DEVICES_DENOMINATOR = 100    # 1%

# Разрешить регистрацию и вход неофонишей только по номеру телефона
USE_NEW_SUGGEST_BY_PHONE = yenv.type in {'development', 'testing', 'rc'}
# TODO: выпилить NEW_SUGGEST_BY_PHONE_DENOMINATOR: фронт не смотрит на поля, вычисляемые с его помощью
if yenv.type in {'development', 'testing'}:
    NEW_SUGGEST_BY_PHONE_DENOMINATOR = 1
else:
    NEW_SUGGEST_BY_PHONE_DENOMINATOR = 0

if yenv.type in {'development', 'testing'}:
    NEOPHONISH_COMPLETION_SUGGEST_INTERVAL = timedelta(days=1)
else:
    NEOPHONISH_COMPLETION_SUGGEST_INTERVAL = timedelta(days=30)

MAX_LASTAUTH_AGE_FOR_AUTH_SUGGEST = timedelta(days=180)


_ACCOUNT_MODIFICATION_COMMON_TARGETS = {
    'app_password_add',
    'card_add',
    'card_change',
    'card_delete',
    'changed_password',
    'collector_add',
    'email_change',
    'hint_change',
    'login',
    'login_method_change',
    'phone_change',
    'restore',
    'social_add',
    'social_allow',
}
_ACCOUNT_MODIFICATION_PUSH_ALL_TARGETS = _ACCOUNT_MODIFICATION_COMMON_TARGETS | {
    'email_change',
}
_ACCOUNT_MODIFICATION_MAIL_ALL_TARGETS = _ACCOUNT_MODIFICATION_COMMON_TARGETS | {
    'email_add',
    'email_delete',
}
if IS_INTRANET:
    ACCOUNT_MODIFICATION_MAIL_ENABLE = set()
    ACCOUNT_MODIFICATION_PUSH_ENABLE = set()
    ACCOUNT_MODIFICATION_NOTIFY_DENOMINATOR = 0
    ACCOUNT_MODIFICATION_NOTIFY_WHITELIST = set()
else:
    ACCOUNT_MODIFICATION_MAIL_ENABLE = _ACCOUNT_MODIFICATION_MAIL_ALL_TARGETS
    ACCOUNT_MODIFICATION_PUSH_ENABLE = _ACCOUNT_MODIFICATION_PUSH_ALL_TARGETS
    ACCOUNT_MODIFICATION_NOTIFY_WHITELIST = set()
    ACCOUNT_MODIFICATION_NOTIFY_DENOMINATOR = 1

# челлендж "email с кодом"
EMAIL_CODE_CHALLENGE_ENABLED = True
EMAIL_CODE_CHALLENGE_ENABLED_DENOMINATOR = 1
EMAIL_CODE_CHALLENGE_CODE_LENGTH = 5
EMAIL_CHECK_OWNERSHIP_CODE_ATTEMPTS = 5


IGNORE_POSSIBLE_PHONE_OWNER_CHANGE_FOR_UIDS = ()
if yenv.name == 'localhost':
    if yenv.type in ('development', 'testing'):
        IGNORE_POSSIBLE_PHONE_OWNER_CHANGE_FOR_UIDS = (
            4096156234,  # тестовый фониш
            4096167900,  # тестовый неофониш
        )
    elif yenv.type in ('rc', 'production'):
        IGNORE_POSSIBLE_PHONE_OWNER_CHANGE_FOR_UIDS = (
            1633902391,  # тестовый неофониш
            1633926004,  # тестовый фониш
        )
