# -*- coding: utf-8 -*-
import yenv


SHAKUR_URL = 'https://shakur-prod.pers.yandex.net'

SHAKUR_TIMEOUT = 0.3
SHAKUR_RETRIES = 1

SHAKUR_LIMIT = 500

PWNED_PASSWORD_CHANGE_DENOMINATOR = 1 if yenv.name == 'localhost' else 0
PASSWORD_PWN_CHECK_SUSPENSION_DAYS = 30

if yenv.name == 'localhost' and yenv.type in ('development', 'rc', 'production'):
    CHECK_SHAKUR_DURING_PASSWORD_VALIDATION = True
else:
    CHECK_SHAKUR_DURING_PASSWORD_VALIDATION = False

if yenv.name == 'localhost' and yenv.type == 'production':
    SHAKUR_USE_TVM = True
else:
    SHAKUR_USE_TVM = False

# PASSP-33918 в yandex-team окружении не ходим в шакур
IS_SHAKUR_CHECK_DISABLED = (yenv.name == 'intranet' or
                            yenv.name == 'localhost' and yenv.type == 'testing')

# Маски логинов, для которых не ходим в шакур
SHAKUR_WHITELIST_LOGIN_MASKS = ['yndx-miss-shakur']
