# -*- coding: utf-8 -*-
import yenv


_DB_SHARDING_CONFIG = {
    'other': {
        'testing': {
            'attributes': {
                1: 'passportdbshard1',
                2: 'passportdbshard2',
            },
            'email_bindings': {
                1: 'passportdbshard1',
                2: 'passportdbshard2',
            },
            'extended_attributes': {
                1: 'passportdbshard1',
                2: 'passportdbshard2',
            },
            'phone_bindings': {
                1: 'passportdbshard1',
                2: 'passportdbshard2',
            },
            'phone_bindings_history': {
                1: 'passportdbshard1',
                2: 'passportdbshard2',
            },
            'phone_operations': {
                1: 'passportdbshard1',
                2: 'passportdbshard2',
            },
            'password_history': {
                1: 'passportdbshard1',
                2: 'passportdbshard2',
            },
            'tracks': {
                1: 'passportdbshard1',
                2: 'passportdbshard2',
            },
            'account_deletion_operations': {
                1: 'passportdbshard1',
                2: 'passportdbshard2',
            },
            'passman_recovery_keys': {
                1: 'passportdbshard1',
                2: 'passportdbshard2',
            },
        },
        'production': {
            'attributes': {
                1: 'passportdbshard1',
                2: 'passportdbshard2',
                3: 'passportdbshard3',
                4: 'passportdbshard4',
            },
            'email_bindings': {
                1: 'passportdbshard1',
                2: 'passportdbshard2',
                3: 'passportdbshard3',
                4: 'passportdbshard4',
            },
            'extended_attributes': {
                1: 'passportdbshard1',
                2: 'passportdbshard2',
                3: 'passportdbshard3',
                4: 'passportdbshard4',
            },
            'phone_bindings': {
                1: 'passportdbshard1',
                2: 'passportdbshard2',
                3: 'passportdbshard3',
                4: 'passportdbshard4',
            },
            'phone_bindings_history': {
                1: 'passportdbshard1',
                2: 'passportdbshard2',
                3: 'passportdbshard3',
                4: 'passportdbshard4',
            },
            'phone_operations': {
                1: 'passportdbshard1',
                2: 'passportdbshard2',
                3: 'passportdbshard3',
                4: 'passportdbshard4',
            },
            'password_history': {
                1: 'passportdbshard1',
                2: 'passportdbshard2',
                3: 'passportdbshard3',
                4: 'passportdbshard4',
            },
            'tracks': {
                1: 'passportdbshard1',
                2: 'passportdbshard2',
                3: 'passportdbshard3',
                4: 'passportdbshard4',
            },
            'account_deletion_operations': {
                1: 'passportdbshard1',
                2: 'passportdbshard2',
                3: 'passportdbshard3',
                4: 'passportdbshard4',
            },
            'passman_recovery_keys': {
                1: 'passportdbshard1',
                2: 'passportdbshard2',
                3: 'passportdbshard3',
                4: 'passportdbshard4',
            },
        },
    },
    'stress': {
        'stress': {
            'attributes': {
                1: 'passportdbshard3',
                2: 'passportdbshard4',
            },
            'email_bindings': {
                1: 'passportdbshard3',
                2: 'passportdbshard4',
            },
            'extended_attributes': {
                1: 'passportdbshard3',
                2: 'passportdbshard4',
            },
            'phone_bindings': {
                1: 'passportdbshard3',
                2: 'passportdbshard4',
            },
            'phone_bindings_history': {
                1: 'passportdbshard3',
                2: 'passportdbshard4',
            },
            'phone_operations': {
                1: 'passportdbshard3',
                2: 'passportdbshard4',
            },
            'password_history': {
                1: 'passportdbshard3',
                2: 'passportdbshard4',
            },
            'tracks': {
                1: 'passportdbshard3',
                2: 'passportdbshard4',
            },
            'account_deletion_operations': {
                1: 'passportdbshard1',
                2: 'passportdbshard2',
            },
            'passman_recovery_keys': {
                1: 'passportdbshard1',
                2: 'passportdbshard2',
            },
        },
    },
    'intranet': {
        'development': {},
        'testing': {
            'attributes': {
                1: 'passportdbshard1',
            },
            'email_bindings': {
                1: 'passportdbshard1',
            },
            'extended_attributes': {
                1: 'passportdbshard1',
            },
            'phone_bindings': {
                1: 'passportdbshard1',
            },
            'phone_bindings_history': {
                1: 'passportdbshard1',
            },
            'phone_operations': {
                1: 'passportdbshard1',
            },
            'password_history': {
                1: 'passportdbshard1',
            },
            'tracks': {
                1: 'passportdbshard1',
            },
            'account_deletion_operations': {
                1: 'passportdbshard1',
            },
            'passman_recovery_keys': {
                1: 'passportdbshard1',
            },
        },
        'production': {
            'attributes': {
                1: 'passportdbshard1',
            },
            'email_bindings': {
                1: 'passportdbshard1',
            },
            'extended_attributes': {
                1: 'passportdbshard1',
            },
            'phone_bindings': {
                1: 'passportdbshard1',
            },
            'phone_bindings_history': {
                1: 'passportdbshard1',
            },
            'phone_operations': {
                1: 'passportdbshard1',
            },
            'password_history': {
                1: 'passportdbshard1',
            },
            'tracks': {
                1: 'passportdbshard1',
            },
            'account_deletion_operations': {
                1: 'passportdbshard1',
            },
            'passman_recovery_keys': {
                1: 'passportdbshard1',
            },
        },
    },
}

_DB_SHARDING_CONFIG['intranet']['rc'] = _DB_SHARDING_CONFIG['intranet']['production']
_DB_SHARDING_CONFIG['other']['rc'] = _DB_SHARDING_CONFIG['other']['production']
_DB_SHARDING_CONFIG['other']['development'] = _DB_SHARDING_CONFIG['other']['testing']
_DB_SHARDING_CONFIG['localhost'] = _DB_SHARDING_CONFIG['other']

DB_SHARDING_CONFIG = _DB_SHARDING_CONFIG[yenv.name][yenv.type]
