# -*- coding: utf-8 -*-

from datetime import timedelta

import yenv

from . import secrets


if yenv.name in {'localhost', 'stress'}:
    SIGNING_REGISTRY = {
        'default_version_id': '1',
        'versions': [
            {
                'id':   '1',
                'algorithm': 'SHA256',
                'salt_length': 32,
                'secret': secrets.SIGNING_SECRETS['1'],
            },
        ],
    }
else:
    SIGNING_REGISTRY = dict()

SIGNING_REGISTRY_FORESIGHT = timedelta(days=30).total_seconds()
SIGNING_REGISTRY_FORESIGHT_CACHE_TTL = timedelta(minutes=5).total_seconds()

# TTL можно менять только, нагенерив предварительно секретов с новыми именами,
# так чтобы они не пересекались со старыми.
SIGNING_REGISTRY_KEY_TTL = timedelta(hours=12).total_seconds()

# Общие секреты для большого Паспорта и Yandex-team для одного окружения
# (production, testing и т.д.)
YANDEX_AND_YANDEX_TEAM_SIGNING_REGISTRY_PATH = '/etc/yandex/passport-crypto-keys/yandex_and_yandex_team'

if yenv.type in {'development', 'testing', 'stress'}:
    # TTL можно менять только, нагенерив предварительно секретов с новыми именами,
    # так чтобы они не пересекались со старыми.
    SIGNING_REGISTRY_KEY_TTL = timedelta(days=365 * 10).total_seconds()
