# -*- coding: utf-8 -*-

import re

import yenv


ALLOWED_SOCIAL_RETPATH_SCHEMES = frozenset([
    'yandexnewssocialinteraction',
    'yandexnews',
    'yandexmail',
    'maple',
    'yandexmarket',
    'yamarket',
    'yamb',
    'autoru',
    'ru.beru.android.passport',
    'ru.beru.android.qa.passport',
    'bluemarket',
    'com.edadeal.android.passport',
    'edadeal',
    'ru.kinopoisk.passport',
    'ru.kinopoisk.dev.passport',
    'kp',
    'ai.meteum.passport',
    # Еда
    'com.appkode.foodfox.passport',
    'ru.foodfox.client.passport',
    'ru.foodfox.client.debug.passport',
])
ALLOWED_SOCIAL_RETPATH_SCHEME_PREFIXES = frozenset([])

_SOCIAL_URLS = {
    'other': {
        'testing': 'https://api.social-test.yandex.ru/%(service)s/',
        'rc': 'https://social-rc.yandex.ru/%(service)s/',
        'production': 'https://api.social.yandex.ru/%(service)s/',
    },
    'stress': {
        'stress': 'http://passport-fake-services.passport-load.passport.yandex.net/social/%(service)s/',
    },
    'intranet': {
        'development': 'http://socialdev-5.yandex.ru/%(service)s/',
        'testing': '',
    },
}

_SOCIAL_URLS['other']['development'] = _SOCIAL_URLS['other']['testing']
_SOCIAL_URLS['intranet']['production'] = _SOCIAL_URLS['intranet']['rc'] = _SOCIAL_URLS['intranet']['testing']
_SOCIAL_URLS['localhost'] = _SOCIAL_URLS['other']

SOCIAL_API_URL = _SOCIAL_URLS[yenv.name][yenv.type] % {'service': 'api'}
SOCIAL_BROKER_URL = _SOCIAL_URLS[yenv.name][yenv.type] % {'service': 'brokerapi'}

SOCIAL_API_CONSUMER = 'passport'

if yenv.type == 'production':
    # Максимальное время ожидания ответа социльного API.
    # Ручка /bind достаточно жирная (внутри делает под десяток запросов в БД),
    # так что таймаут сильно занижать нельзя.
    SOCIAL_API_TIMEOUT = 1.3  # Согласно исследованию PASSP-10508.

    # Число попыток получить ответ от социального API.
    SOCIAL_API_RETRIES = 2
else:
    SOCIAL_API_TIMEOUT = 2
    SOCIAL_API_RETRIES = 3

# Максимальное время ожидания ответа социльного брокера.
# Ручка получения task по токену достаточно жирная (внутри делает до 5 последовательных запросов в социалку),
# так что таймаут сильно занижать нельзя.

# Согласно исследованию PASSP-10508 значение было 2.
# Поменял на 3 из-за времени ответа ФБ.
SOCIAL_BROKER_TIMEOUT = 3


# Число попыток получить ответ от социального брокера.
SOCIAL_BROKER_RETRIES = 2

SOCIAL_DEFAULT_SUBSCRIPTION = [
    {
        'name': 'mail',
        'sid': 2,
        'providers': [
            'facebook',
            'odnoklassniki',
        ],
    },
    {
        'name': 'market',
        'sid': 25,
        'providers': [
            'vkontakte',
            'facebook',
            'twitter',
            'mailru',
            'google',
            'odnoklassniki',
        ],
    },
    {
        'name': 'social',
        'sid': 58,
        'providers': [],
    },
    {
        'name': 'text',
        'sid': 74,
        'providers': [
            'vkontakte',
            'facebook',
            'twitter',
            'mailru',
            'google',
            'odnoklassniki',
        ],
    },
    {
        'name': 'news',
        'sid': 83,
        'providers': [
            'vkontakte',
            'facebook',
            'twitter',
        ],
    },
]

_SOCIAL_AUTH_PROVIDERS = {
    'vk':   dict(id=1,  name='vkontakte'),
    'fb':   dict(id=2,  name='facebook'),
    'tw':   dict(id=3,  name='twitter'),
    'mr':   dict(id=4,  name='mailru'),
    'gg':   dict(id=5,  name='google'),
    'ok':   dict(id=6,  name='odnoklassniki'),
    'apl':  dict(id=28, name='apple'),
    'esia': dict(id=31, name='esia'),
}

# Провайдеры, которыми разрешено авторизоваться/регистрироваться через социальный брокер.
# загрузка аватарок при соц регистрации.
AUTH_ALLOWED_PROVIDER_TO_ID = {code: p['id'] for code, p in _SOCIAL_AUTH_PROVIDERS.items()}

AUTH_ALLOWED_PROVIDERS = _SOCIAL_AUTH_PROVIDERS.keys()

# То же самое, но через name вместо code
# TODO: избавиться в пользу AUTH_ALLOWED_PROVIDERS
SOCIAL_AUTH_PROVIDERS = [p['name'] for p in _SOCIAL_AUTH_PROVIDERS.values()]

# НЕ ЗАБУДЬ завести Яндексовое Oauth приложение на которое будет выписываться
# токен.
REGISTER_BY_TASK_PROVIDERS = ['mt', 'mts-belarus', 'geocell']

# Социальные провайдеры, которым мы доверяем проверку наличия телефона у
# пользователя.
SOCIAL_TRUSTED_SIMPLE_PHONE = ['mt', 'mts-belarus', 'geocell']


# Социальные провайдеры, которыми можно регистрироваться/логиниться по токену
# без EULA.
REGISTER_BY_TOKEN_PROVIDERS = ['mt']

# Социальные провайдеры, для которых возможна социальная авторизация из мобильных приложений
# с использованием внешнего браузера
# В списке нужно указывать и provider_name, и provider_code
SOCIAL_PROVIDERS_TO_USE_EXTERNAL_USERAGENT = frozenset(
    list(AUTH_ALLOWED_PROVIDER_TO_ID.keys()) +
    SOCIAL_AUTH_PROVIDERS,
)


# Признак, что можно предложить вход в связанный по E-Mail яндексовый аккаунт
# вместо соц. регистрации.
SOCIAL_SUGGEST_RELATED_ACCOUNT_ENABLED = True

# Фронтенд умеет показывать соц. саджест только в домике и АМе, поэтому
# ограничиваем множество потребителей, которым можно включить соц. саджест.
# Данные потребители -- это передаваемые из интернета идентификаторы в параметре
# broker_consumer, они не связаны с грантушкой.
SOCIAL_SUGGEST_RELATED_ACCOUNT_CONSUMERS_RE_LIST = [
    r'^passport$',
]
SOCIAL_SUGGEST_RELATED_ACCOUNT_CONSUMERS_RE_LIST = [re.compile(e) for e in SOCIAL_SUGGEST_RELATED_ACCOUNT_CONSUMERS_RE_LIST]

CHALLENGE_ON_SOCIAL_AUTH_ENABLED = True
