# -*- coding: utf-8 -*-
from os import path
import re

from . import (
    en,
    ru,
)


BASE_DIR = path.dirname(path.abspath(__file__))

FEMALE_NAMES_FILE = 'suggest/%(lang)s/female_names.txt'
MALE_NAMES_FILE = 'suggest/%(lang)s/male_names.txt'
TRANSLITERATIONS_FILE = 'suggest/%(lang)s/transliterations.conf'

LANG_TO_FEMALE_NAMES_FILE = {}
LANG_TO_MALE_NAMES_FILE = {}
LANG_TO_TRANSLITERATIONS_FILE = {}

SUGGEST_SUPPORTED_LANGUAGES = ['en', 'ru', 'tr']

for lang in SUGGEST_SUPPORTED_LANGUAGES:
    LANG_TO_FEMALE_NAMES_FILE[lang] = FEMALE_NAMES_FILE % dict(lang=lang)
    LANG_TO_MALE_NAMES_FILE[lang] = MALE_NAMES_FILE % dict(lang=lang)
    LANG_TO_TRANSLITERATIONS_FILE[lang] = TRANSLITERATIONS_FILE % dict(lang=lang)

SEPARATOR = '.'

INITIAL_WEIGHT = 100

SYNONYM_INITIAL_WEIGHT = 98

MANUAL_CHUNKS_INITIAL_WEIGHT = 100
MANUAL_CHUNKS_WEIGHT_STEP = 2

AUTO_CHUNKS_INITIAL_WEIGHT = 98
AUTO_CHUNKS_WEIGHT_STEP = 2

REPLACEMENTS_INITIAL_FACTOR = 1.0
REPLACEMENTS_FACTOR_STEP = 0.02

PREFIX_WEIGHT = 96

LANG_TO_MIXES = {
    'en': en.MIXES,
    'ru': ru.MIXES,
}
LANG_TO_MIXES['tr'] = LANG_TO_MIXES['en']

FEMALE_GENDER = 'f'
MALE_GENDER = 'm'
UNDEFINED_GENDER = 'u'

MAX_NAME_LENGTH = 20
MAX_LOGIN_LENGTH = 30

EXCLUDE_NAME_REGEXP = re.compile(u'[^-.\\w]+', flags=re.U)
EXCLUDE_LOGIN_REGEXP = re.compile(u'[^-.a-z0-9]+')

LOGIN_ENDS_WITH_NUMBER_REGEXP = re.compile(u'(\\d+)$')
RECENT_YEAR_REGEXP = re.compile(u'^(19|20)([0-9]{2})$')

MAX_TRANSLITERATIONS = 500
MAX_COMBINATIONS = 500

# Ограничимся топом при замене букв на цифры
LETTER_TO_NUMBER_COMBINATION_LIMIT = 100
# Если больше ~6 замен в слове - сокращаем количество вариантов
LETTER_TO_NUMBER_TRANSLITERATION_LIMIT = 100

LOGIN_SUGGESTIONS_LIMIT = 10
PACK_SIZE = 20
LOGIN_SUGGEST_MAX_ITERATIONS = 10

MALE_SEX_REGEXP = re.compile(u'(?:[оеё]в|[иоы]й|ин)$')
FEMALE_SEX_REGEXP = re.compile(u'(?:(?:[оеё]в|ин)а|ая)$')

LANG_TO_MALE_SURNAME_REGEXP = {
    'ru': MALE_SEX_REGEXP,
}

LANG_TO_FEMALE_SURNAME_REGEXP = {
    'ru': FEMALE_SEX_REGEXP,
}

# С мягким и твердым знаками
VOWELS = u'[аеёиоуьыъэюяәөұүіaeiouy]'
# Без ъ и ь
CONSONANTS = u'[бвгджзйклмнпрстфхцчшщғқңһbcdfghjklmnpqrstvwxz]'

# Без ъ и ь
VOWELS_2 = u'[аеёийоуыэюяәөұүіaeiouy]'
# С ъ и ь и без казахского
CONSONANTS_2 = u'[бвгджзйклмнпрстфхцчшщьъbcdfghjklmnpqrstvwxz]'

# Первый символ
FC_REGEXP = re.compile(u'^(.)')

# Первый слог лениво
FSL_PATTERN = u'^(.*?{vowels}{consonants})(?:{vowels}|.{{2,}})$'.format(
    vowels=VOWELS,
    consonants=CONSONANTS,
)
FSL_REGEXP = re.compile(FSL_PATTERN)

# Первый слог жадно
FSG_PATTERN = u'^(.*?{vowels}{consonants}+)'.format(
    vowels=VOWELS,
    consonants=CONSONANTS,
)
FSG_REGEXP = re.compile(FSG_PATTERN)

# Первые два слога лениво
TFSL_PATTERN = u'^(.*?{vowels}{consonants}+{vowels}{consonants})(?:{vowels}|.{{2,}})$'.format(
    vowels=VOWELS,
    consonants=CONSONANTS,
)
TFSL_REGEXP = re.compile(TFSL_PATTERN)

# Первые два слога жадно
TFSG_PATTERN = u'^(.*?{vowels}{consonants}+{vowels}{consonants}+)'.format(
    vowels=VOWELS,
    consonants=CONSONANTS,
)
TFSG_REGEXP = re.compile(TFSG_PATTERN)

# Первый слог жадно + одна гласная (c другими наборами букв)
FSGV_PATTERN = u'^(.*?{vowels}{consonants}+{vowels})'.format(
    vowels=VOWELS_2,
    consonants=CONSONANTS_2,
)
FSGV_REGEXP = re.compile(FSGV_PATTERN)

GENDER_TO_CHUNKS_REGEXP = {
    FEMALE_GENDER: [
        FC_REGEXP,
        FSL_REGEXP,
        FSGV_REGEXP,
    ],
    MALE_GENDER: [
        FC_REGEXP,
        FSL_REGEXP,
        FSG_REGEXP,
        TFSL_REGEXP,
        TFSG_REGEXP,
    ],
    UNDEFINED_GENDER: [
        FC_REGEXP,
        FSL_REGEXP,
        FSG_REGEXP,
        TFSG_REGEXP,
    ],
}

LETTER_TO_NUMBER_REPLACEMENTS = {
    'a': [
        {
            'replacements': [
                {'replacement': 'a', 'factor': 1.0},
                {'replacement': '4', 'factor': 0.94},
            ],
            'pattern': 'a',
            'characters': 'a',
        },
    ],
    'b': [
        {
            'replacements': [
                {'replacement': 'b', 'factor': 1.0},
                {'replacement': '8', 'factor': 0.94},
            ],
            'pattern': 'b',
            'characters': 'b',
        },
    ],
    'e': [
        {
            'replacements': [
                {'replacement': 'e', 'factor': 1.0},
                {'replacement': '3', 'factor': 0.94},
            ],
            'pattern': 'e',
            'characters': 'e',
        },
    ],
    'g': [
        {
            'replacements': [
                {'replacement': 'g', 'factor': 1.0},
                {'replacement': '9', 'factor': 0.94},
            ],
            'pattern': 'g',
            'characters': 'g',
        },
    ],
    'h': [
        {
            'replacements': [
                {'replacement': 'h', 'factor': 1.0},
                {'replacement': '4', 'factor': 0.92},
            ],
            'pattern': 'h',
            'characters': 'h',
        },
    ],
    'i': [
        {
            'replacements': [
                {'replacement': 'i', 'factor': 1.0},
                {'replacement': '1', 'factor': 0.94},
            ],
            'pattern': 'i',
            'characters': 'i',
        },
    ],
    'l': [
        {
            'replacements': [
                {'replacement': 'l', 'factor': 1.0},
                {'replacement': '1', 'factor': 0.92},
            ],
            'pattern': 'l',
            'characters': 'l',
        },
    ],
    'm': [
        {
            'replacements': [
                {'replacement': 'm', 'factor': 1.0},
                {'replacement': '44', 'factor': 0.92},
            ],
            'pattern': 'm',
            'characters': 'm',
        },
    ],
    'o': [
        {
            'replacements': [
                {'replacement': 'o', 'factor': 1.0},
                {'replacement': '0', 'factor': 0.94},
            ],
            'pattern': 'o',
            'characters': 'o',
        },
    ],
    'q': [
        {
            'replacements': [
                {'replacement': 'q', 'factor': 1.0},
                {'replacement': '9', 'factor': 0.94},
            ],
            'pattern': 'q',
            'characters': 'q',
        },
    ],
    's': [
        {
            'replacements': [
                {'replacement': 's', 'factor': 1.0},
                {'replacement': '5', 'factor': 0.94},
            ],
            'pattern': 's',
            'characters': 's',
        },
    ],
    't': [
        {
            'replacements': [
                {'replacement': 't', 'factor': 1.0},
                {'replacement': '7', 'factor': 0.92},
            ],
            'pattern': 't',
            'characters': 't',
        },
    ],
    'z': [
        {
            'replacements': [
                {'replacement': 'z', 'factor': 1.0},
                {'replacement': '2', 'factor': 0.94},
            ],
            'pattern': 'z',
            'characters': 'z',
        },
    ],
}

LETTER_TO_NUMBER_REPLACEMENTS_KEYS = set(LETTER_TO_NUMBER_REPLACEMENTS.keys())

LOGIN_PREFIXES = [
    'awesome',
    'cool',
    'fine',
    'good',
    'great',
    'kind',
    'mighty',
    'nice',
    'shy',
    'super',
    'wise',
    'wonder',
    'ya',
]
