# -*- coding: utf-8 -*-

from datetime import timedelta

from .signing import SIGNING_REGISTRY_KEY_TTL


SUPPORT_CODE_API_ENABLED = True
SUPPORT_CODE_GENERATE_RETRIES = 10
SUPPORT_CODE_LENGTH = 6

SUPPORT_CODE_TTL = timedelta(minutes=15).total_seconds()
# Время жизни кода не должно превышать время жизни подписывающего секрета.
# Потому что в противном случае мы не сможем гарантировать, что уникальность
# хранимых в БД кодов (когда для каждого кода хранится два хеша -- hash(code,
# cur_secret), hash(code, prev_secret).
assert SUPPORT_CODE_TTL <= SIGNING_REGISTRY_KEY_TTL
