# -*- coding: utf-8 -*-

import yenv

from .tensornet_features import _FEATURES_DESCRIPTION_PROFILE_PASSP_16385


_TENSORNET_API_URLS = {
    'localhost': {
        'development': 'http://tsnet-test.passport.yandex.net',
        'testing': 'http://tsnet-test.passport.yandex.net',
        'rc': 'http://tsnet.passport.yandex.net',
        'production': 'http://tsnet.passport.yandex.net',
    },
}
TENSORNET_API_URL = _TENSORNET_API_URLS.get(yenv.name, {}).get(yenv.type, '')


# У каждой модели задается деноминатор - при определении применимой модели, пытаемся применить деноминаторы
# по убыванию значения деноминатора.
TENSORNET_MODEL_CONFIGS = {
    ('profile', 'passp-16385'): {
        'timeout': 0.03,
        'retries': 2,
        'features_description': _FEATURES_DESCRIPTION_PROFILE_PASSP_16385,
        'threshold': 0.5,
        'denominator': 1,  # Новая модель на 100%
        'features_builder_version': 3,
    },
}
