# -*- coding: utf-8 -*-

import json
import os

from passport.backend.utils.file import read_file


TANKER_BASE_URL = 'https://tanker-api.yandex-team.ru'

TRANSLATIONS = {
    'sms': {
        'keyset_id': 'Messages',
        'project_id': 'yasms',
        'msgid_re': r'SMS\.([\w\.]+)',
    },
    'questions': {
        'keyset_id': 'Texts',
        'project_id': 'passport',
        'msgid_re': r'Qus\.(\d+)',
    },
    'social': {
        'keyset_id': 'Social',
        'project_id': 'passport',
        'msgid_re': r'^(?!Qus)(.+)$',
    },
    'texts': {
        'keyset_id': 'Texts',
        'project_id': 'passport',
        'msgid_re': r'^(?!Qus)(.+)$',
    },
    'notifications': {
        'keyset_id': 'Notifications',
        'project_id': 'passport',
        'msgid_re': r'^(.+)$',
    },
    'validator': {
        'keyset_id': 'Validator',
        'project_id': 'passport',
        'msgid_re': r'^(.+)$',
    },
}


def _load(fname):
    return json.loads(read_file(os.path.join(os.path.dirname(__file__), fname)))


TANKER_DEFAULT_KEYSET = 'NOTIFICATIONS'


# Эти файлы должны быть на диске и должны представлять из себя валидный json
SMS = _load('sms.json')

QUESTIONS = _load('questions.json')

SOCIAL = _load('social.json')

TEXTS = _load('texts.json')

NOTIFICATIONS = _load('notifications.json')

VALIDATOR = _load('validator.json')
