# -*- coding: utf-8 -*-
import yenv


_UFO_API_URLS = {
    'localhost': {
        'development': 'http://ufo-test.sezam.yandex.net:8080/',
        'testing': 'http://ufo-test.sezam.yandex.net:8080/',
        'rc': 'http://ufo.sezam.yandex.net:8080/',
        'production': 'http://ufo.sezam.yandex.net:8080/',
    },
}

if yenv.name == 'localhost':
    UFO_API_URL = _UFO_API_URLS[yenv.name][yenv.type]
else:
    UFO_API_URL = ''

# максимальное время ожидания ответа UfoApi
UFO_API_TIMEOUT = 0.1

# число попыток получить ответ от UfoApi
UFO_API_RETRIES = 2

# необходимость передать флаг использования RC-таблицы при походе в UfoApi
UFO_API_USE_RC = yenv.type == 'rc'
