# -*- coding: utf-8 -*-

import yenv


# Шаблон паспортного хоста, для построения ссылок на паспортные страницы на foreign домене
_FOREIGN_PASSPORT_BASE_URL_TEMPLATES = {
    'localhost': {
        'testing': 'https://passport-test.%(foreign_domain)s',
        'production': 'https://passport.%(foreign_domain)s',
    },
}

FOREIGN_PASSPORT_BASE_URL_TEMPLATE = _FOREIGN_PASSPORT_BASE_URL_TEMPLATES.get(yenv.name, {}).get(yenv.type)


# Шаблон паспортного хоста, для построения ссылок на паспортные страницы на заданном TLD
_PASSPORT_BASE_URL_TEMPLATES = {
    'localhost': {
        'development': 'https://0.passportdev.yandex.%(tld)s',
        'testing': 'https://passport-test.yandex.%(tld)s',
        'rc': 'https://passport-rc.yandex.%(tld)s',
        'production': 'https://passport.yandex.%(tld)s',
    },
    'stress': {
        'stress': 'https://passport.yandex.%(tld)s',
    },
    'intranet': {
        'development': 'https://passport.yandex-team.%(tld)s',
        'testing': 'https://passport-test.yandex-team.%(tld)s',
        'rc': 'https://passport-rc.yandex-team.%(tld)s',
        'production': 'https://passport.yandex-team.%(tld)s',
    },
}

PASSPORT_BASE_URL_TEMPLATE = _PASSPORT_BASE_URL_TEMPLATES[yenv.name][yenv.type]


_ID_BASE_URL_TEMPLATES = {
    'localhost': {
        'testing': 'https://id-test.yandex.%(tld)s',
        'rc': 'https://id-rc.yandex.%(tld)s',
        'production': 'https://id.yandex.%(tld)s',
    },
    'stress': {},
    'intranet': {
        'production': 'https://id.yandex-team.%(tld)s',
    },
}
# домен id есть не во всех окружениях; если его нет, то фолбечимся на паспортный домен
ID_BASE_URL_TEMPLATE = _ID_BASE_URL_TEMPLATES[yenv.name].get(yenv.type, PASSPORT_BASE_URL_TEMPLATE)

if yenv.name == 'localhost':
    # Шаблон ссылки на начало восстановления
    RESTORE_DEFAULT_URL_TEMPLATE = PASSPORT_BASE_URL_TEMPLATE + '/restoration'
    # Шаблон ссылки для восстановления по ключу
    RESTORE_BY_LINK_TEMPLATE_URL = PASSPORT_BASE_URL_TEMPLATE + '/restoration/?key=%(key)s'
else:
    RESTORE_DEFAULT_URL_TEMPLATE = RESTORE_BY_LINK_TEMPLATE_URL = ''

# Страница дорегистрации
COMPLETION_URL_TEMPLATE = PASSPORT_BASE_URL_TEMPLATE + '/profile/upgrade'
COMPLETION_URL_AM_TEMPLATE = PASSPORT_BASE_URL_TEMPLATE + '/am?mode=upgrade'
# Страница профиля
PROFILE_URL_TEMPLATE = PASSPORT_BASE_URL_TEMPLATE + '/profile'
# Страница профиля с email-адресами
PROFILE_EMAILS_URL_TEMPLATE = PASSPORT_BASE_URL_TEMPLATE + '/profile/emails'
# Страница профиля с телефонами
PROFILE_PHONES_URL_TEMPLATE = PASSPORT_BASE_URL_TEMPLATE + '/profile/phones'
# Страница УД
PROFILE_ACCESS_URL_TEMPLATE = PASSPORT_BASE_URL_TEMPLATE + '/profile/access'
# Страница истории в Паспорте
PROFILE_JOURNAL_URL_TEMPLATE = PASSPORT_BASE_URL_TEMPLATE + '/profile/journal'
# Страница смены КВ/КО
PROFILE_CHANGE_HINT_URL_TEMPLATE = PASSPORT_BASE_URL_TEMPLATE + '/profile/change-hint'
# Страница показа одноразового кода из пуша
PUSH_2FA_CODE_URL_TEMPLATE = PASSPORT_BASE_URL_TEMPLATE + '/am/push/getcode?track_id=%(track_id)s'

# Почта
_MAIL_BASE_URL_TEMPLATE = 'https://mail.yandex.%(tld)s'
# Почтовый журнал
MAIL_JOURNAL_URL_TEMPLATE = _MAIL_BASE_URL_TEMPLATE + '/neo2/#setup/journal'

# Диск
_DISK_BASE_URL_TEMPLATE = 'https://disk.yandex.%(tld)s'
# Журнал Диска
DISK_JOURNAL_URL_TEMPLATE = _DISK_BASE_URL_TEMPLATE + '/client/journal'

# Предупреждение об изменениях в аккаунте
PUSH_ACCOUNT_MODIFICATION_URL_TEMPLATE = PASSPORT_BASE_URL_TEMPLATE + (
    '/am/push/changesalert/?uid=%(uid)s&timestamp=%(timestamp)s&track_id=%(track_id)s&'
    'ip=%(ip)s&location=%(location)s&map_url=%(map_url)s&title_key=%(title_key)s'
)
PUSH_ACCOUNT_MODIFICATION_MAP_URL_TEMPLATE = (
    'https://static-maps.yandex.ru/1.x/?size=450,450&z=8&l=map&ll=%(lon)s,%(lat)s&'
    'lang=%(lang)s&pt=%(lon)s,%(lat)s,pmrdm'
)
