# -*- coding: utf-8 -*-
from collections import namedtuple
from itertools import groupby
import json

from frozendict import frozendict
from passport.backend.utils.file import read_file


_browser = namedtuple('browser', 'id name')
_os = namedtuple('os', 'id name version')


def load(filename):
    return json.loads(read_file(filename))


def filter_unknown(value):
    return None if value == 'Unknown' else value


# конфиги, приезжающие из пакета uatraits-data>=1.1.39, проверенные passport-libs-checker
_BROWSER_CONFIG = '/var/cache/passport-libs-checker/dict_BrowserName.json'
_OS_CONFIG = '/var/cache/passport-libs-checker/dict_OSFamily_OSVersion_OSName.json'

_BROWSERS = tuple(
    _browser(id=record['id'], name=filter_unknown(record['BrowserName']))
    for record in load(_BROWSER_CONFIG)
)
BROWSER_ENCODE = frozendict((browser.name, browser.id) for browser in _BROWSERS)
BROWSER_DECODE = frozendict((browser.id, browser.name) for browser in _BROWSERS)

_OSES = tuple(
    _os(
        id=record['id'],
        name=filter_unknown(record.get('OSName')) or filter_unknown(record.get('OSFamily')),
        version=filter_unknown(record.get('OSVersion')),
    )
    for record in load(_OS_CONFIG)
)
OS_ENCODE = frozendict(((os.name, os.version), os.id) for os in _OSES if os.name)
OS_DUMB_ENCODE = frozendict(
    (name, list(oses)[0].id)
    for name, oses in groupby(sorted(_OSES, key=lambda x: x.name or ''), lambda x: x.name)
    if name
)
OS_DECODE = frozendict((os.id, (os.name, os.version)) for os in _OSES)

_OS_FAMILIES = tuple(
    _os(
        id=record['id'],
        name=filter_unknown(record.get('OSFamily')),
        version=filter_unknown(record.get('OSVersion')),
    )
    for record in load(_OS_CONFIG)
)
OS_FAMILY_ENCODE = frozendict((os.name, os.id) for os in _OS_FAMILIES if os.name)
OS_FAMILY_DECODE = frozendict((os.id, os.name) for os in _OS_FAMILIES)
