# -*- coding: utf-8 -*-
import yenv


# Cтепень "надёжности" аутентификатора. См. https://w3c.github.io/webauthn/#sctn-attestation-types
WEBAUTHN_IS_TRUSTED_ATTESTATION_CERT_REQUIRED = yenv.type != 'development'
WEBAUTHN_IS_SELF_ATTESTATION_PERMITTED = True
WEBAUTHN_IS_NONE_ATTESTATION_PERMITTED = False

# Необходимость верификации пользователя (например, по отпечатку пальца).
# См. https://w3c.github.io/webauthn/#user-verification
WEBAUTHN_IS_USER_VERIFICATION_REQUIRED = yenv.type != 'development'

# Тип аутентификатора (встроенный / внешний / любой), см. https://w3c.github.io/webauthn/#enum-attachment
WEBAUTHN_AUTHENTICATOR_ATTACHMENT = None if yenv.type == 'development' else 'platform'

WEBAUTHN_CHALLENGE_DEFAULT_BYTE_LEN = 32
WEBAUTHN_RELYING_PARTY_NAME = 'Yandex'

WEBAUTHN_CREDENTIALS_MAX_COUNT = 10
