PY23_LIBRARY()

OWNER(
    g:passport_python
)

PEERDIR(
    contrib/python/frozendict
    library/python/yenv
    passport/backend/utils
    passport/backend/api/settings/am_pushes
    passport/backend/api/settings/blacklisted_as
    passport/backend/api/settings/mail_subscriptions
    passport/backend/api/settings/logbroker_takeout
    passport/backend/api/settings/sharding
)

PY_SRCS(
    antifraud.py
    avatars_mds_api.py
    bot_api.py
    account_deletion.py
    afisha_api.py
    allowed_hosts.py
    alt_domains.py
    app_ids.py
    auth_methods.py
    bbro_api.py
    bilet_api.py
    billing.py
    blackbox.py
    blackbox_fields.py
    captcha.py
    clean_web_api.py
    collections_api.py
    constants/blackbox.py
    constants/common.py
    constants/restore.py
    constants/__init__.py
    cookies.py
    counters/account_modification.py
    counters/antifraud.py
    counters/auth_challenge_per_ip.py
    counters/auth_email.py
    counters/auth_magic_link.py
    counters/auth_push.py
    counters/bad_rfc_otp.py
    counters/calls_per_ip.py
    counters/calls_per_phone.py
    counters/change_password.py
    counters/check_answer.py
    counters/common.py
    counters/drive.py
    counters/email_validator.py
    counters/family.py
    counters/migrate_mailish.py
    counters/passman_recovery_key.py
    counters/profile_fails.py
    counters/question_change_email_notification.py
    counters/register_mailish.py
    counters/register_phonish_by_phone.py
    counters/registration_email.py
    counters/registration_karma.py
    counters/registration_kolonkish.py
    counters/registration_social.py
    counters/registration_uncompleted.py
    counters/restore.py
    counters/sms_per_ip.py
    counters/sms_per_phone.py
    counters/userinfo.py
    counters/yakey_2fa_pictures.py
    counters/yapic.py
    counters/__init__.py
    datasync_api.py
    db.py
    domain_keyspaces.py
    edadeal.py
    drive_api.py
    email_domain.py
    email_validator.py
    env_profile.py
    family.py
    federal_configs_api.py
    fio_suggest_api.py
    forced_challenge.py
    foreign_domains.py
    frodo.py
    geosearch_api.py
    hint_questions.py
    historydb_api.py
    hosts.py
    kolmogor.py
    language.py
    ldap.py
    libraries.py
    list_of_tlds.py
    lite.py
    logbroker.py
    logs.py
    mailer.py
    mailish.py
    mail_apis.py
    mail_static.py
    market.py
    mda2.py
    messenger_api.py
    mobile_device_info.py
    music.py
    oauth.py
    octopus_api.py
    password_blacklist.py
    password_hash.py
    password_policy.py
    pdd_domains.py
    perimeter_api.py
    phone_karma.py
    phone_squatter.py
    phone_whitelisted_consumers.py
    phonish.py
    plus.py
    push_api.py
    queue.py
    redis.py
    register.py
    restore.py
    rfc_otp.py
    s3.py
    saml_sso.py
    secrets/default.py
    secrets/__init__.py
    sender_api.py
    settings.py
    shakur.py
    signing.py
    sms_retriever.py
    social.py
    ssl.py
    staff.py
    suggest/en/conf.py
    suggest/en/__init__.py
    suggest/login_suggester_conf.py
    suggest/ru/conf.py
    suggest/ru/__init__.py
    suggest/tr/__init__.py
    suggest/__init__.py
    support_code.py
    takeout.py
    tensornet.py
    tensornet_features.py
    tlds.py
    translations.py
    tv.py
    ufo_api.py
    urls.py
    useragent.py
    video_api.py
    webauthn.py
    yasms.py
    ydb.py
    ysa_mirror_api.py
    __init__.py
)

RESOURCE(
    blacklist.txt /usr/lib/yandex/passport-password-blacklist/blacklist.txt
    dict_BrowserName.json /var/cache/passport-libs-checker/dict_BrowserName.json
    dict_OSFamily_OSVersion_OSName.json /var/cache/passport-libs-checker/dict_OSFamily_OSVersion_OSName.json
    features.txt /usr/lib/yandex/passport-semiautoform-model/features.txt
    notifications.json passport/backend/api/settings/notifications.json
    questions.json passport/backend/api/settings/questions.json
    restricted_directory_subdomains.txt passport/backend/api/settings/restricted_directory_subdomains.txt
    social.json passport/backend/api/settings/social.json
    texts.json passport/backend/api/settings/texts.json
    sms.json passport/backend/api/settings/sms.json
    validator.json passport/backend/api/settings/validator.json

    suggest/en/female_names.txt suggest/en/female_names.txt
    suggest/en/male_names.txt suggest/en/male_names.txt
    suggest/en/transliterations.conf suggest/en/transliterations.conf
    suggest/ru/female_names.txt suggest/ru/female_names.txt
    suggest/ru/male_names.txt suggest/ru/male_names.txt
    suggest/ru/transliterations.conf suggest/ru/transliterations.conf
    suggest/tr/female_names.txt suggest/tr/female_names.txt
    suggest/tr/male_names.txt suggest/tr/male_names.txt
    suggest/tr/transliterations.conf suggest/tr/transliterations.conf
)

END()

RECURSE(
    am_pushes
    blacklisted_as
    cli
    mail_subscriptions
    logbroker_takeout
    sharding
)

RECURSE_FOR_TESTS(
    tests
)
