# -*- coding: utf-8 -*-

from datetime import timedelta

from passport.backend.api.settings.app_ids import (
    app_id_with_suffix,
    TAXI_SUFFIX_LIST,
)
from passport.backend.api.settings.constants.common import TIMESTAMP_DELTA_ONE_DAY
import yenv


_YASMS_URLS = {
    'other': {
        'development': 'https://phone-passport-test.yandex.ru/',
        'testing': 'https://phone-passport-test.yandex.ru/',
        'rc': 'https://sms.passport.yandex.ru/',
        'production': 'https://sms.passport.yandex.ru/',
    },
    'stress': {
        'stress': 'http://passport-fake-services.passport-load.passport.yandex.net/yasms/',
    },
    'intranet': {
        'development': '',
    },
}

_YASMS_URLS['intranet']['production'] = _YASMS_URLS['intranet']['rc'] = _YASMS_URLS['intranet']['testing'] = _YASMS_URLS['intranet']['development']

_YASMS_URLS['localhost'] = _YASMS_URLS['other']

YASMS_URL = _YASMS_URLS[yenv.name][yenv.type]
YASMS_SENDER = 'passport'
YASMS_RETRIES = 2
YASMS_TIMEOUT = 1.3

# Если номер привязан <= L раз, считаем этот номер чистым.
YASMS_VALIDATION_LIMIT = 1

# Потребители, к именам которых не нужно добавлять префикс перлового Я.Смса
YASMS_CONSUMERS_WITHOUT_OLD_PREFIX = set()

# Если число привязок номера не превышает
# YASMS_CLEAN_PHONE_NUMBER_BINDINGS_LIMIT, то он чистый.
YASMS_CLEAN_PHONE_NUMBER_BINDINGS_LIMIT = 1

# Максимум на привязок номера к разным учетным записям.
if yenv.type in {'development', 'testing'}:
    YASMS_PHONE_BINDING_LIMIT = 3
else:
    YASMS_PHONE_BINDING_LIMIT = 10

# Длина кода для подтверждения владения номером из ручек перлового Я.Смс
SMS_LEGACY_VALIDATION_CODE_LENGTH = 4


SMS_VALIDATION_CODE_LENGTH = 6


# Время жизни операции-флажка в секундах
YASMS_MARK_OPERATION_TTL = 60

PHONE_QUARANTINE_SECONDS = 14 * TIMESTAMP_DELTA_ONE_DAY


# Минимальный период втечение которого можно быть уверенным, что официальный
# владелец номера не поменялся.
if yenv.type in {'development', 'testing', 'rc'}:
    PERIOD_OF_PHONE_NUMBER_LOYALTY = PERIOD_OF_PHONE_NUMBER_LOYALTY_PRACTICAL = timedelta(minutes=10)
else:
    # Значение, рекомендованное Такси
    PERIOD_OF_PHONE_NUMBER_LOYALTY = timedelta(days=365)
    # Значение, за которое пролилась кровь пользователя. Стали появлятся люди,
    # которые не привязывали телефон к аккаунту в Яндексе, но это сделал
    # предыдущий владелец номера. Такая ситуация приводит к получению спама
    # новым владельцем номера с аккаунта старого владельца. Такая ситуация
    # может привести к краже аккаунта старого владельца номера новым
    # владельцем номера. Поэтому из практических соображений укоротим период
    # с 365 дней до 90 дней, там где это возможно.
    PERIOD_OF_PHONE_NUMBER_LOYALTY_PRACTICAL = timedelta(days=90)


# Телефон и код для ревьюеров (Google, Apple) мобильных приложений.
# Использовать их в других целях (в том числе для тестирования внутри Яндекса) НЕЛЬЗЯ.
FAKE_CODE = '103397'
TEST_PHONE_NUMBERS_ACCEPTING_FAKE_CODE = (
    '+70000000000',
    '+70001122334',
    '+70003456689',
)


# Особые роуты для отправки СМС применяются в 100% случаев
APP_ID_SPECIFIC_ROUTE_DENOMINATOR = 1


# app_id должны быть в lowercase
_TAXI_APP_IDS = (
    (
        'ru.yandex.ytaxi',
    )
    + app_id_with_suffix('ru.yandex.taxi', TAXI_SUFFIX_LIST)
)

_VEZET_APP_IDS = (
    app_id_with_suffix('ru.yandex.vezet', TAXI_SUFFIX_LIST)
)

_UBER_APP_IDS = (
    app_id_with_suffix('ru.yandex.uber', TAXI_SUFFIX_LIST)
    + app_id_with_suffix('ru.yandex.uber_by', TAXI_SUFFIX_LIST)
    + app_id_with_suffix('ru.yandex.uber-by', TAXI_SUFFIX_LIST)
    + app_id_with_suffix('ru.yandex.uber_kz', TAXI_SUFFIX_LIST)
    + app_id_with_suffix('ru.yandex.uber-kz', TAXI_SUFFIX_LIST)
    + app_id_with_suffix('com.mlubv.uber.az', TAXI_SUFFIX_LIST)
    + app_id_with_suffix('com.mlubv.uber-az', TAXI_SUFFIX_LIST)
)

YANGO_APP_IDS = (
    app_id_with_suffix('com.yandex.yango', TAXI_SUFFIX_LIST)
    + app_id_with_suffix('ru.yandex.yango', TAXI_SUFFIX_LIST)

    # Yango Lite android
    + app_id_with_suffix('com.yango.lite', TAXI_SUFFIX_LIST)
    # Yango Lite ios
    + app_id_with_suffix('ru.yandex.yango-lite', TAXI_SUFFIX_LIST)
)

_LAVKA_APP_IDS = (
    # Яндекс.Лавка android
    'com.yandex.lavka',
    'com.yandex.lavka.beta',
    'com.yandex.lavka.develop',
    'com.yandex.lavka.debug',
    # Яндекс.Лавка ios
    'ru.yandex.lavka',
    'ru.yandex.lavka.inhouse',
    'ru.yandex.lavka.develop',
)

_DELI_APP_IDS = (
    'com.yandex.yangodeli',
    'ru.yandex.yangodeli',
)

# PASSP-38094
_TURLA_APP_IDS = (
    'com.turla.rider',
    'com.turla.rider.debug',
    'com.turla.rider.inhouse',
    'com.turla.rider.develop',
)

# PASSP-38280
_TELEON_APP_IDS = (
    'com.ygogo.rider',
    'com.ygogo.rider.beta',
    'com.ygogo.rider.debug',
    'com.ygogo.rider.develop',
    'com.ygogo.rider.inhouse',
)

_RIDA_APP_IDS = (
    # Rida android
    'com.rida.rider',
    'com.rida.rider.debug',
    'com.rida.rider.develop',
    # Rida iOS
    'app.rida',
    'app.rida.inhouse',
    'app.rida.develop',
)

APP_ID_TO_SMS_ROUTE = {
    'com.yandex.courier': 'courier',
}
APP_ID_TO_SMS_ROUTE.update({app_id: 'uber_auth' for app_id in _UBER_APP_IDS})
APP_ID_TO_SMS_ROUTE.update({app_id: 'go_auth' for app_id in _TAXI_APP_IDS})
APP_ID_TO_SMS_ROUTE.update({app_id: 'yango_auth' for app_id in YANGO_APP_IDS})
APP_ID_TO_SMS_ROUTE.update({app_id: 'lavka_auth' for app_id in _LAVKA_APP_IDS})
APP_ID_TO_SMS_ROUTE.update({app_id: 'deli_auth' for app_id in _DELI_APP_IDS})
APP_ID_TO_SMS_ROUTE.update({app_id: 'vezet' for app_id in _VEZET_APP_IDS})
APP_ID_TO_SMS_ROUTE.update({app_id: 'turla_auth' for app_id in _TURLA_APP_IDS})
APP_ID_TO_SMS_ROUTE.update({app_id: 'teleon_auth' for app_id in _TELEON_APP_IDS})
APP_ID_TO_SMS_ROUTE.update({app_id: 'rida_auth' for app_id in _RIDA_APP_IDS})

CONSUMER_TO_SMS_ROUTE = {
    'taximeter': 'taxiauth',
    'carsharing': 'drive',
    'taxi_study': 'taxi',
}
