# -*- coding: utf-8 -*-

import yenv

from . import secrets


_YDB_ENDPOINTS = {
    'other': {
        'development': 'ydb-ru-prestable.yandex.net:2135',
        'testing': 'ydb-ru-prestable.yandex.net:2135',
        'rc': 'ydb-ru.yandex.net:2135',
        'production': 'ydb-ru.yandex.net:2135',
    },
    'stress': {
        'stress': 'ydb-ru-prestable.yandex.net:2135',
    },
}
_YDB_ENDPOINTS['intranet'] = _YDB_ENDPOINTS['other']

_YDB_DATABASES = {
    'other': {
        'development': '/ru-prestable/passport-data/prestable/passport-users',
        'testing': '/ru-prestable/passport-data/prestable/passport-users',
        'rc': '/ru/passport-data/prod/passport-users',
        'production': '/ru/passport-data/prod/passport-users',
    },
    'stress': {
        'stress': '/ru-prestable/passport-data/prestable/passport-users',
    },
    'intranet': {
        'development': '',
        'testing': '',
        'rc': '',
        'production': '',
    },
}

_YDB_PROFILE_TABLES = {
    'other': {
        'development': 'profile-testing',
        'testing': 'profile-testing',
        'rc': 'profile',
        'production': 'profile',
    },
    'stress': {
        'stress': 'profile-testing',
    },
    'intranet': {
        'development': '',
        'testing': '',
        'rc': '',
        'production': '',
    },
}

_YDB_ENDPOINTS['localhost'] = _YDB_ENDPOINTS['other']
_YDB_DATABASES['localhost'] = _YDB_DATABASES['other']
_YDB_PROFILE_TABLES['localhost'] = _YDB_PROFILE_TABLES['other']

if yenv.name in {'localhost', 'stress'}:
    YDB_DRIVE_DATABASE = {
        'testing': '/ru-prestable/passport-data/prestable/drive_active_sessions',
        'production': '/ru/passport-data/prod/drive_active_sessions',
    }
    YDB_DRIVE_DATABASE['development'] = YDB_DRIVE_DATABASE['testing']
    YDB_DRIVE_DATABASE['stress'] = YDB_DRIVE_DATABASE['testing']
    YDB_DRIVE_DATABASE['rc'] = YDB_DRIVE_DATABASE['production']
    YDB_DRIVE_DATABASE = YDB_DRIVE_DATABASE[yenv.type]
else:
    YDB_DRIVE_DATABASE = ''
YDB_DRIVE_ENABLED = yenv.name != 'intranet'

YDB_SUPPORT_CODE_DATABASE = '/ru/passport-data/prod/support_codes'
if yenv.type in {'development', 'testing', 'stress'}:
    YDB_SUPPORT_CODE_DATABASE = '/ru-prestable/passport-data/prestable/support_codes'
YDB_SUPPORT_CODE_ENABLED = True

YDB_FAMILY_INVITE_DATABASE = '/ru/passport-data/prod/family_invites'
if yenv.type in {'development', 'testing', 'stress'}:
    YDB_FAMILY_INVITE_DATABASE = '/ru-prestable/passport-data/prestable/family_invites'
YDB_FAMILY_INVITE_ENABLED = yenv.name != 'intranet'

YDB_TURBOAPP_PARTNERS_DATABASE = '/ru/passport-data/prod/turboapp_partners'
if yenv.type in {'development', 'testing', 'stress'}:
    YDB_TURBOAPP_PARTNERS_DATABASE = '/ru-prestable/passport-data/prestable/turboapp_partners'
YDB_TURBOAPP_PARTNERS_ENABLED = yenv.name != 'intranet'

# 1 ретрай, потому что ребята из ydb попросили ждать максимум времени, сколько можем, в одном запросе.
# клиент ydb сам не повторяет попытки соединиться на транспортных проблемах
YDB_RETRIES = 0  # Будет 1 запрос и 0 попыток его повторить
YDB_CONNECTION_TIMEOUT = 1.000
YDB_GET_SESSION_TIMEOUT = 0.150
YDB_DEADLINE = 0.750
YDB_TIMEOUT = 0.450

YDB_USE_TVM = False
YDB_TOKEN = secrets.YDB_TOKEN

YDB_ENDPOINT = _YDB_ENDPOINTS[yenv.name][yenv.type]
YDB_DATABASE = _YDB_DATABASES[yenv.name][yenv.type]
YDB_PROFILE_TABLE = _YDB_PROFILE_TABLES[yenv.name][yenv.type]
YDB_PROFILE_ENABLED = yenv.name != 'intranet'

# Сколько максимум строк вычитывать в get
YDB_READ_LIMIT = 51
# На какой процент включено получение профиля из YDB
YDB_PERCENTAGE = 100
# Флажок на то, надо ли использовать в коде профиль из YDB если он подходит по проценту из параметра выше
TRY_USE_YDB = True
