# -*- coding: utf-8 -*-

import os

import yenv

from passport.backend.api.settings.saml_sso import get_yandex_sp_config as get_yandex_sp_config_original


# Обязательная часть ----------------------------------------------------------

with open(os.path.join(os.path.dirname(__file__), 'device_id_blacklist.txt')) as f:
    DEVICE_ID_BLACKLIST = set([
        line.strip()
        for line in f
        if line.strip()
    ])

# Кастомные настройки ---------------------------------------------------------

# Проблемы с YDB?
# TRY_USE_YDB = False
# DRIVE_AUTH_FORWARDING_API_ENABLED = False

# Проблемы с телефонией?
# PHONE_CONFIRMATION_CALL_ENABLED = False

# Отключить челленджи?
# AUTH_PROFILE_CHALLENGE_ENABLED = False

FAMILY_DISABLE_SMS_INVITE = False

USE_PHONE_SQUATTER = yenv.name == 'localhost' and yenv.type in ('development', 'testing', 'rc', 'production')
PHONE_SQUATTER_DRY_RUN = False

USE_NEW_SUGGEST_BY_PHONE = yenv.type in {'development', 'testing', 'rc', 'production'}

#Добавил третий тестовый телефон. Нужно убрать после релиза обычных settings с этим телефоном
TEST_PHONE_NUMBERS_ACCEPTING_FAKE_CODE = (
    '+70000000000',
    '+70001122334',
    '+70003456689',
)

MDA_EXPERIMENTAL_COOKIE_DENOMINATOR = 1

if yenv.type in ('development', 'testing', 'rc', 'production'):
    def get_yandex_sp_config():
        result = get_yandex_sp_config_original()
        result['sp']['NameIDFormat'] = 'urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified'
        return result

if yenv.name == 'localhost' and yenv.type in {'development', 'testing', 'rc', 'production'}:
    EMAIL_CODE_CHALLENGE_ENABLED = True
    EMAIL_CODE_CHALLENGE_ENABLED_DENOMINATOR = 1
