# -*- coding: utf-8 -*-
import datetime
import json
import unittest

from passport.backend.api.test.utils import check_bundle_form as check_form
from passport.backend.api.views.bundle.account.options import forms
from passport.backend.core.test.consts import TEST_PLUS_SUBSCRIBER_STATE1_JSON
from passport.backend.core.test.time_utils.time_utils import DatetimeNow
from passport.backend.utils.time import (
    get_unixtime,
    unixtime_to_datetime,
)


class TestForms(unittest.TestCase):
    def test_account_options_form(self):
        valid_params = [
            (
                {
                    'password_update_timestamp': 223344,
                },
                {
                    'uid': None,
                    'admin_name': None,
                    'billing_features': None,
                    'comment': None,
                    'is_enabled': None,
                    'is_app_password_enabled': None,
                    'is_shared': None,
                    'is_maillist': None,
                    'is_mailbox_frozen': None,
                    'is_connect_admin': None,
                    'is_easily_hacked': None,
                    'is_password_change_required': None,
                    'password_update_timestamp': 223344,
                    'global_logout': None,
                    'revoke_tokens': None,
                    'revoke_app_passwords': None,
                    'revoke_web_sessions': None,
                    'notify_by_sms': None,
                    'max_change_frequency_in_days': None,
                    'multisession_uid': None,
                    'show_2fa_promo': None,
                    'audience_on': None,
                    'external_organization_ids': None,
                    'magic_link_login_forbidden': None,
                    'qr_code_login_forbidden': None,
                    'sms_code_login_forbidden': None,
                    'takeout_subscription': None,
                    'show_fio_in_public_name': None,
                    'force_challenge': None,
                    'sms_2fa_on': None,
                    'forbid_disabling_sms_2fa': None,
                    'takeout_delete_subscription': None,
                    'personal_data_public_access_allowed': None,
                    'personal_data_third_party_processing_allowed': None,
                    'family_pay_enabled': None,
                    'plus_enabled': None,
                    'plus_trial_used_ts': None,
                    'plus_subscription_stopped_ts': None,
                    'plus_subscription_expire_ts': None,
                    'plus_next_charge_ts': None,
                    'ott_subscription': None,
                    'plus_family_role': None,
                    'plus_cashback_enabled': None,
                    'plus_subscription_level': None,
                    'plus_is_frozen': None,
                    'plus_subscriber_state': None,
                    'is_documents_agreement_accepted': None,
                    'is_dzen_sso_prohibited': None,
                    'can_manage_children': None,
                },
            ),
            (
                {
                    'admin_name': 'test-admin',
                    'billing_features': json.dumps({
                        'cashback-100': {
                            'in_trial': True,
                            'paid_trial': False,
                            'region_id': 0,
                            'trial_duration': 0,
                            'brand': 'brand',
                        },
                        'music_premium': {
                            'region_id': 9999
                        },
                        'passport': {},
                    }),
                    'comment': 'some comment',
                    'is_enabled': 'yes',
                    'is_app_password_enabled': 'true',
                    'is_shared': 'true',
                    'is_maillist': 'true',
                    'is_mailbox_frozen': 'true',
                    'is_connect_admin': 'true',
                    'is_easily_hacked': 'true',
                    'is_password_change_required': 'yes',
                    'password_update_timestamp': 123456,
                    'global_logout': 'true',
                    'revoke_tokens': 'true',
                    'revoke_app_passwords': 'true',
                    'revoke_web_sessions': 'true',
                    'notify_by_sms': 'true',
                    'max_change_frequency_in_days': 12345,
                    'multisession_uid': 5678,
                    'show_2fa_promo': 'yes',
                    'audience_on': 'yes',
                    'external_organization_ids': '1,3,2,1',
                    'magic_link_login_forbidden': 'true',
                    'qr_code_login_forbidden': 'true',
                    'sms_code_login_forbidden': 'true',
                    'takeout_subscription': 'true',
                    'show_fio_in_public_name': 'true',
                    'force_challenge': 'true',
                    'sms_2fa_on': 'true',
                    'forbid_disabling_sms_2fa': 'true',
                    'takeout_delete_subscription': 'true',
                    'personal_data_public_access_allowed': 'true',
                    'personal_data_third_party_processing_allowed': 'true',
                    'family_pay_enabled': 'eda',
                    'plus_enabled': 'true',
                    'plus_trial_used_ts': 12345,
                    'plus_subscription_stopped_ts': 56789,
                    'plus_subscription_expire_ts': 45678,
                    'plus_next_charge_ts': 34567,
                    'ott_subscription': 'YA_PLUS',
                    'plus_family_role': 'PARENT',
                    'plus_cashback_enabled': 'true',
                    'plus_subscription_level': 123,
                    'plus_is_frozen': 'true',
                    'plus_subscriber_state': TEST_PLUS_SUBSCRIBER_STATE1_JSON,
                    'is_documents_agreement_accepted': 'true',
                    'is_dzen_sso_prohibited': 'true',
                    'can_manage_children': 'true',
                },
                {
                    'uid': None,
                    'admin_name': 'test-admin',
                    'billing_features': {
                        'cashback-100': {
                            'in_trial': True,
                            'paid_trial': False,
                            'region_id': 0,
                            'trial_duration': 0,
                            'brand': 'brand',
                        },
                        'music_premium': {
                            'region_id': 9999
                        },
                        'passport': {},
                    },
                    'comment': 'some comment',
                    'is_enabled': True,
                    'is_app_password_enabled': True,
                    'is_shared': True,
                    'is_maillist': True,
                    'is_mailbox_frozen': True,
                    'is_connect_admin': True,
                    'is_easily_hacked': True,
                    'is_password_change_required': True,
                    'password_update_timestamp': 123456,
                    'global_logout': True,
                    'revoke_tokens': True,
                    'revoke_app_passwords': True,
                    'revoke_web_sessions': True,
                    'notify_by_sms': True,
                    'max_change_frequency_in_days': 12345,
                    'multisession_uid': 5678,
                    'show_2fa_promo': True,
                    'audience_on': True,
                    'external_organization_ids': [1, 3, 2],
                    'magic_link_login_forbidden': True,
                    'qr_code_login_forbidden': True,
                    'sms_code_login_forbidden': True,
                    'takeout_subscription': True,
                    'show_fio_in_public_name': True,
                    'force_challenge': True,
                    'sms_2fa_on': True,
                    'forbid_disabling_sms_2fa': True,
                    'takeout_delete_subscription': True,
                    'personal_data_public_access_allowed': True,
                    'personal_data_third_party_processing_allowed': True,
                    'family_pay_enabled': 'eda',
                    'plus_enabled': True,
                    'plus_trial_used_ts': datetime.datetime.fromtimestamp(12345),
                    'plus_subscription_stopped_ts': datetime.datetime.fromtimestamp(56789),
                    'plus_subscription_expire_ts': datetime.datetime.fromtimestamp(45678),
                    'plus_next_charge_ts': datetime.datetime.fromtimestamp(34567),
                    'ott_subscription': 'YA_PLUS',
                    'plus_family_role': 'PARENT',
                    'plus_cashback_enabled': True,
                    'plus_subscription_level': 123,
                    'plus_is_frozen': True,
                    'plus_subscriber_state': TEST_PLUS_SUBSCRIBER_STATE1_JSON,
                    'is_documents_agreement_accepted': True,
                    'is_dzen_sso_prohibited': True,
                    'can_manage_children': True,
                },
            ),
            (
                {
                    'uid': 1234,
                    'admin_name': 'test-admin',
                    'billing_features': '{}',
                    'comment': 'some comment',
                    'is_enabled': 'false',
                    'is_app_password_enabled': 'false',
                    'is_shared': 'false',
                    'is_maillist': 'false',
                    'is_mailbox_frozen': 'false',
                    'is_connect_admin': 'false',
                    'is_easily_hacked': 'false',
                    'is_password_change_required': 'false',
                    'password_update_timestamp': '123456',
                    'global_logout': 'false',
                    'revoke_tokens': 'false',
                    'revoke_app_passwords': 'false',
                    'revoke_web_sessions': 'false',
                    'notify_by_sms': 'false',
                    'max_change_frequency_in_days': '12345',
                    'show_2fa_promo': '0',
                    'audience_on': 'no',
                    'external_organization_ids': '',
                    'magic_link_login_forbidden': 'false',
                    'qr_code_login_forbidden': 'false',
                    'sms_code_login_forbidden': 'false',
                    'takeout_subscription': 'false',
                    'show_fio_in_public_name': 'false',
                    'force_challenge': 'false',
                    'sms_2fa_on': 'false',
                    'forbid_disabling_sms_2fa': 'false',
                    'takeout_delete_subscription': 'false',
                    'personal_data_public_access_allowed': 'false',
                    'personal_data_third_party_processing_allowed': 'false',
                    'family_pay_enabled': 'eda,taxi',
                    'plus_enabled': 'false',
                    'plus_trial_used_ts': 0,
                    'plus_subscription_stopped_ts': 0,
                    'plus_subscription_expire_ts': 0,
                    'plus_next_charge_ts': 0,
                    'ott_subscription': 'YA_PLUS_SUPER',
                    'plus_family_role': 'CHILD',
                    'plus_cashback_enabled': 'false',
                    'plus_subscription_level': 999,
                    'plus_is_frozen': 'false',
                    'plus_subscriber_state': '{}',
                    'is_documents_agreement_accepted': 'false',
                    'is_dzen_sso_prohibited': 'false',
                    'can_manage_children': 'false',
                },
                {
                    'uid': 1234,
                    'admin_name': 'test-admin',
                    'billing_features': dict(),
                    'comment': 'some comment',
                    'is_enabled': False,
                    'is_app_password_enabled': False,
                    'is_shared': False,
                    'is_maillist': False,
                    'is_mailbox_frozen': False,
                    'is_connect_admin': False,
                    'is_easily_hacked': False,
                    'is_password_change_required': False,
                    'password_update_timestamp': 123456,
                    'global_logout': False,
                    'revoke_tokens': False,
                    'revoke_app_passwords': False,
                    'revoke_web_sessions': False,
                    'notify_by_sms': False,
                    'max_change_frequency_in_days': 12345,
                    'multisession_uid': None,
                    'show_2fa_promo': False,
                    'audience_on': False,
                    'external_organization_ids': (),
                    'magic_link_login_forbidden': False,
                    'qr_code_login_forbidden': False,
                    'sms_code_login_forbidden': False,
                    'takeout_subscription': False,
                    'show_fio_in_public_name': False,
                    'force_challenge': False,
                    'sms_2fa_on': False,
                    'forbid_disabling_sms_2fa': False,
                    'takeout_delete_subscription': False,
                    'personal_data_public_access_allowed': False,
                    'personal_data_third_party_processing_allowed': False,
                    'family_pay_enabled': 'eda,taxi',
                    'plus_enabled': False,
                    'plus_trial_used_ts': datetime.datetime.fromtimestamp(0),
                    'plus_subscription_stopped_ts': datetime.datetime.fromtimestamp(0),
                    'plus_subscription_expire_ts': datetime.datetime.fromtimestamp(0),
                    'plus_next_charge_ts': datetime.datetime.fromtimestamp(0),
                    'ott_subscription': 'YA_PLUS_SUPER',
                    'plus_family_role': 'CHILD',
                    'plus_cashback_enabled': False,
                    'plus_subscription_level': 999,
                    'plus_is_frozen': False,
                    'plus_subscriber_state': '',
                    'is_documents_agreement_accepted': False,
                    'is_dzen_sso_prohibited': False,
                    'can_manage_children': False,
                },
            ),
            (
                {
                    'uid': 1234,
                    'admin_name': 'test-admin',
                    'billing_features': '{}',
                    'comment': 'some comment',
                    'is_enabled': 'false',
                    'is_app_password_enabled': 'false',
                    'is_shared': 'false',
                    'is_maillist': 'false',
                    'is_mailbox_frozen': 'false',
                    'is_connect_admin': 'false',
                    'is_easily_hacked': 'false',
                    'is_password_change_required': 'false',
                    'password_update_timestamp': '123456',
                    'global_logout': 'false',
                    'revoke_tokens': 'false',
                    'revoke_app_passwords': 'false',
                    'revoke_web_sessions': 'false',
                    'notify_by_sms': 'false',
                    'max_change_frequency_in_days': '12345',
                    'show_2fa_promo': '0',
                    'audience_on': 'no',
                    'external_organization_ids': '',
                    'magic_link_login_forbidden': 'false',
                    'qr_code_login_forbidden': 'false',
                    'sms_code_login_forbidden': 'false',
                    'takeout_subscription': 'false',
                    'show_fio_in_public_name': 'false',
                    'force_challenge': 'false',
                    'sms_2fa_on': 'false',
                    'forbid_disabling_sms_2fa': 'false',
                    'takeout_delete_subscription': 'false',
                    'personal_data_public_access_allowed': 'false',
                    'personal_data_third_party_processing_allowed': 'false',
                    'family_pay_enabled': '',
                    'plus_enabled': 'false',
                    'plus_trial_used_ts': 0,
                    'plus_subscription_stopped_ts': 0,
                    'plus_subscription_expire_ts': 0,
                    'plus_next_charge_ts': 0,
                    'ott_subscription': 'YA_PLUS_SUPER',
                    'plus_family_role': 'CHILD',
                    'plus_cashback_enabled': 'false',
                    'plus_subscription_level': 999,
                    'plus_is_frozen': 'false',
                    'plus_subscriber_state': '{}',
                    'is_documents_agreement_accepted': 'false',
                    'is_dzen_sso_prohibited': 'false',
                    'can_manage_children': 'false',
                },
                {
                    'uid': 1234,
                    'admin_name': 'test-admin',
                    'billing_features': dict(),
                    'comment': 'some comment',
                    'is_enabled': False,
                    'is_app_password_enabled': False,
                    'is_shared': False,
                    'is_maillist': False,
                    'is_mailbox_frozen': False,
                    'is_connect_admin': False,
                    'is_easily_hacked': False,
                    'is_password_change_required': False,
                    'password_update_timestamp': 123456,
                    'global_logout': False,
                    'revoke_tokens': False,
                    'revoke_app_passwords': False,
                    'revoke_web_sessions': False,
                    'notify_by_sms': False,
                    'max_change_frequency_in_days': 12345,
                    'multisession_uid': None,
                    'show_2fa_promo': False,
                    'audience_on': False,
                    'external_organization_ids': (),
                    'magic_link_login_forbidden': False,
                    'qr_code_login_forbidden': False,
                    'sms_code_login_forbidden': False,
                    'takeout_subscription': False,
                    'show_fio_in_public_name': False,
                    'force_challenge': False,
                    'sms_2fa_on': False,
                    'forbid_disabling_sms_2fa': False,
                    'takeout_delete_subscription': False,
                    'personal_data_public_access_allowed': False,
                    'personal_data_third_party_processing_allowed': False,
                    'family_pay_enabled': '',
                    'plus_enabled': False,
                    'plus_trial_used_ts': datetime.datetime.fromtimestamp(0),
                    'plus_subscription_stopped_ts': datetime.datetime.fromtimestamp(0),
                    'plus_subscription_expire_ts': datetime.datetime.fromtimestamp(0),
                    'plus_next_charge_ts': datetime.datetime.fromtimestamp(0),
                    'ott_subscription': 'YA_PLUS_SUPER',
                    'plus_family_role': 'CHILD',
                    'plus_cashback_enabled': False,
                    'plus_subscription_level': 999,
                    'plus_is_frozen': False,
                    'plus_subscriber_state': '',
                    'is_documents_agreement_accepted': False,
                    'is_dzen_sso_prohibited': False,
                    'can_manage_children': False,
                },
            ),
        ]

        invalid_params = [
            (
                {},
                ['form.invalid'],
            ),
            (
                {
                    'uid': 234,
                },
                ['form.invalid'],
            ),
            (
                {
                    'uid': 123,
                    'multisession_uid': 456,
                    'is_shared': '1',
                },
                ['form.invalid'],
            ),
            (
                {
                    'uid': 234,
                    'password_update_timestamp': 123456,
                    'notify_by_sms': True,
                },
                ['is_password_change_required.empty'],
            ),
            (
                {
                    'uid': 234,
                    'is_password_change_required': '1',
                    'max_change_frequency_in_days': -7,
                },
                ['max_change_frequency_in_days.invalid'],
            ),
            (
                {
                    'uid': 234,
                    'max_change_frequency_in_days': 7,
                },
                ['form.invalid'],
            ),
            (
                {
                    'uid': 234,
                    'show_2fa_promo': True,
                },
                ['form.invalid'],
            ),
            (
                {
                    'uid': 234,
                    'is_password_change_required': '1',
                    'comment': 'some comment',
                },
                ['form.invalid'],
            ),
            (
                {
                    'uid': 345,
                    'audience_on': 'asd',
                },
                ['audience_on.invalid'],
            ),
            (
                {
                    'uid': 234,
                    'external_organization_ids': ','.join(map(str, range(501))),
                },
                ['external_organization_ids.list_too_long'],
            ),
            (
                {
                    'uid': 234,
                    'family_pay_enabled': 'eda,,',
                },
                ['family_pay_enabled.invalid'],
            ),
            (
                {
                    'uid': 234,
                    'family_pay_enabled': 'eda!',
                },
                ['family_pay_enabled.invalid'],
            ),
        ]

        check_form(forms.AccountOptionsForm(), invalid_params, valid_params, None)


# TODO: По-моему, вот этих тестов нет в общем классе - их бы перенести туда, так как bundle/plus больше не используется
class TestPlusChangeAttributesForm(unittest.TestCase):
    def test_plus_change_attributes_form(self):
        invalid_params = [
            (
                # uid обязателен в форме
                {},
                ['uid.empty'],
            ),
            (
                # помимо uid должно быть что-то ещё, чего надо изменить из атрибутов
                {'uid': '123'},
                ['form.invalid'],
            ),
            (
                # plus_subscription_level должен быть >= 0
                {
                    'uid': '123',
                    'plus_subscription_level': '-1',
                },
                [
                    'plus_subscription_level.invalid',
                ],
            ),
            (
                # plus_subscription_level должен быть <= 1000
                {
                    'uid': '123',
                    'plus_subscription_level': '1001',
                },
                [
                    'plus_subscription_level.invalid',
                ],
            ),
            (
                # неверные значения полей в форме
                {
                    'uid': '123',
                    'plus_enabled': 'foobar',
                    'plus_trial_used_ts': 'foobar',
                    'plus_subscription_stopped_ts': 'foobar',
                    'plus_subscription_expire_ts': 'foobar',
                    'plus_next_charge_ts': 'foobar',
                    'ott_subscription': 'invalid-ott-subscription-value',
                    'plus_family_role': 'invalid-plus-family-role-value',
                    'plus_cashback_enabled': 'foobar',
                    'plus_subscription_level': 'foobar',
                    'plus_is_frozen': 'foobar',
                },
                [
                    'plus_enabled.invalid',
                    'plus_trial_used_ts.invalid',
                    'plus_subscription_stopped_ts.invalid',
                    'plus_subscription_expire_ts.invalid',
                    'plus_next_charge_ts.invalid',
                    'ott_subscription.invalid',
                    'plus_family_role.invalid',
                    'plus_cashback_enabled.invalid',
                    'plus_subscription_level.invalid',
                    'plus_is_frozen.invalid',
                ],
            ),
        ]
        valid_params = [
            ({
                'uid': '123',
                'plus_enabled': '1',
            }, {
                'uid': 123,
                'plus_enabled': True,
                'plus_trial_used_ts': None,
                'plus_subscription_stopped_ts': None,
                'plus_subscription_expire_ts': None,
                'plus_next_charge_ts': None,
                'ott_subscription': None,
                'plus_family_role': None,
                'plus_cashback_enabled': None,
                'plus_subscription_level': None,
                'plus_is_frozen': None,
            }),
            ({
                'uid': '123',
                'plus_enabled': '1',
                'plus_trial_used_ts': '0',
                'plus_subscription_stopped_ts': '0',
                'plus_subscription_expire_ts': '0',
                'plus_next_charge_ts': '0',
                'ott_subscription': forms.OTT_SUBSCRIPTIONS[0],  # любое валидное значение
                'plus_family_role': forms.PLUS_FAMILY_ROLES[0],  # любое валидное значение
                'plus_cashback_enabled': '1',
                'plus_subscription_level': '3',
                'plus_is_frozen': '1',
            }, {
                'uid': 123,
                'plus_enabled': True,
                'plus_trial_used_ts': datetime.datetime.fromtimestamp(0),
                'plus_subscription_stopped_ts': datetime.datetime.fromtimestamp(0),
                'plus_subscription_expire_ts': datetime.datetime.fromtimestamp(0),
                'plus_next_charge_ts': datetime.datetime.fromtimestamp(0),
                'ott_subscription': forms.OTT_SUBSCRIPTIONS[0],
                'plus_family_role': forms.PLUS_FAMILY_ROLES[0],
                'plus_cashback_enabled': True,
                'plus_subscription_level': 3,
                'plus_is_frozen': True,
            }),
            ({
                'uid': '123',
                'plus_enabled': '1',
                'plus_trial_used_ts': '',
                'plus_subscription_stopped_ts': '',
                'plus_subscription_expire_ts': '',
                'plus_next_charge_ts': '',
                'ott_subscription': '',
                'plus_family_role': '',
                'plus_cashback_enabled': '',
            }, {
                'uid': 123,
                'plus_enabled': True,
                'plus_trial_used_ts': datetime.datetime.fromtimestamp(0),
                'plus_subscription_stopped_ts': datetime.datetime.fromtimestamp(0),
                'plus_subscription_expire_ts': datetime.datetime.fromtimestamp(0),
                'plus_next_charge_ts': datetime.datetime.fromtimestamp(0),
                'ott_subscription': '',  # пустая строка, чтобы различить, что параметр передали, но пустой
                'plus_family_role': '',  # пустая строка, чтобы различить, что параметр передали, но пустой
                'plus_cashback_enabled': False,
                'plus_subscription_level': None,
                'plus_is_frozen': None,
            }),
            ({
                'uid': '123',
                'plus_enabled': '1',
                'plus_trial_used_ts': str(get_unixtime()),
                'plus_subscription_stopped_ts': str(get_unixtime() - 3600),
                'plus_subscription_expire_ts': str(get_unixtime() - 3600 * 2),
                'plus_next_charge_ts': str(get_unixtime() - 3600 * 3),
            }, {
                'uid': 123,
                'plus_enabled': True,
                'plus_trial_used_ts': DatetimeNow(),
                'plus_subscription_stopped_ts': DatetimeNow(timestamp=unixtime_to_datetime(get_unixtime() - 3600)),
                'plus_subscription_expire_ts': DatetimeNow(timestamp=unixtime_to_datetime(get_unixtime() - 3600 * 2)),
                'plus_next_charge_ts': DatetimeNow(timestamp=unixtime_to_datetime(get_unixtime() - 3600 * 3)),
                'ott_subscription': None,
                'plus_family_role': None,
                'plus_cashback_enabled': None,
                'plus_subscription_level': None,
                'plus_is_frozen': None,
            }),
            ({
                'uid': '123',
                'plus_enabled': '1',
                'plus_trial_used_ts': str(2 ** 32),
                'plus_subscription_stopped_ts': str(2 ** 32),
                'plus_subscription_expire_ts': str(2 ** 32),
                'plus_next_charge_ts': str(2 ** 32),
            }, {
                'uid': 123,
                'plus_enabled': True,
                'plus_trial_used_ts': DatetimeNow(timestamp=unixtime_to_datetime(2 ** 32)),
                'plus_subscription_stopped_ts': DatetimeNow(timestamp=unixtime_to_datetime(2 ** 32)),
                'plus_subscription_expire_ts': DatetimeNow(timestamp=unixtime_to_datetime(2 ** 32)),
                'plus_next_charge_ts': DatetimeNow(timestamp=unixtime_to_datetime(2 ** 32)),
                'ott_subscription': None,
                'plus_family_role': None,
                'plus_cashback_enabled': None,
                'plus_subscription_level': None,
                'plus_is_frozen': None,
            }),
        ]

        for ott_subscription_value in forms.OTT_SUBSCRIPTIONS + ['']:
            valid_params.append((
                {
                    'uid': '123',
                    'ott_subscription': ott_subscription_value,
                },
                {
                    'uid': 123,
                    'plus_enabled': None,
                    'plus_trial_used_ts': None,
                    'plus_subscription_stopped_ts': None,
                    'plus_subscription_expire_ts': None,
                    'plus_next_charge_ts': None,
                    'plus_family_role': None,
                    'ott_subscription': ott_subscription_value,
                    'plus_cashback_enabled': None,
                    'plus_subscription_level': None,
                    'plus_is_frozen': None,
                }
            ))

        for plus_family_role_value in forms.PLUS_FAMILY_ROLES + ['']:
            valid_params.append((
                {
                    'uid': '123',
                    'plus_family_role': plus_family_role_value,
                },
                {
                    'uid': 123,
                    'plus_enabled': None,
                    'plus_trial_used_ts': None,
                    'plus_subscription_stopped_ts': None,
                    'plus_subscription_expire_ts': None,
                    'plus_next_charge_ts': None,
                    'ott_subscription': None,
                    'plus_family_role': plus_family_role_value,
                    'plus_cashback_enabled': None,
                    'plus_subscription_level': None,
                    'plus_is_frozen': None,
                }
            ))

        check_form(forms.PlusChangeAttributesForm(), invalid_params, valid_params, None)
