# -*- coding: utf-8 -*-

from passport.backend.api.views.bundle.account.account_options import AccountOptionsViewV1
from passport.backend.api.views.bundle.account.aliases import (
    AccountAliasCreateView,
    AccountAliasDeleteView,
    AccountBankPhoneNumberAliasCreateView,
    AccountBankPhoneNumberAliasDeleteView,
    AccountPddAliasLoginCreateView,
    AccountPddAliasLoginDeleteView,
    AccountPddCreateView,
)
from passport.backend.api.views.bundle.account.app_passwords import (
    AppPasswordCreatedNotification,
    AppPasswordsActivator,
    AppPasswordsDeactivator,
)
from passport.backend.api.views.bundle.account.check_exists import AccountCheckExistsView
from passport.backend.api.views.bundle.account.delete import (
    AccountDeleteByCredentialsView,
    AccountDeleteCheckAnswerViewV2,
    AccountDeleteCommitViewV2,
    AccountDeleteConfirmEmailViewV2,
    AccountDeleteConfirmPhoneViewV2,
    AccountDeleteSendEmailCodeViewV2,
    AccountDeleteSendPhoneCodeViewV2,
    AccountDeleteSubmitViewV2,
    AccountDeleteView,
)
from passport.backend.api.views.bundle.account.events.controllers import EventsView
from passport.backend.api.views.bundle.account.federal_change import FederalChangeView
from passport.backend.api.views.bundle.account.flush_pdd import (
    FlushPddCommit,
    FlushPddSubmit,
)
from passport.backend.api.views.bundle.account.get_account_info import (
    GetAccountFullInfoView,
    GetAccountInfoFromTrackView,
    GetAccountShortInfoView,
)
from passport.backend.api.views.bundle.account.history.controllers import (
    ChallengeView,
    HistoryView,
    HistoryViewOld,
)
from passport.backend.api.views.bundle.account.lastauth.controllers import LastauthView
from passport.backend.api.views.bundle.account.logout.controllers import AccountLogoutView
from passport.backend.api.views.bundle.account.migrate_mailish import MigrateMailish
from passport.backend.api.views.bundle.account.notifications.controllers import AccountModificationNotify
from passport.backend.api.views.bundle.account.options.controllers import (
    AccountOptionsView,
    PlusChangeAttributesView,
)
from passport.backend.api.views.bundle.account.password_options import PasswordOptionsView
from passport.backend.api.views.bundle.account.phonish import (
    AccountPhonishCanLoginView,
    AccountPhonishDisableAuth,
    AccountPhonishDisableAuthByXToken,
    AccountPhonishUidByPhoneView,
)
from passport.backend.api.views.bundle.account.questions.controllers import (
    QuestionsAddOptional,
    QuestionsChangeView,
    QuestionsCheckAnswerView,
    QuestionsCheckAnswerViewV2,
    QuestionsGetQuestionView,
    QuestionsSetQuestionView,
)
from passport.backend.api.views.bundle.account.questions.history import (
    CheckQuestionAnswerHistoryView,
    GetQuestionsHistoryView,
)
from passport.backend.api.views.bundle.account.reset import (
    ResetAvatarView,
    ResetDisplayNameView,
    ResetEmailView,
    ResetPhoneView,
    ResetQuestionView,
)
from passport.backend.api.views.bundle.account.secrets import (
    SecretsDeleteBrowserKeyView,
    SecretsReadBrowserKeyView,
    SecretsReadPassmanRecoveryKeyView,
    SecretsWriteBrowserKeyView,
    SecretsWritePassmanRecoveryKeyView,
)
from passport.backend.api.views.bundle.account.set_password import AccountSetPasswordView
from passport.backend.api.views.bundle.account.subscriptions import (
    SubscribeView,
    UnsubscribeCommitView,
    UnsubscribeSubmitView,
)
from passport.backend.api.views.bundle.account.update_personal_info import (
    ChangeLanguageView,
    UpdateAccountPersonalInfoView,
    UpdateScholarPersonalInfoView,
)
from passport.backend.api.views.bundle.account.userapprove.controllers import (
    UserApproveCommitView,
    UserApproveSubmitView,
)


__all__ = [
    'AccountOptionsViewV1',
    'AccountAliasCreateView',
    'AccountPddCreateView',
    'AccountAliasDeleteView',
    'AccountPddAliasLoginCreateView',
    'AccountPddAliasLoginDeleteView',
    'AccountBankPhoneNumberAliasCreateView',
    'AccountBankPhoneNumberAliasDeleteView',
    'AccountModificationNotify',
    'AppPasswordCreatedNotification',
    'AppPasswordsActivator',
    'AppPasswordsDeactivator',
    'AccountCheckExistsView',
    'AccountDeleteCheckAnswerViewV2',
    'AccountDeleteCommitViewV2',
    'AccountDeleteConfirmEmailViewV2',
    'AccountDeleteConfirmPhoneViewV2',
    'AccountDeleteSendEmailCodeViewV2',
    'AccountDeleteSendPhoneCodeViewV2',
    'AccountDeleteSubmitViewV2',
    'AccountDeleteView',
    'ChallengeView',
    'ChangeLanguageView',
    'EventsView',
    'FederalChangeView',
    'FlushPddCommit',
    'FlushPddSubmit',
    'GetAccountFullInfoView',
    'GetAccountInfoFromTrackView',
    'GetAccountShortInfoView',
    'HistoryView',
    'HistoryViewOld',
    'LastauthView',
    'AccountLogoutView',
    'MigrateMailish',
    'AccountOptionsView',
    'PlusChangeAttributesView',
    'PasswordOptionsView',
    'AccountPhonishCanLoginView',
    'AccountPhonishDisableAuthByXToken',
    'AccountPhonishUidByPhoneView',
    'QuestionsAddOptional',
    'QuestionsChangeView',
    'QuestionsCheckAnswerView',
    'QuestionsCheckAnswerViewV2',
    'QuestionsGetQuestionView',
    'QuestionsSetQuestionView',
    'CheckQuestionAnswerHistoryView',
    'GetQuestionsHistoryView',
    'SecretsDeleteBrowserKeyView',
    'SecretsReadBrowserKeyView',
    'SecretsReadPassmanRecoveryKeyView',
    'SecretsWriteBrowserKeyView',
    'SecretsWritePassmanRecoveryKeyView',
    'AccountSetPasswordView',
    'SubscribeView',
    'UnsubscribeCommitView',
    'UnsubscribeSubmitView',
    'UpdateAccountPersonalInfoView',
    'UserApproveCommitView',
    'UserApproveSubmitView',
    'ResetAvatarView',
    'ResetDisplayNameView',
    'ResetEmailView',
    'ResetPhoneView',
    'ResetQuestionView',
]
