# -*- coding: utf-8 -*-
from passport.backend.core import validators


APP_TYPE_MAIL = 'mail'
APP_TYPE_CALENDAR = 'calendar'
APP_TYPE_DISK = 'disk'
APP_TYPE_ABOOK = 'abook'
APP_TYPE_CHAT = 'chat'
APP_TYPE_MAGNITOLA = 'magnitola'

APP_TYPES = (
    APP_TYPE_MAIL,
    APP_TYPE_CALENDAR,
    APP_TYPE_DISK,
    APP_TYPE_ABOOK,
    APP_TYPE_CHAT,
    APP_TYPE_MAGNITOLA,
)


class AppPasswordCreateForm(validators.Schema):
    uid = validators.Uid(not_empty=True)
    app_type = validators.OneOf(APP_TYPES, not_empty=True)
    app_name = validators.String(strip=True, if_missing='')
