# -*- coding: utf-8 -*-
from passport.backend.api.views.bundle.account.app_passwords.forms import AppPasswordCreateForm
from passport.backend.api.views.bundle.base import BaseBundleView
from passport.backend.api.views.bundle.mixins import (
    BundleAccountGetterMixin,
    UserMetaDataMixin,
)
from passport.backend.api.views.bundle.mixins.kolmogor import KolmogorMixin
from passport.backend.api.views.bundle.mixins.mail import MailMixin
from passport.backend.api.views.bundle.mixins.push import BundlePushMixin


GRANT = 'app_passwords.send_mail'


class AppPasswordCreatedNotification(
    BaseBundleView,
    BundleAccountGetterMixin,
    BundlePushMixin,
    KolmogorMixin,
    MailMixin,
    UserMetaDataMixin,
):
    require_track = False
    required_grants = [GRANT]
    basic_form = AppPasswordCreateForm

    def process_request(self):
        self.process_basic_form()
        self.get_account_by_uid(
            uid=self.form_values['uid'],
            emails=True,
        )
        self.send_account_modification_mail(
            event_name='app_password_add',
        )
        self.send_account_modification_push(
            event_name='app_password_add',
        )
