# -*- coding: utf-8 -*-
from passport.backend.api.views.bundle.base import BaseBundleView
from passport.backend.api.views.bundle.headers import HEADER_CONSUMER_CLIENT_IP
from passport.backend.api.views.bundle.mixins.account import BundleAccountGetterMixin


BASIC_GRANT = 'avatar.base'
EXTENDED_GRANT = 'avatar.by_uid'


class BaseAvatarBundleInternalView(BaseBundleView, BundleAccountGetterMixin):
    required_headers = [HEADER_CONSUMER_CLIENT_IP]
    required_grants = [BASIC_GRANT]
    require_track = False

    def process_request(self):
        self.process_basic_form()
        self.get_account_from_uid_or_session(
            by_uid_grant=EXTENDED_GRANT,
            check_disabled_on_deletion=True,
        )
        self.process()

    def process(self):
        raise NotImplementedError()  # pragma: no cover
