# -*- coding: utf-8 -*-

from passport.backend.core.runner.context_managers import UPDATE

from . import forms
from .base import BaseAvatarBundleInternalView


class AvatarYapicInternalSetDefault(BaseAvatarBundleInternalView):
    """Записывает значение ключа в account.default_avatar
    Внутренняя ручка для синхронизации данных с Yapic.
    Дергается сервисом Yapic по мере необходимости.
    За синхронизацию данных отвечает Yapic.
    """

    basic_form = forms.SetDefaultForm()

    def process(self):
        if self.account.person.default_avatar == self.form_values['key']:
            return

        with UPDATE(self.account, self.request.env, {'action': 'set_default_avatar', 'consumer': self.consumer}):
            self.account.person.default_avatar = self.form_values['key']
