# -*- coding: utf-8 -*-
from passport.backend.api.views.bundle.base import BaseBundleView
from passport.backend.api.views.bundle.mixins.account import BundleAccountGetterMixin
from passport.backend.core.historydb.account_history import AccountHistory

from .forms import EventsForm


ACCOUNT_HISTORY_BASIC_GRANT = 'history.base'
ACCOUNT_HISTORY_HISTORY_BY_UID_GRANT = 'history.by_uid'


class EventsView(BaseBundleView, BundleAccountGetterMixin):
    require_track = False

    basic_form = EventsForm

    required_grants = [ACCOUNT_HISTORY_BASIC_GRANT]

    def events(self, uid=None, to_ts=None, limit=None, hours_limit=None):
        ah = AccountHistory(uid=uid)
        events = ah.list(to_ts=to_ts, limit=limit, hours_limit=hours_limit)
        return events, ah.next_page_timestamp

    def process_request(self, *args, **kwargs):
        self.process_basic_form()
        self.get_account_from_uid_or_session(
            by_uid_grant=ACCOUNT_HISTORY_HISTORY_BY_UID_GRANT,
            check_disabled_on_deletion=True,
        )
        events, next_from_timestamp = self.events(
            uid=self.account.uid,
            to_ts=self.form_values['from_timestamp'],
            limit=self.form_values['limit'],
            hours_limit=self.form_values['hours_limit'],
        )
        events = sorted(events, key=lambda e: e.timestamp, reverse=True)
        self.response_values.update(
            next_from_timestamp=next_from_timestamp,
            events=[e._asdict() for e in events],
        )
