# -*- coding: utf-8 -*-
from passport.backend.core import validators
from passport.backend.core.conf import settings


HALF_A_YEAR_IN_HOURS = 24 * 365 / 2


class EventsForm(validators.Schema):
    uid = validators.Uid(not_empty=True, if_missing=None)
    from_timestamp = validators.Number(if_missing=None, if_empty=None)
    hours_limit = validators.Int(
        min=1,
        max=HALF_A_YEAR_IN_HOURS,
        not_empty=True,
        strip=True,
        if_missing=None,
    )

    def __init__(self, *args, **kwargs):
        self.add_field(
            'limit',
            validators.Int(
                min=1,
                max=settings.ACCOUNT_EVENTS_MAX_LIMIT,
                not_empty=True,
                if_missing=settings.ACCOUNT_EVENTS_DEFAULT_LIMIT,
            ),
        )
        super(EventsForm, self).__init__(*args, **kwargs)
