# -*- coding: utf-8 -*-
from passport.backend.api.views.bundle.exceptions import BaseBundleError


class AliasExistsError(BaseBundleError):
    """У пользователя уже есть алиас данного типа"""
    error = 'alias.exists'


class AliasNotAvailableError(BaseBundleError):
    """Алиас занят кем-то другим и назначить пользователю его нельзя"""
    error = 'alias.notavailable'


class AliasNotFoundError(BaseBundleError):
    """У пользователя не найден запрошенный алиас"""
    error = 'alias.not_found'


class MaxNumbersOfAliasesExceeded(BaseBundleError):
    """Превышено максимальное количество алиасов для ПДД-пользователя"""
    error = 'max_numbers_of_aliases.exceeded'


class PhoneForAliasNotBoundError(BaseBundleError):
    """Телефон, который хотят привязать как банковский по phone_id, не привязан к пользователю"""
    error = 'phone_id.not_bound'
