# -*- coding: utf-8 -*-
from passport.backend.api.views.bundle.account.external_data.base import BaseExternalInfoView
from passport.backend.api.views.bundle.account.external_data.forms import (
    MapsBookmarkInfoForm,
    PaginationForm,
)
from passport.backend.core.builders.datasync_api import (
    BaseDatasyncApiError,
    DatasyncApiObjectNotFoundError,
    get_personality_api,
)
from passport.backend.core.builders.geosearch import (
    BaseGeoSearchApiError,
    get_geosearch_api,
)
from werkzeug.utils import cached_property


class BaseMapsView(BaseExternalInfoView):
    external_service_errors = (BaseDatasyncApiError, )
    use_cache = False  # Данные уже берутся из DataSync

    @cached_property
    def personality_api(self):
        return get_personality_api()

    @property
    def common_datasync_args(self):
        return {
            'uid': self.account.uid,
            'limit': self.form_values['page_size'],
            'offset': self.form_values['page_size'] * (self.form_values['page'] - 1),
        }


class MapsBookmarksView(BaseMapsView):
    basic_form = PaginationForm

    def get_external_data(self):
        try:
            bookmarks = self.personality_api.maps_bookmarks(**self.common_datasync_args)
        except DatasyncApiObjectNotFoundError:
            bookmarks = []
        return {'bookmarks': bookmarks}


class MapsBookmarkInfo(BaseExternalInfoView):

    basic_form = MapsBookmarkInfoForm
    use_cache = False  # Кэшировать бессмысленно - ручка вызывается много раз для каждой закладки
    external_service_errors = (BaseGeoSearchApiError, )

    @cached_property
    def geosearch_api(self):
        return get_geosearch_api()

    def get_account_from_session_or_oauth_token(self, **kwargs):
        pass

    def get_external_data(self):
        uri_info = self.geosearch_api.get_info(self.form_values['uri'], lang=self.form_values['language'])
        return {'bookmark_info': uri_info}
