# -*- coding: utf-8 -*-
from passport.backend.api.views.bundle.account.external_data.base import BaseExternalInfoView
from passport.backend.api.views.bundle.account.external_data.forms import PaginationForm
from passport.backend.core.builders.market import (
    BaseMarketContentApiError,
    get_market_content_api,
)
from werkzeug.utils import cached_property


class MarketFavouritesView(BaseExternalInfoView):
    basic_form = PaginationForm
    oauth_scope = 'market:content-api'
    external_service_errors = (BaseMarketContentApiError, )
    use_cache = True
    cache_name = 'market_favourites'

    @cached_property
    def market_api(self):
        return get_market_content_api()

    @property
    def common_market_api_args(self):
        return dict(
            sessionid=self.cookies.get('Session_id'),
            host=self.host,
            oauth_token=self.oauth_token if self.authorization else None,
        )

    def get_external_data(self):
        response = self.market_api.user_wishlist(
            user_ip=self.client_ip,
            page=self.form_values['page'],
            count=self.form_values['page_size'],
            fields=['CATEGORY', 'PHOTO', 'PRICE'],
            **self.common_market_api_args
        )
        return {
            'items': response['items'],
        }


class MarketOrdersView(BaseExternalInfoView):
    basic_form = PaginationForm
    oauth_scope = 'market:content-api'
    external_service_errors = (BaseMarketContentApiError, )

    def process_request(self):
        if self.basic_form is not None:
            self.process_basic_form()
        self.get_account_from_session_or_oauth_token(required_scope=self.oauth_scope)
        self.response_values.update(orders=[])
